/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.ONSOracleRuntimeLBEventSubscriber;
import oracle.ucp.jdbc.oracle.OracleFailoverEventSubscriber;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.jdbc.oracle.rlb.ONSRuntimeLoadBalancingEvent;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.ProlongedTask;
import oracle.ucp.util.TaskManager;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.LOAD_BALANCING})
class ONSRuntimeLBEventHandlerTask
extends ProlongedTask<Object> {
    private final OracleFailoverEventSubscriber m_onsSubscriber;
    private boolean m_terminate = false;
    private final RACManagerImpl m_racMngr;
    private final String m_serviceName;
    private final boolean m_subscriberFailed;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    protected ONSRuntimeLBEventHandlerTask(String string, RACManagerImpl rACManagerImpl) throws UniversalConnectionPoolException {
        this(string, rACManagerImpl, null);
    }

    protected ONSRuntimeLBEventHandlerTask(String string, RACManagerImpl rACManagerImpl, OracleFailoverEventSubscriber oracleFailoverEventSubscriber) throws UniversalConnectionPoolException {
        this.m_racMngr = rACManagerImpl;
        ONS oNS = rACManagerImpl.getONS();
        if (oracleFailoverEventSubscriber == null) {
            ONSOracleRuntimeLBEventSubscriber oNSOracleRuntimeLBEventSubscriber = new ONSOracleRuntimeLBEventSubscriber(oNS, string);
            this.m_subscriberFailed = oNSOracleRuntimeLBEventSubscriber.isFailed();
            this.m_onsSubscriber = oNSOracleRuntimeLBEventSubscriber;
        } else {
            this.m_subscriberFailed = false;
            this.m_onsSubscriber = oracleFailoverEventSubscriber;
        }
        this.m_serviceName = string;
    }

    @Override
    public void run() {
        Notification notification = null;
        boolean bl2 = false;
        if (!this.m_subscriberFailed) {
            while (!this.isTerminate()) {
                try {
                    notification = this.m_onsSubscriber.receive();
                    if (notification != null) {
                        ONSRuntimeLoadBalancingEvent oNSRuntimeLoadBalancingEvent = new ONSRuntimeLoadBalancingEvent(this.m_serviceName, notification.body());
                        this.m_racMngr.handleLoadBalancingEvent(oNSRuntimeLoadBalancingEvent);
                        ClioSupport.ilogFine(null, null, null, null, "Runtime Load Balancing event triggered");
                    } else {
                        this.m_racMngr.setRCLBMetricsPolicyEnabled(false);
                    }
                }
                catch (UniversalConnectionPoolException universalConnectionPoolException) {
                    ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                    this.m_racMngr.setRCLBMetricsPolicyEnabled(false);
                    bl2 = true;
                }
                if (!bl2) continue;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    ClioSupport.ilogFinest(null, null, null, null, "sleep interrupted");
                }
                bl2 = false;
            }
        } else {
            ClioSupport.ilogFinest(null, null, null, null, "ONS subscriber failed");
        }
    }

    public boolean isTerminate() {
        return this.m_terminate;
    }

    public void setTerminate(boolean bl2) {
        this.m_terminate = bl2;
        if (bl2) {
            this.m_onsSubscriber.close();
        }
    }

    protected TaskManager getTaskManager() {
        return this.m_racMngr.getTaskManager();
    }

    @Override
    public boolean isCritical() {
        return true;
    }

    static {
        try {
            $$$methodRef$$$6 = ONSRuntimeLBEventHandlerTask.class.getDeclaredConstructor(String.class, RACManagerImpl.class, OracleFailoverEventSubscriber.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$5 = ONSRuntimeLBEventHandlerTask.class.getDeclaredConstructor(String.class, RACManagerImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$4 = ONSRuntimeLBEventHandlerTask.class.getDeclaredMethod("isCritical", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$3 = ONSRuntimeLBEventHandlerTask.class.getDeclaredMethod("getTaskManager", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = ONSRuntimeLBEventHandlerTask.class.getDeclaredMethod("setTerminate", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = ONSRuntimeLBEventHandlerTask.class.getDeclaredMethod("isTerminate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = ONSRuntimeLBEventHandlerTask.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

