/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.ONSException;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionException;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.logging.ClioSupport;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
class ONSSubscriberBase {
    static Mocker mocker;
    Subscriber m_subscriber = null;
    private boolean m_failed = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    ONSSubscriberBase(final ONS oNS, final String string) {
        try {
            this.m_subscriber = mocker.doPrivileged(new PrivilegedExceptionAction<Subscriber>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                public Subscriber run() {
                    try {
                        return mocker.createSubscriber(oNS, string);
                    }
                    catch (SubscriptionException subscriptionException) {
                        ClioSupport.ilogThrowing(null, null, null, null, subscriptionException);
                        ONSSubscriberBase.this.m_failed = true;
                        return null;
                    }
                    catch (ONSException oNSException) {
                        ClioSupport.ilogThrowing(null, null, null, null, oNSException);
                        ONSSubscriberBase.this.m_failed = true;
                        return null;
                    }
                }

                static {
                    try {
                        $$$methodRef$$$2 = 1.class.getDeclaredConstructor(ONSSubscriberBase.class, ONS.class, String.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            ClioSupport.ilogThrowing(null, null, null, null, privilegedActionException);
        }
    }

    ONSSubscriberBase(Subscriber subscriber) {
        this.m_subscriber = subscriber;
    }

    boolean isFailed() {
        return this.m_failed;
    }

    Notification receive(long l2) throws UniversalConnectionPoolException {
        try {
            Notification notification = this.receiveMoker(l2);
            ClioSupport.ilogFinest(null, null, null, null, "notification received");
            return notification;
        }
        catch (ONSException oNSException) {
            throw new UniversalConnectionPoolException(oNSException);
        }
    }

    Notification receiveMoker(long l2) {
        if (null != this.m_subscriber) {
            return 0L == l2 ? this.m_subscriber.receive(true) : this.m_subscriber.receive(l2);
        }
        return null;
    }

    public void close() {
        this.closeMocker();
        this.m_subscriber = null;
        ClioSupport.ilogFinest(null, null, null, null, "subscriber closed");
    }

    void closeMocker() {
        if (null != this.m_subscriber) {
            this.m_subscriber.close();
        }
    }

    static {
        try {
            $$$methodRef$$$7 = ONSSubscriberBase.class.getDeclaredConstructor(Subscriber.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$6 = ONSSubscriberBase.class.getDeclaredConstructor(ONS.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$5 = ONSSubscriberBase.class.getDeclaredMethod("access$002", ONSSubscriberBase.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$4 = ONSSubscriberBase.class.getDeclaredMethod("closeMocker", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$3 = ONSSubscriberBase.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = ONSSubscriberBase.class.getDeclaredMethod("receiveMoker", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = ONSSubscriberBase.class.getDeclaredMethod("receive", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = ONSSubscriberBase.class.getDeclaredMethod("isFailed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        mocker = new Mocker();
    }

    static class Mocker {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        Mocker() {
        }

        Subscriber createSubscriber(ONS oNS, String string) {
            return oNS != null ? oNS.createNewSubscriber(string, "", 30000L) : new Subscriber(string, "", 30000L);
        }

        Subscriber doPrivileged(PrivilegedExceptionAction<Subscriber> privilegedExceptionAction) throws PrivilegedActionException {
            return AccessController.doPrivileged(privilegedExceptionAction);
        }

        static {
            try {
                $$$methodRef$$$2 = Mocker.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = Mocker.class.getDeclaredMethod("doPrivileged", PrivilegedExceptionAction.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = Mocker.class.getDeclaredMethod("createSubscriber", ONS.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

