/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.NoAvailableConnectionsException;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.jdbc.ConnectionInitializationCallback;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class OracleConnectionConnectionPool
extends OracleJDBCConnectionPool {
    protected boolean useVanillaObjects = false;
    protected AtomicBoolean isFirstBorrow = new AtomicBoolean(true);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    public OracleConnectionConnectionPool(JDBCConnectionFactoryAdapter jDBCConnectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(jDBCConnectionFactoryAdapter);
    }

    public Connection getConnection(JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo) throws UniversalConnectionPoolException {
        Connection connection = (Connection)this.borrowConnection(jDBCConnectionRetrievalInfo).getPhysicalConnection();
        return connection;
    }

    @Override
    public UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        long l2 = this.computeBorrowGiveUpTimestamp();
        while (this.isStillOkayToBorrow(l2)) {
            ConnectionInitializationCallback connectionInitializationCallback;
            OracleUniversalPooledConnection oracleUniversalPooledConnection = (OracleUniversalPooledConnection)super.borrowConnection(connectionRetrievalInfo);
            try {
                if (this.isDRCPEnabled(oracleUniversalPooledConnection) && connectionRetrievalInfo.getLabels() == null) {
                    oracleUniversalPooledConnection.attachServerConnection(null);
                }
            }
            catch (SQLException sQLException) {
                throw new UniversalConnectionPoolException(sQLException);
            }
            Object object = oracleUniversalPooledConnection.getPhysicalConnection();
            if (this.isFirstBorrow.get()) {
                this.useVanillaObjects = !object.getClass().getName().startsWith("oracle.jdbc.proxy");
                this.isFirstBorrow.set(false);
            }
            oracleUniversalPooledConnection.getDelegator().setReplayable(!this.useVanillaObjects);
            if (this.useVanillaObjects) {
                this.core.connectionSource().setReplayable(false);
            }
            if (this.getConnectionLabelingCallback() == null && (connectionInitializationCallback = this.getConnectionInitializationCallback()) != null) {
                try {
                    connectionInitializationCallback.initialize((Connection)object);
                }
                catch (SQLException sQLException) {
                    throw UCPErrorHandler.newUniversalConnectionPoolException(271, sQLException);
                }
            }
            try {
                ((OracleConnection)object).beginRequest();
            }
            catch (SQLRecoverableException sQLRecoverableException) {
                oracleUniversalPooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                this.returnConnection(oracleUniversalPooledConnection);
                continue;
            }
            catch (Throwable throwable) {
                throw UCPErrorHandler.newUniversalConnectionPoolException(309, throwable);
            }
            return oracleUniversalPooledConnection;
        }
        throw new NoAvailableConnectionsException();
    }

    public boolean returnConnection(Connection connection) throws UniversalConnectionPoolException {
        boolean bl2 = this.returnUsedPhysicalConnection(connection);
        return bl2;
    }

    @Override
    public void returnConnection(UniversalPooledConnection universalPooledConnection) throws UniversalConnectionPoolException {
        OracleUniversalPooledConnection oracleUniversalPooledConnection = (OracleUniversalPooledConnection)universalPooledConnection;
        if (universalPooledConnection.getStatus() != UniversalPooledConnectionStatus.STATUS_BAD) {
            Object object = universalPooledConnection.getPhysicalConnection();
            try {
                ((OracleConnection)object).endRequest();
            }
            catch (Throwable throwable) {
                UniversalConnectionPoolException universalConnectionPoolException = UCPErrorHandler.newUniversalConnectionPoolException(310, throwable);
                universalPooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                super.returnConnection(universalPooledConnection);
                throw universalConnectionPoolException;
            }
        }
        try {
            if (this.isDRCPEnabled(oracleUniversalPooledConnection)) {
                oracleUniversalPooledConnection.detachServerConnection(null);
            }
        }
        catch (SQLException sQLException) {
            throw new UniversalConnectionPoolException(sQLException);
        }
        super.returnConnection(universalPooledConnection);
    }

    public boolean closeConnection(Connection connection) throws UniversalConnectionPoolException {
        boolean bl2 = this.closeUsedPhysicalConnection(connection);
        return bl2;
    }

    @Override
    protected boolean needToConfigureConnection(UniversalPooledConnection universalPooledConnection, Properties properties) throws UniversalConnectionPoolException {
        boolean bl2 = false;
        OracleUniversalPooledConnection oracleUniversalPooledConnection = (OracleUniversalPooledConnection)universalPooledConnection;
        try {
            if (this.isDRCPEnabled(universalPooledConnection)) {
                if (this.isDRCPMultiTagEnabled(universalPooledConnection) && this.getDRCPPLSQLCallbackName(universalPooledConnection) != null) {
                    return false;
                }
                bl2 = !oracleUniversalPooledConnection.attachServerConnection(properties);
            }
        }
        catch (SQLException sQLException) {
            throw new UniversalConnectionPoolException(sQLException);
        }
        return bl2;
    }

    @Override
    protected boolean isDRCPEnabled(UniversalPooledConnection universalPooledConnection) throws UniversalConnectionPoolException {
        OracleUniversalPooledConnection oracleUniversalPooledConnection = (OracleUniversalPooledConnection)universalPooledConnection;
        try {
            if (this.isDRCPEnabled == null) {
                this.isDRCPEnabled = oracleUniversalPooledConnection.isDRCPEnabled();
            }
        }
        catch (SQLException sQLException) {
            throw new UniversalConnectionPoolException(sQLException);
        }
        return this.isDRCPEnabled;
    }

    @Override
    protected boolean isDRCPMultiTagEnabled(UniversalPooledConnection universalPooledConnection) throws UniversalConnectionPoolException {
        OracleUniversalPooledConnection oracleUniversalPooledConnection = (OracleUniversalPooledConnection)universalPooledConnection;
        try {
            if (this.isDRCPMultiTagEnabled == null) {
                this.isDRCPMultiTagEnabled = oracleUniversalPooledConnection.isDRCPMultitagEnabled();
            }
        }
        catch (SQLException sQLException) {
            throw new UniversalConnectionPoolException(sQLException);
        }
        return this.isDRCPMultiTagEnabled;
    }

    @Override
    protected String getDRCPPLSQLCallbackName(UniversalPooledConnection universalPooledConnection) throws UniversalConnectionPoolException {
        OracleUniversalPooledConnection oracleUniversalPooledConnection = (OracleUniversalPooledConnection)universalPooledConnection;
        if (this.drcpPLSQLCallbackName == null) {
            this.drcpPLSQLCallbackName = oracleUniversalPooledConnection.getDRCPPLSQLCallbackName();
        }
        return this.drcpPLSQLCallbackName;
    }

    static {
        try {
            $$$methodRef$$$9 = OracleConnectionConnectionPool.class.getDeclaredConstructor(JDBCConnectionFactoryAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$8 = OracleConnectionConnectionPool.class.getDeclaredMethod("getDRCPPLSQLCallbackName", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$7 = OracleConnectionConnectionPool.class.getDeclaredMethod("isDRCPMultiTagEnabled", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$6 = OracleConnectionConnectionPool.class.getDeclaredMethod("isDRCPEnabled", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$5 = OracleConnectionConnectionPool.class.getDeclaredMethod("needToConfigureConnection", UniversalPooledConnection.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$4 = OracleConnectionConnectionPool.class.getDeclaredMethod("closeConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$3 = OracleConnectionConnectionPool.class.getDeclaredMethod("returnConnection", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = OracleConnectionConnectionPool.class.getDeclaredMethod("returnConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = OracleConnectionConnectionPool.class.getDeclaredMethod("borrowConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = OracleConnectionConnectionPool.class.getDeclaredMethod("getConnection", JDBCConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

