/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.jdbc.DriverConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class OracleDriverConnectionFactoryAdapter
extends DriverConnectionFactoryAdapter {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    public OracleDriverConnectionFactoryAdapter(Driver driver, String string, Properties properties, Properties properties2) throws UniversalConnectionPoolException {
        super(driver, string, properties, properties2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        Connection connection;
        block11: {
            String string = connectionRetrievalInfo instanceof OracleJDBCConnectionRetrievalInfo ? ((OracleJDBCConnectionRetrievalInfo)connectionRetrievalInfo).getInstanceName() : null;
            connection = null;
            try {
                if (null == string || "".equals(string)) {
                    ClioSupport.ilogFinest(null, null, null, null, "about to create connection without specifying instance");
                    connection = (Connection)super.createConnection(connectionRetrievalInfo);
                    break block11;
                }
                Properties properties = (Properties)this.m_connectionProperties.clone();
                properties.setProperty("oracle.jdbc.targetInstanceName", string);
                ClioSupport.ilogFinest(null, null, null, null, "about to create connection to the instance " + string);
                Object object = this.m_driver;
                synchronized (object) {
                    connection = this.m_driver.connect(this.m_url, properties);
                }
                if (connection instanceof OracleConnection) {
                    object = ((OracleConnection)connection).getServerSessionInfo().getProperty("INSTANCE_NAME");
                    assert (null != object);
                    assert (Util.equalsNormalized((String)object, string)) : "internal error: got connection from the wrong instance";
                    if (!Util.equalsNormalized((String)object, string)) {
                        ClioSupport.ilogFinest(null, null, null, null, "wrong conn opened, desired:" + string + ", actual:" + (String)object);
                    }
                } else {
                    ClioSupport.ilogFinest(null, null, null, null, "not an oracle connection");
                }
            }
            catch (SQLException sQLException) {
                ClioSupport.ilogThrowing(null, null, null, null, sQLException);
                UCPErrorHandler.throwUniversalConnectionPoolException(257, sQLException);
            }
        }
        return connection;
    }

    @Override
    public UniversalPooledConnection createPooledConnection(Object object, ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        JDBCConnectionPool jDBCConnectionPool = (JDBCConnectionPool)this.getUniversalConnectionPool();
        OracleUniversalPooledConnection oracleUniversalPooledConnection = new OracleUniversalPooledConnection(jDBCConnectionPool, object, connectionRetrievalInfo, jDBCConnectionPool.isFailoverEnabled());
        return oracleUniversalPooledConnection;
    }

    static {
        try {
            $$$methodRef$$$2 = OracleDriverConnectionFactoryAdapter.class.getDeclaredConstructor(Driver.class, String.class, Properties.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = OracleDriverConnectionFactoryAdapter.class.getDeclaredMethod("createPooledConnection", Object.class, ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = OracleDriverConnectionFactoryAdapter.class.getDeclaredMethod("createConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

