/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.Clock;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnectionHelper;
import oracle.ucp.jdbc.oracle.OracleFailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.jdbc.oracle.rlb.RLBInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.jdbc.proxy")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class OracleUniversalPooledConnection
extends JDBCUniversalPooledConnection
implements FailoverablePooledConnection,
OracleFailoverablePooledConnection {
    public static final int CANCELLATION_TIMEOUT = 15;
    private static final String DEFAULT_DRCP_VALUE = "NULL";
    private static final char DRCP_KEY_VALUE_SEPARATOR = '=';
    private static final char DRCP_MULTITAG_SEPARATOR = ';';
    private static final String AUTH_DB_TYPE_FLG = "AUTH_DB_SHRD_CLS";
    private static final int DB_SHARDING_ENABLED = 1;
    private static final int DB_DATA_AFFINITY_ENABLED = 2;
    private static final int DB_SHARD_CATALOG = 4;
    private String m_dataSourceInstanceName;
    private String m_dbUniqueName;
    private String m_hostName;
    private String m_serviceName;
    private int m_instanceId = -1;
    private JDBCConnectionPool m_cp = null;
    private boolean m_isNamedInstanceConn = false;
    private boolean isDRCPTagMatched = true;
    private Date m_instanceStartTime;
    private AtomicReference<RLBInfo.Frame> rlbBorrowStats = new AtomicReference<Object>(null);
    private AtomicReference<RLBInfo.Frame> rlbOpenStats = new AtomicReference<Object>(null);
    private boolean isPdbSessionInitialized = false;
    static final boolean shardRoutingEnabled;
    private OracleConnection.DRCPState initialDrcpState;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;

    public OracleUniversalPooledConnection(JDBCConnectionPool jDBCConnectionPool, Object object, ConnectionRetrievalInfo connectionRetrievalInfo, boolean bl2) throws UniversalConnectionPoolException {
        super(jDBCConnectionPool, object, connectionRetrievalInfo, bl2);
        ClioSupport.ilogFinest(null, null, null, null, "connectionFailoverEnabled: " + bl2);
        this.m_cp = jDBCConnectionPool;
        this.m_isNamedInstanceConn = false;
        try {
            Connection connection = this.getSQLConnection(object);
            oracle.jdbc.OracleConnection oracleConnection = (oracle.jdbc.OracleConnection)connection;
            this.initialDrcpState = oracleConnection.getDRCPState();
        }
        catch (SQLException sQLException) {
            ClioSupport.ilogThrowing(null, null, null, null, sQLException);
        }
    }

    @Override
    public void validate() {
        boolean bl2 = false;
        try {
            Connection connection = this.getSQLConnection(this.getPhysicalConnection());
            if (null != connection && (bl2 = FailoverablePooledConnectionHelper.isUsableOnOracleConnection(connection))) {
                if (null == this.m_cp.getSQLForValidateConnection()) {
                    bl2 = connection.isValid(0);
                } else {
                    ClioSupport.ilogFinest(null, null, null, null, "Using SQL command to validate");
                    super.validate();
                }
            }
        }
        catch (Exception exception) {
            bl2 = false;
        }
        finally {
            if (bl2) {
                this.setLastConnectionValidationTime(Clock.clock());
                ClioSupport.ilogFinest(null, null, null, null, "connection is good");
            } else {
                this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "connection is bad");
                this.setLastConnectionValidationTime(0L);
            }
        }
    }

    @Override
    public boolean isValid() {
        JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)this.getConnectionRetrievalInfo();
        OracleShardingKey oracleShardingKey = jDBCConnectionRetrievalInfo.getShardingKey();
        OracleShardingKey oracleShardingKey2 = jDBCConnectionRetrievalInfo.getSuperShardingKey();
        try {
            if (oracleShardingKey == null) {
                return this.isValid(this.m_cp.getConnectionValidationTimeout());
            }
            return this.setShardingKeyIfValid(oracleShardingKey, oracleShardingKey2, this.m_cp.getConnectionValidationTimeout());
        }
        catch (SQLException sQLException) {
            ClioSupport.ilogThrowing(null, null, null, null, sQLException);
            return false;
        }
    }

    @Override
    public long getLastNetworkAccessTime() {
        try {
            Connection connection = this.getSQLConnection(this.getPhysicalConnection());
            if (null != connection) {
                return FailoverablePooledConnectionHelper.getLastNetworkAccessTime(connection);
            }
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setShardingKeyIfValid(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2, int n2) {
        Connection connection = (Connection)this.getPhysicalConnection();
        if (!(connection instanceof oracle.jdbc.OracleConnection)) {
            return true;
        }
        boolean bl2 = false;
        oracle.jdbc.OracleConnection oracleConnection = (oracle.jdbc.OracleConnection)connection;
        try {
            bl2 = oracleConnection.setShardingKeyIfValid(oracleShardingKey, oracleShardingKey2, n2);
        }
        catch (SQLException sQLException) {
            bl2 = false;
            if (sQLException.getCause() instanceof IOException || sQLException.getCause() instanceof TimeoutException || sQLException.getCause() instanceof InterruptedException) {
                this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "connection is bad");
            }
        }
        finally {
            if (bl2) {
                this.setLastConnectionValidationTime(Clock.clock());
                ClioSupport.ilogFinest(null, null, null, null, "connection is good");
            } else {
                this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "connection is bad");
                this.setLastConnectionValidationTime(0L);
            }
        }
        return bl2;
    }

    @Override
    protected void initFailoverParameters() throws UniversalConnectionPoolException {
        Connection connection = null;
        try {
            connection = this.getSQLConnection(this.getPhysicalConnection());
        }
        catch (Exception exception) {
            UCPErrorHandler.throwUniversalConnectionPoolException(301, exception);
        }
        Properties properties = FailoverablePooledConnectionHelper.getSessionInfoOnOracleConnection(connection);
        String string = properties.getProperty("INSTANCE_NAME");
        if (string != null) {
            this.setDataSourceInstanceName(string.trim().toLowerCase());
        }
        if ((string = properties.getProperty("SERVER_HOST")) != null) {
            this.setHostName(string.trim().toLowerCase());
        }
        if ((string = properties.getProperty("SERVICE_NAME")) != null) {
            this.setServiceName(string.trim().toLowerCase());
        }
        if ((string = properties.getProperty("DATABASE_NAME")) != null) {
            this.setDbUniqueName(string.trim().toLowerCase());
        }
        if ((string = properties.getProperty("AUTH_SC_INSTANCE_START_TIME")) != null) {
            this.setInstanceStartTime(FailoverablePooledConnectionHelper.getInstanceStartTime(string));
        }
    }

    @Override
    public int getInstanceNumber() {
        if (this.m_instanceId >= 0) {
            return this.m_instanceId;
        }
        try {
            Connection connection = this.getSQLConnection(this.getPhysicalConnection());
            if (connection != null) {
                this.m_instanceId = FailoverablePooledConnectionHelper.getInstanceNumber(connection);
                return this.m_instanceId;
            }
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
            Object var1_2 = null;
        }
        return -1;
    }

    void updateInstanceNumber() {
        try {
            Connection connection = this.getSQLConnection(this.getPhysicalConnection());
            if (connection != null) {
                this.m_instanceId = FailoverablePooledConnectionHelper.getInstanceNumber(connection);
            }
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
            this.m_instanceId = -1;
            Object var1_2 = null;
        }
    }

    @Override
    public String getDataSourceInstanceName() {
        return this.m_dataSourceInstanceName;
    }

    @Override
    public synchronized void setDataSourceInstanceName(String string) {
        this.m_dataSourceInstanceName = string;
    }

    @Override
    public String getDbUniqueName() {
        return this.m_dbUniqueName;
    }

    @Override
    public void setDbUniqueName(String string) {
        this.m_dbUniqueName = string;
    }

    @Override
    public String getHostName() {
        return this.m_hostName;
    }

    @Override
    public void setHostName(String string) {
        this.m_hostName = string;
    }

    @Override
    public String getServiceName() {
        return this.m_serviceName;
    }

    @Override
    public void setServiceName(String string) {
        this.m_serviceName = string;
    }

    @Override
    public synchronized void setMaxStatements(int n2) throws SQLException {
        Connection connection = null;
        try {
            connection = this.getSQLConnection(this.getPhysicalConnection());
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
            connection = null;
        }
        if (this.getMaxStatements() != n2) {
            if (n2 > 0) {
                FailoverablePooledConnectionHelper.enableStatementPooling(connection, n2);
            } else {
                FailoverablePooledConnectionHelper.disableStatementPooling(connection);
            }
        }
        super.setMaxStatements(n2);
    }

    @Override
    public void abort() {
        try {
            Connection connection = this.getSQLConnection(this.getPhysicalConnection());
            if (connection == null) {
                return;
            }
            ClioSupport.ilogFinest(null, null, null, null, "aborting connection: " + connection);
            if (!UniversalPooledConnectionStatus.STATUS_RECONNECTING.equals(this.getStatus())) {
                this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
            }
            FailoverablePooledConnectionHelper.abortOracleConnection(connection);
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
    }

    @Override
    public void handleTimeout() {
        try {
            this.validitySemaphore.acquire();
            this.handleTimeoutHelper();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.validitySemaphore.release();
        }
    }

    private void handleTimeoutHelper() {
        TaskHandle<Connection> taskHandle = null;
        TaskHandle<Boolean> taskHandle2 = null;
        TaskHandle<Boolean> taskHandle3 = null;
        try {
            taskHandle = UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Connection>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                public Connection call() throws Exception {
                    return OracleUniversalPooledConnection.this.getSQLConnection(OracleUniversalPooledConnection.this.getPhysicalConnection());
                }

                static {
                    try {
                        $$$methodRef$$$2 = 1.class.getDeclaredConstructor(OracleUniversalPooledConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredMethod("call", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("call", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
            final Connection connection = taskHandle.get(15000L);
            taskHandle = null;
            taskHandle2 = UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Boolean>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                public Boolean call() throws Exception {
                    FailoverablePooledConnectionHelper.cancelOnOracleConnection(connection);
                    return true;
                }

                static {
                    try {
                        $$$methodRef$$$2 = 2.class.getDeclaredConstructor(OracleUniversalPooledConnection.class, Connection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$1 = 2.class.getDeclaredMethod("call", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 2.class.getDeclaredMethod("call", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
            taskHandle2.get(15000L);
            taskHandle2 = null;
            ClioSupport.ilogFinest(null, null, null, null, "conn cancelled successfully");
            if (!connection.getAutoCommit() && this.getStatus() == UniversalPooledConnectionStatus.STATUS_NORMAL && !(this.getPhysicalConnection() instanceof XAConnection)) {
                taskHandle3 = UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Boolean>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;
                    private static Executable $$$methodRef$$$2;
                    private static Logger $$$loggerRef$$$2;

                    @Override
                    public Boolean call() throws Exception {
                        connection.rollback();
                        return true;
                    }

                    static {
                        try {
                            $$$methodRef$$$2 = 3.class.getDeclaredConstructor(OracleUniversalPooledConnection.class, Connection.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$1 = 3.class.getDeclaredMethod("call", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 3.class.getDeclaredMethod("call", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                });
                taskHandle3.get(15000L);
                taskHandle3 = null;
            }
        }
        catch (TaskManagerException taskManagerException) {
            ClioSupport.ilogWarning(null, null, null, null, "connection cancellation is timed out");
            if (null != taskHandle) {
                taskHandle.getTask().release();
            }
            if (null != taskHandle2) {
                taskHandle2.getTask().release();
            }
            if (null != taskHandle3) {
                taskHandle3.getTask().release();
            }
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
    }

    @Override
    public Connection getSQLConnection(Object object) throws SQLException {
        return object instanceof OraclePooledConnection ? ((OraclePooledConnection)object).getPhysicalHandle() : super.getSQLConnection(object);
    }

    @Override
    public boolean setAvailable() {
        try {
            if (((OracleJDBCConnectionPool)this.m_cp).isDRCPEnabled(this)) {
                if (this.initialDrcpState == OracleConnection.DRCPState.DETACHED) {
                    this.detachServerConnection(null);
                }
            }
        }
        catch (SQLException sQLException) {
            ClioSupport.ilogThrowing(null, null, null, null, sQLException);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
        }
        finally {
            return super.setAvailable();
        }
    }

    public boolean attachServerConnection(Properties properties) throws SQLException {
        Connection connection = null;
        try {
            connection = this.getSQLConnection(this.getPhysicalConnection());
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
        boolean bl2 = FailoverablePooledConnectionHelper.attachServerConnection(connection);
        if (properties != null && properties.size() > 0) {
            int n2 = super.labelingCost(properties);
            this.isDRCPTagMatched = bl2 && n2 == 0;
        }
        return this.isDRCPTagMatched;
    }

    public void detachServerConnection(String string) throws SQLException {
        Connection connection = null;
        try {
            connection = this.getSQLConnection(this.getPhysicalConnection());
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
        ConnectionRetrievalInfo connectionRetrievalInfo = this.getConnectionRetrievalInfo();
        if (connectionRetrievalInfo != null && connectionRetrievalInfo.getLabels() != null) {
            try {
                string = ((OracleJDBCConnectionPool)this.m_cp).isDRCPMultiTagEnabled(this) ? this.getDRCPTag(connectionRetrievalInfo.getLabels()) : connectionRetrievalInfo.getLabels().toString();
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
            }
        }
        if (this.isDRCPEnabled() && this.isMultitenantDatabase()) {
            string = string == null ? "serviceName=" + this.getDelegator().serviceName() : string + ";serviceName=" + this.getDelegator().serviceName();
        }
        FailoverablePooledConnectionHelper.detachServerConnection(connection, string);
    }

    protected String getDRCPTag(Properties properties) throws SQLException {
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (string2 == null || string2.trim().length() == 0) {
                string2 = DEFAULT_DRCP_VALUE;
            }
            this.validateDRCPKeyAndValue(string, string2);
            stringBuilder.append(string);
            stringBuilder.append('=');
            stringBuilder.append(string2);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    protected void validateDRCPKeyAndValue(String string, String string2) throws SQLException {
        if (string.indexOf(61) != -1 || string.indexOf(59) != -1) {
            throw UCPErrorHandler.newSQLException(70, string);
        }
        if (string2.indexOf(61) != -1 || string2.indexOf(59) != -1) {
            throw UCPErrorHandler.newSQLException(71, string2);
        }
    }

    public boolean isDRCPEnabled() throws SQLException {
        Connection connection = null;
        try {
            connection = this.getSQLConnection(this.getPhysicalConnection());
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
        return FailoverablePooledConnectionHelper.isDRCPEnabled(connection);
    }

    public boolean isDRCPMultitagEnabled() throws SQLException {
        Connection connection = null;
        connection = this.getSQLConnection(this.getPhysicalConnection());
        return FailoverablePooledConnectionHelper.isDRCPMultitagEnabled(connection);
    }

    public String getDRCPReturnTag() throws UniversalConnectionPoolException {
        Connection connection = null;
        try {
            connection = this.getSQLConnection(this.getPhysicalConnection());
            return FailoverablePooledConnectionHelper.getDRCPReturnTag(connection);
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
            throw new UniversalConnectionPoolException(exception);
        }
    }

    public String getDRCPPLSQLCallbackName() throws UniversalConnectionPoolException {
        Connection connection = null;
        try {
            connection = this.getSQLConnection(this.getPhysicalConnection());
            return FailoverablePooledConnectionHelper.getDRCPPLSQLCallbackName(connection);
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
            throw new UniversalConnectionPoolException(exception);
        }
    }

    @Override
    public Properties getUnmatchedConnectionLabels(Properties properties) throws UniversalConnectionPoolException {
        if (this.getConnectionLabels() != null && ((OracleJDBCConnectionPool)this.m_cp).isDRCPEnabled(this)) {
            if (((OracleJDBCConnectionPool)this.m_cp).isDRCPMultiTagEnabled(this)) {
                return this.findUnmatchedTags(properties);
            }
            return this.isDRCPTagMatched ? null : properties;
        }
        return super.getUnmatchedConnectionLabels(properties);
    }

    protected Properties findUnmatchedTags(Properties properties) throws UniversalConnectionPoolException {
        String string;
        Properties properties2 = new Properties();
        if (properties != null) {
            properties2.putAll((Map<?, ?>)properties);
        }
        if ((string = this.getDRCPReturnTag()) != null && string.trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n2 = string2.indexOf(61);
                if (n2 == -1) continue;
                properties2.remove(string2.substring(0, n2));
            }
        }
        if (properties2.isEmpty()) {
            return null;
        }
        return properties2;
    }

    @Override
    public int getDatabaseVersion() throws UniversalConnectionPoolException {
        int n2 = 0;
        try {
            Connection connection = this.getSQLConnection(this.getPhysicalConnection());
            return FailoverablePooledConnectionHelper.getDatabaseVersion(connection);
        }
        catch (Exception exception) {
            n2 = 0;
            ClioSupport.ilogThrowing(null, null, null, null, exception);
            return n2;
        }
    }

    @Override
    public boolean isNamedInstanceConnection() {
        return this.m_isNamedInstanceConn;
    }

    @Override
    public void setAsNamedInstanceConnection() {
        this.m_isNamedInstanceConn = true;
    }

    @Override
    public String getInstance() {
        return this.getDataSourceInstanceName();
    }

    @Override
    public String getService() {
        return this.getServiceName();
    }

    @Override
    public String getHost() {
        return this.getHostName();
    }

    @Override
    public String getDatabase() {
        return this.getDbUniqueName();
    }

    @Override
    public void close(boolean bl2) throws UniversalConnectionPoolException {
        throw new IllegalStateException("obsolete");
    }

    @Override
    public Date getInstanceStartTime() {
        return this.m_instanceStartTime;
    }

    @Override
    public Properties getConnectionInfo() throws UniversalConnectionPoolException {
        Properties properties = null;
        try {
            Connection connection = this.getSQLConnection(this.getPhysicalConnection());
            properties = FailoverablePooledConnectionHelper.getSessionInfoOnOracleConnection(connection);
        }
        catch (Exception exception) {
            properties = null;
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
        return properties;
    }

    void setInstanceStartTime(Date date) {
        this.m_instanceStartTime = date;
    }

    public RLBInfo.Frame getRlbBorrowStats() {
        return this.rlbBorrowStats.get();
    }

    public void setRlbBorrowStats(RLBInfo.Frame frame) {
        this.rlbBorrowStats.set(frame);
    }

    public boolean isMultitenantDatabase() {
        try {
            Properties properties = this.getConnectionInfo();
            if (properties != null && properties.containsKey("AUTH_PDB_UID")) {
                return true;
            }
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
        }
        return false;
    }

    public boolean[] getShardingMode() {
        boolean[] blArray = new boolean[]{false, false};
        if (!shardRoutingEnabled) {
            return blArray;
        }
        short s2 = 0;
        try {
            s2 = ((OracleConnection)this.getSQLConnection(this.getPhysicalConnection())).getVersionNumber();
        }
        catch (SQLException sQLException) {
            ClioSupport.ilogThrowing(null, null, null, null, sQLException);
        }
        if (s2 < 12202) {
            return this.checkShardMetadataTables();
        }
        try (Statement statement = this.getSQLConnection(this.getPhysicalConnection()).createStatement();
             ResultSet resultSet = statement.executeQuery("select GSMADMIN_INTERNAL.GETSHARDINGMODE from dual");){
            if (resultSet.next()) {
                int n2 = resultSet.getInt(1);
                blArray[0] = (n2 & 1) != 0 | (n2 & 4) != 0;
                blArray[1] = (n2 & 4) != 0;
            }
        }
        catch (SQLException sQLException) {
            ClioSupport.ilogThrowing(null, null, null, null, sQLException);
            blArray = this.checkShardMetadataTables();
        }
        return blArray;
    }

    private boolean[] checkShardMetadataTables() {
        Throwable throwable;
        ResultSet resultSet;
        Throwable throwable2;
        Statement statement;
        boolean[] blArray = new boolean[]{false, false};
        try {
            statement = this.getSQLConnection(this.getPhysicalConnection()).createStatement();
            throwable2 = null;
            try {
                resultSet = statement.executeQuery("select * from LOCAL_CHUNK_TYPES");
                throwable = null;
                try {
                    if (resultSet.next()) {
                        blArray[0] = true;
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (resultSet != null) {
                        if (throwable != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                if (statement != null) {
                    if (throwable2 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            ClioSupport.ilogThrowing(null, null, null, null, sQLException);
            blArray[0] = false;
        }
        if (blArray[0]) {
            try {
                statement = this.getSQLConnection(this.getPhysicalConnection()).createStatement();
                throwable2 = null;
                try {
                    resultSet = statement.executeQuery("select * from gsmadmin_internal.cloud");
                    throwable = null;
                    try {
                        if (resultSet.next()) {
                            blArray[0] = false;
                            blArray[1] = true;
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (resultSet != null) {
                            if (throwable != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                            } else {
                                resultSet.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable9) {
                    throwable2 = throwable9;
                    throw throwable9;
                }
                finally {
                    if (statement != null) {
                        if (throwable2 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable10) {
                                throwable2.addSuppressed(throwable10);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                ClioSupport.ilogThrowing(null, null, null, null, sQLException);
            }
        }
        return blArray;
    }

    public boolean isRacDataAffinityEnabled() {
        boolean bl2 = false;
        try (Statement statement = this.getSQLConnection(this.getPhysicalConnection()).createStatement();
             ResultSet resultSet = statement.executeQuery("select GSMADMIN_INTERNAL.GETSHARDINGMODE from dual");){
            if (resultSet.next()) {
                bl2 = (resultSet.getInt(1) & 2) != 0;
            }
        }
        catch (SQLException sQLException) {
            ClioSupport.ilogThrowing(null, null, null, null, sQLException);
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public Properties getDatabaseConnectionProperties() {
        Object object = this.getPhysicalConnection();
        try {
            if (object instanceof oracle.jdbc.OracleConnection) {
                return ((OracleConnection)object).getServerSessionInfo();
            }
            if (object instanceof OraclePooledConnection) {
                OracleConnection oracleConnection = (OracleConnection)((OraclePooledConnection)object).getConnection();
                return oracleConnection.getServerSessionInfo();
            }
        }
        catch (SQLException sQLException) {
            ClioSupport.ilogThrowing(null, null, null, null, sQLException);
        }
        return super.getDatabaseConnectionProperties();
    }

    public void setPdbSessionInitialized(boolean bl2) {
        this.isPdbSessionInitialized = bl2;
    }

    public void initPdbSession(ConnectionRetrievalInfo connectionRetrievalInfo) throws SQLException {
        if (this.isPdbSessionInitialized) {
            return;
        }
        JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
        Properties properties = jDBCConnectionRetrievalInfo.getPdbRoles();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        try (Statement statement = this.getSQLConnection(this.getPhysicalConnection()).createStatement();){
            for (Map.Entry<Object, Object> entry : jDBCConnectionRetrievalInfo.getPdbRoles().entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                if (string2 == null) {
                    string2 = "";
                }
                statement.execute("set role " + string + (string2.equals("") ? "" : " identified by " + string2));
                this.isPdbSessionInitialized = true;
            }
        }
    }

    @Override
    public int labelingCost(Properties properties) {
        block4: {
            try {
                if (((OracleJDBCConnectionPool)this.m_cp).isDRCPMultiTagEnabled(this)) {
                    Properties properties2 = this.getConnectionLabels();
                    if (properties2 != null && properties != null && properties2.equals(properties) || properties2 == null && properties == null) {
                        return 0;
                    }
                    break block4;
                }
                return super.labelingCost(properties);
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
            }
        }
        return Integer.MAX_VALUE;
    }

    static {
        try {
            $$$methodRef$$$52 = OracleUniversalPooledConnection.class.getDeclaredConstructor(JDBCConnectionPool.class, Object.class, ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$51 = OracleUniversalPooledConnection.class.getDeclaredMethod("labelingCost", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$50 = OracleUniversalPooledConnection.class.getDeclaredMethod("initPdbSession", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$49 = OracleUniversalPooledConnection.class.getDeclaredMethod("setPdbSessionInitialized", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$48 = OracleUniversalPooledConnection.class.getDeclaredMethod("getDatabaseConnectionProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$47 = OracleUniversalPooledConnection.class.getDeclaredMethod("isRacDataAffinityEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$46 = OracleUniversalPooledConnection.class.getDeclaredMethod("checkShardMetadataTables", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$45 = OracleUniversalPooledConnection.class.getDeclaredMethod("getShardingMode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$44 = OracleUniversalPooledConnection.class.getDeclaredMethod("isMultitenantDatabase", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$43 = OracleUniversalPooledConnection.class.getDeclaredMethod("setRlbBorrowStats", RLBInfo.Frame.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$42 = OracleUniversalPooledConnection.class.getDeclaredMethod("getRlbBorrowStats", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$41 = OracleUniversalPooledConnection.class.getDeclaredMethod("setInstanceStartTime", Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$40 = OracleUniversalPooledConnection.class.getDeclaredMethod("getConnectionInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$39 = OracleUniversalPooledConnection.class.getDeclaredMethod("getInstanceStartTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$38 = OracleUniversalPooledConnection.class.getDeclaredMethod("close", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$37 = OracleUniversalPooledConnection.class.getDeclaredMethod("getDatabase", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$36 = OracleUniversalPooledConnection.class.getDeclaredMethod("getHost", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$35 = OracleUniversalPooledConnection.class.getDeclaredMethod("getService", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$34 = OracleUniversalPooledConnection.class.getDeclaredMethod("getInstance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$33 = OracleUniversalPooledConnection.class.getDeclaredMethod("setAsNamedInstanceConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$32 = OracleUniversalPooledConnection.class.getDeclaredMethod("isNamedInstanceConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$31 = OracleUniversalPooledConnection.class.getDeclaredMethod("getDatabaseVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$30 = OracleUniversalPooledConnection.class.getDeclaredMethod("findUnmatchedTags", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$29 = OracleUniversalPooledConnection.class.getDeclaredMethod("getUnmatchedConnectionLabels", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$28 = OracleUniversalPooledConnection.class.getDeclaredMethod("getDRCPPLSQLCallbackName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$27 = OracleUniversalPooledConnection.class.getDeclaredMethod("getDRCPReturnTag", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$26 = OracleUniversalPooledConnection.class.getDeclaredMethod("isDRCPMultitagEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$25 = OracleUniversalPooledConnection.class.getDeclaredMethod("isDRCPEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$24 = OracleUniversalPooledConnection.class.getDeclaredMethod("validateDRCPKeyAndValue", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$23 = OracleUniversalPooledConnection.class.getDeclaredMethod("getDRCPTag", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$22 = OracleUniversalPooledConnection.class.getDeclaredMethod("detachServerConnection", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$21 = OracleUniversalPooledConnection.class.getDeclaredMethod("attachServerConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$20 = OracleUniversalPooledConnection.class.getDeclaredMethod("setAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$19 = OracleUniversalPooledConnection.class.getDeclaredMethod("getSQLConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$18 = OracleUniversalPooledConnection.class.getDeclaredMethod("handleTimeoutHelper", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$17 = OracleUniversalPooledConnection.class.getDeclaredMethod("handleTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$16 = OracleUniversalPooledConnection.class.getDeclaredMethod("abort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$15 = OracleUniversalPooledConnection.class.getDeclaredMethod("setMaxStatements", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$14 = OracleUniversalPooledConnection.class.getDeclaredMethod("setServiceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$13 = OracleUniversalPooledConnection.class.getDeclaredMethod("getServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$12 = OracleUniversalPooledConnection.class.getDeclaredMethod("setHostName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$11 = OracleUniversalPooledConnection.class.getDeclaredMethod("getHostName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$10 = OracleUniversalPooledConnection.class.getDeclaredMethod("setDbUniqueName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$9 = OracleUniversalPooledConnection.class.getDeclaredMethod("getDbUniqueName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$8 = OracleUniversalPooledConnection.class.getDeclaredMethod("setDataSourceInstanceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$7 = OracleUniversalPooledConnection.class.getDeclaredMethod("getDataSourceInstanceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$6 = OracleUniversalPooledConnection.class.getDeclaredMethod("updateInstanceNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$5 = OracleUniversalPooledConnection.class.getDeclaredMethod("getInstanceNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$4 = OracleUniversalPooledConnection.class.getDeclaredMethod("initFailoverParameters", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$3 = OracleUniversalPooledConnection.class.getDeclaredMethod("setShardingKeyIfValid", OracleShardingKey.class, OracleShardingKey.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$2 = OracleUniversalPooledConnection.class.getDeclaredMethod("getLastNetworkAccessTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$1 = OracleUniversalPooledConnection.class.getDeclaredMethod("isValid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$0 = OracleUniversalPooledConnection.class.getDeclaredMethod("validate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        shardRoutingEnabled = Boolean.valueOf(Util.getShardRoutingEnabled());
    }
}

