/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.replay.OracleXADataSourceImpl;
import oracle.jdbc.xa.OracleXAConnectionBuilderImpl;
import oracle.jdbc.xa.client.OracleXADataSource;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.XADataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class OracleXADataSourceConnectionFactoryAdapter
extends XADataSourceConnectionFactoryAdapter {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    public OracleXADataSourceConnectionFactoryAdapter(XADataSource xADataSource) throws UniversalConnectionPoolException {
        super(xADataSource);
        this.initializeUrlFromConnectionFactory();
    }

    @Override
    public Object createConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        XAConnection xAConnection;
        block8: {
            String string = connectionRetrievalInfo instanceof OracleJDBCConnectionRetrievalInfo ? ((OracleJDBCConnectionRetrievalInfo)connectionRetrievalInfo).getInstanceName() : null;
            Object var3_3 = null;
            xAConnection = null;
            try {
                if (!(this.m_xaDataSource instanceof OracleXADataSource) && !(this.m_xaDataSource instanceof OracleXADataSourceImpl)) {
                    ClioSupport.ilogFinest(null, null, null, null, "about to create connection without specifying instance");
                    xAConnection = (XAConnection)super.createConnection(connectionRetrievalInfo);
                    break block8;
                }
                OracleXAConnectionBuilderImpl oracleXAConnectionBuilderImpl = this.m_xaDataSource instanceof OracleXADataSource ? ((OracleXADataSource)this.m_xaDataSource).createXAConnectionBuilder() : ((OracleXADataSourceImpl)this.m_xaDataSource).createXAConnectionBuilder();
                ClioSupport.ilogFinest(null, null, null, null, "about to create connection to the instance " + string);
                JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
                xAConnection = oracleXAConnectionBuilderImpl.user(jDBCConnectionRetrievalInfo.getUser()).password(jDBCConnectionRetrievalInfo.getPassword().get()).instanceName(string).serviceName(jDBCConnectionRetrievalInfo.getServiceName()).shardingKey(jDBCConnectionRetrievalInfo.getShardingKey()).superShardingKey(jDBCConnectionRetrievalInfo.getSuperShardingKey()).build();
                if (null == xAConnection) break block8;
                String string2 = null;
                try {
                    string2 = ((OracleConnection)xAConnection.getConnection()).getServerSessionInfo().getProperty("INSTANCE_NAME");
                }
                catch (Throwable throwable) {
                    ClioSupport.ilogFinest(null, null, null, null, "unable to get named instance connection information");
                }
                if (string2 != null) {
                    if (string != null && !"".equals(string) && !Util.equalsNormalized(string, string2)) {
                        ClioSupport.ilogFinest(null, null, null, null, "wrong named instance connection created");
                    }
                } else {
                    ClioSupport.ilogFinest(null, null, null, null, "unable to verify named instance connection creation");
                }
            }
            catch (SQLException sQLException) {
                ClioSupport.ilogThrowing(null, null, null, null, sQLException);
                UCPErrorHandler.throwUniversalConnectionPoolException(261, sQLException);
            }
        }
        return xAConnection;
    }

    @Override
    public UniversalPooledConnection createPooledConnection(Object object, ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        JDBCConnectionPool jDBCConnectionPool = (JDBCConnectionPool)this.getUniversalConnectionPool();
        return new OracleUniversalPooledConnection(jDBCConnectionPool, object, connectionRetrievalInfo, jDBCConnectionPool.isFailoverEnabled());
    }

    @Override
    public void initializeUrlFromConnectionFactory() {
        Class<?> clazz = this.m_xaDataSource.getClass();
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName("oracle.jdbc.pool.OracleDataSource", true, clazz.getClassLoader());
            Method method = clazz2.getMethod("getURL", new Class[0]);
            this.m_url = (String)method.invoke((Object)this.m_xaDataSource, new Object[0]);
            ClioSupport.ilogFinest(null, null, null, null, "initializeUrlFromConnectionFactory() succeeded");
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
    }

    @Override
    public void setUrl(String string) {
        Class<?> clazz = this.m_xaDataSource.getClass();
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName("oracle.jdbc.pool.OracleDataSource", true, clazz.getClassLoader());
            Method method = clazz2.getMethod("setURL", String.class);
            method.invoke((Object)this.m_xaDataSource, string);
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
    }

    static {
        try {
            $$$methodRef$$$4 = OracleXADataSourceConnectionFactoryAdapter.class.getDeclaredConstructor(XADataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$3 = OracleXADataSourceConnectionFactoryAdapter.class.getDeclaredMethod("setUrl", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = OracleXADataSourceConnectionFactoryAdapter.class.getDeclaredMethod("initializeUrlFromConnectionFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = OracleXADataSourceConnectionFactoryAdapter.class.getDeclaredMethod("createPooledConnection", Object.class, ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = OracleXADataSourceConnectionFactoryAdapter.class.getDeclaredMethod("createConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

