/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ons.ONS;
import oracle.ons.ONSException;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.FailoverEvent;
import oracle.ucp.common.FailoverEventHandlerTask;
import oracle.ucp.common.FailoverEventHandlerTaskBase;
import oracle.ucp.common.Failoverable;
import oracle.ucp.jdbc.oracle.DataBasedConnectionAffinityCallback;
import oracle.ucp.jdbc.oracle.FailoverActionResult;
import oracle.ucp.jdbc.oracle.FailoverStatisticsAccumulator;
import oracle.ucp.jdbc.oracle.FailoverStatisticsCounters;
import oracle.ucp.jdbc.oracle.FailoverStatisticsItem;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask;
import oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask;
import oracle.ucp.jdbc.oracle.OracleConnectionAffinityContext;
import oracle.ucp.jdbc.oracle.OracleFailoverEvent;
import oracle.ucp.jdbc.oracle.OracleGravitateConnectionPoolTask;
import oracle.ucp.jdbc.oracle.OracleLoadBalancingEvent;
import oracle.ucp.jdbc.oracle.RACAffinityContext;
import oracle.ucp.jdbc.oracle.RACCallback;
import oracle.ucp.jdbc.oracle.RACCallbackGuard;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.RACInstanceImpl;
import oracle.ucp.jdbc.oracle.RACManager;
import oracle.ucp.jdbc.oracle.rlb.MetricsAccumulator;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfoList;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.routing.oracle.ShardManager;
import oracle.ucp.routing.oracle.ShardManagerImpl;
import oracle.ucp.util.ProlongedTask;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TimerManager;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
public class RACManagerImpl
implements Failoverable,
RACManager {
    private boolean m_isEntireServiceDownProcessed = false;
    private int m_cardinality = 0;
    private RACCallbackGuard m_cbk = null;
    private final FailoverStatisticsAccumulator eventAccumulator = new FailoverStatisticsAccumulator();
    private FailoverStatisticsItem currentEvent;
    public final MetricsAccumulator rlbMetricsAccumulator = new MetricsAccumulator();
    private int m_targetTearDownConnCount = 0;
    int m_tornDownConnCount = 0;
    int m_markedToCloseConnCount = 0;
    private int m_targetUpEventNewConnCount = 0;
    private int m_upEventNewConnCount = 0;
    final StringBuilder m_errorInfo = new StringBuilder(512);
    final AtomicReference<ONSDatabaseEventHandlerTask> m_failoverEventHandlerTask = new AtomicReference();
    private final OracleDatabaseInstanceInfoList m_dbInstanceInfoList;
    final AtomicReference<String> m_serviceName = new AtomicReference();
    private final AtomicReference<String> m_onsConfigurationString = new AtomicReference<String>("");
    private final int STARTED = 1;
    private final int STOPPED = 2;
    private int m_state = 2;
    protected final AtomicReference<String> m_fcfProcessingInfo = new AtomicReference<String>("");
    protected final AtomicReference<String> m_fcfProcessingInfoProcessedOnly = new AtomicReference<String>("");
    private final int ACTION_MARKDOWN = 100;
    private final int ACTION_CLEANUP = 200;
    private final BlockingQueue<OracleDatabaseInstanceInfo> m_instancesToGravitateQueue = new LinkedBlockingQueue<OracleDatabaseInstanceInfo>();
    private final Random m_rand = new Random(0L);
    private final AtomicReference<OracleGravitateConnectionPoolTask> m_gravitatePoolTask = new AtomicReference();
    private final AtomicBoolean m_gravitateTaskBusy = new AtomicBoolean();
    int[] m_mixTable;
    static final int MIX_TABLE_SIZE = 4096;
    static final int IRREDUCIBLE_POLYNOMIAL = 4105;
    static final int MIX_TABLE_GENERATOR = 3;
    private final AtomicReference<ONSRuntimeLBEventHandlerTask> m_rlbEventHandlerTask = new AtomicReference();
    private final AtomicBoolean m_runtimeLoadBalancingEnabled = new AtomicBoolean();
    protected ConnectionAffinityCallback m_connectionAffinityCallback = null;
    private final Map<String, Boolean> m_affinityMap = Collections.synchronizedMap(new HashMap());
    protected final AtomicLong m_successfulAffinityBasedBorrowCount = new AtomicLong(0L);
    protected final AtomicLong m_failedAffinityBasedBorrowCount = new AtomicLong(0L);
    protected final AtomicLong m_successfulRCLBBasedBorrowCount = new AtomicLong(0L);
    protected final AtomicLong m_failedRCLBBasedBorrowCount = new AtomicLong(0L);
    private final AtomicBoolean m_rclbMetricsPolicyEnabled = new AtomicBoolean(false);
    private final AtomicInteger m_dbVersion = new AtomicInteger(0);
    private final TaskManager m_taskManager;
    private final TimerManager m_timerManager;
    private boolean olderWLSCompatible;
    private final boolean isStrictWSAffinity;
    private final boolean isStrictXAAffinity;
    protected ONS currentONS = null;
    protected boolean calledStartONS = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;

    RACManagerImpl(TaskManager taskManager, TimerManager timerManager, boolean bl2, boolean bl3) throws UniversalConnectionPoolException {
        this.m_dbInstanceInfoList = new OracleDatabaseInstanceInfoList(this);
        this.m_taskManager = taskManager;
        this.m_timerManager = timerManager;
        this.isStrictWSAffinity = bl2;
        this.isStrictXAAffinity = bl3;
        Util.disableDriverHA();
        Util.disableImplicitBeginRequest();
    }

    private boolean validateServiceEvent(OracleFailoverEvent oracleFailoverEvent) {
        String string = oracleFailoverEvent.getServiceName();
        String string2 = oracleFailoverEvent.getDbUniqueName();
        return string != null && !string.equals("") && string2 != null && !string2.equals("");
    }

    private boolean validateHostDownEvent(OracleFailoverEvent oracleFailoverEvent) {
        String string = oracleFailoverEvent.getHostName();
        return string != null && !string.equals("");
    }

    @Override
    public void handleFailoverEvent(FailoverEvent failoverEvent) throws UniversalConnectionPoolException {
        if (failoverEvent == null || !(failoverEvent instanceof OracleFailoverEvent)) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(306);
        }
        OracleFailoverEvent oracleFailoverEvent = (OracleFailoverEvent)failoverEvent;
        String string = oracleFailoverEvent.getStatus();
        String string2 = oracleFailoverEvent.getEventType();
        String string3 = oracleFailoverEvent.getServiceName();
        String string4 = oracleFailoverEvent.getInstanceName();
        String string5 = oracleFailoverEvent.getDbUniqueName();
        String string6 = oracleFailoverEvent.getHostName();
        String string7 = oracleFailoverEvent.getReason();
        ClioSupport.ilogFinest(null, null, null, null, String.format("eventType: %s, status = %s", string2, string));
        if (string2.equals("database/event/service")) {
            if (string.equalsIgnoreCase("down") || string.equalsIgnoreCase("not_restarting") || string.equalsIgnoreCase("restart_failed")) {
                if (null == string3 || !string3.equals(this.m_serviceName.get())) {
                    this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, string3, string4, string5, string6));
                    ClioSupport.ilogFinest(null, null, null, null, String.format("The service event has service name: %s, not applicable to this pool and not processed.", string3));
                } else if (this.validateServiceEvent(oracleFailoverEvent)) {
                    this.currentEvent = new FailoverStatisticsItem(FailoverStatisticsItem.Type.SERVICE_DOWN, string3, string4, string5, string6);
                    this.eventAccumulator.addItem(this.currentEvent);
                    this.getRACCallback().initiateDownEventProcessing(oracleFailoverEvent);
                } else {
                    this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, string3, string4, string5, string6));
                    ClioSupport.ilogFinest(null, null, null, null, "The service down event is invalid and not processed.");
                }
            } else if (string.equalsIgnoreCase("up")) {
                if (null == string3 || !string3.equals(this.m_serviceName.get())) {
                    this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, string3, string4, string5, string6));
                    ClioSupport.ilogFinest(null, null, null, null, String.format("The service event has service name: %s, not applicable to this pool and not processed.", string3));
                } else if (this.validateServiceEvent(oracleFailoverEvent)) {
                    this.currentEvent = new FailoverStatisticsItem(FailoverStatisticsItem.Type.SERVICE_UP, string3, string4, string5, string6);
                    this.eventAccumulator.addItem(this.currentEvent);
                    int n2 = this.getRACCallback().initiateUpEventProcessing(oracleFailoverEvent);
                    this.processUpEvent2ndPhase(n2);
                    this.m_isEntireServiceDownProcessed = false;
                } else {
                    this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, string3, string4, string5, string6));
                    ClioSupport.ilogFinest(null, null, null, null, "The service up event is invalid and not processed.");
                }
            }
        } else if (string2.equals("database/event/host") && string.equalsIgnoreCase("nodedown")) {
            if (this.validateHostDownEvent(oracleFailoverEvent)) {
                this.currentEvent = new FailoverStatisticsItem(FailoverStatisticsItem.Type.HOST_DOWN, string3, string4, string5, string6);
                this.eventAccumulator.addItem(this.currentEvent);
                this.getRACCallback().initiateDownEventProcessing(oracleFailoverEvent);
            } else {
                this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, string3, string4, string5, string6));
                ClioSupport.ilogFinest(null, null, null, null, "The host down event is invalid and not processed.");
            }
        } else {
            this.eventAccumulator.addItem(new FailoverStatisticsItem(FailoverStatisticsItem.Type.NOT_PROCESSED, string3, string4, string5, string6));
            ClioSupport.ilogFinest(null, null, null, null, "Invalid Event received " + string2);
        }
        this.updateFCFProcessingInfo(this.eventAccumulator.toString());
        this.updateFCFProcessingInfoProcessedOnly(this.eventAccumulator.toStringProcessedOnly());
        this.resetFCFInternalMetrics();
    }

    @Override
    public int processUpEvent(FailoverablePooledConnection[] failoverablePooledConnectionArray, FailoverablePooledConnection[] failoverablePooledConnectionArray2, int n2, int n3, OracleFailoverEvent oracleFailoverEvent) throws UniversalConnectionPoolException {
        String string = oracleFailoverEvent.getStatus();
        String string2 = oracleFailoverEvent.getEventType();
        ClioSupport.ilogFinest(null, null, null, null, String.format("status=%s, eventType=%s", string, string2));
        int n4 = -1;
        if (string2.equals("database/event/service")) {
            if (string.equalsIgnoreCase("up")) {
                n4 = this.processServiceUpEvent(failoverablePooledConnectionArray, failoverablePooledConnectionArray2, n2, n3, oracleFailoverEvent.getInstanceName(), oracleFailoverEvent.getHostName(), oracleFailoverEvent.getDbUniqueName());
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "The service up event is invalid and not processed.");
            }
        } else {
            ClioSupport.ilogFinest(null, null, null, null, "Invalid Event received " + string2);
        }
        return n4;
    }

    private FailoverStatisticsCounters processConnectionsForServiceDown(FailoverablePooledConnection[] failoverablePooledConnectionArray, boolean bl2, String string, String string2, boolean bl3, long l2, int n2) {
        FailoverStatisticsCounters failoverStatisticsCounters = new FailoverStatisticsCounters();
        failoverStatisticsCounters.conns = failoverablePooledConnectionArray.length;
        for (int i2 = 0; i2 < failoverStatisticsCounters.conns; ++i2) {
            if (!this.failoverServiceEventMatch(failoverablePooledConnectionArray[i2], string, string2, l2)) continue;
            ++failoverStatisticsCounters.affected;
            FailoverActionResult failoverActionResult = this.processFailoverAction(failoverablePooledConnectionArray[i2], bl2, bl3, n2);
            failoverStatisticsCounters.update(failoverActionResult);
        }
        return failoverStatisticsCounters;
    }

    FailoverActionResult processFailoverAction(FailoverablePooledConnection failoverablePooledConnection, boolean bl2, boolean bl3, int n2) {
        FailoverActionResult failoverActionResult = FailoverActionResult.NOOP;
        switch (n2) {
            case 0: {
                try {
                    if (!bl2 && bl3) {
                        failoverablePooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
                        failoverActionResult = FailoverActionResult.MARKED_CLOSE_ON_RETURN;
                        break;
                    }
                    failoverablePooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                    failoverActionResult = FailoverActionResult.MARKED_BAD;
                }
                catch (UniversalConnectionPoolException universalConnectionPoolException) {
                    ClioSupport.ilogFinest(null, null, null, null, "setting status failed: " + this.getStackTraceString(universalConnectionPoolException));
                    this.m_errorInfo.append(", ").append(universalConnectionPoolException.getStackTrace()[0].toString());
                    failoverActionResult = FailoverActionResult.FAILED;
                }
                break;
            }
            case 1: {
                try {
                    failoverablePooledConnection.abort();
                }
                catch (Exception exception) {
                    ClioSupport.ilogFinest(null, null, null, null, "aborting connection failed: " + this.getStackTraceString(exception));
                    this.m_errorInfo.append(", ").append(exception.getStackTrace()[0].toString());
                    failoverActionResult = FailoverActionResult.FAILED;
                }
                try {
                    failoverablePooledConnection.close(!bl2);
                    failoverActionResult = FailoverActionResult.ABORTED_AND_CLOSED;
                }
                catch (UniversalConnectionPoolException universalConnectionPoolException) {
                    ClioSupport.ilogFinest(null, null, null, null, "closing connection failed: " + this.getStackTraceString(universalConnectionPoolException));
                    this.m_errorInfo.append(", ").append(universalConnectionPoolException.getStackTrace()[0].toString());
                    failoverActionResult = FailoverActionResult.FAILED;
                }
                break;
            }
        }
        return failoverActionResult;
    }

    private FailoverStatisticsCounters processConnectionsForHostDown(FailoverablePooledConnection[] failoverablePooledConnectionArray, boolean bl2, String string, long l2, int n2) {
        FailoverStatisticsCounters failoverStatisticsCounters = new FailoverStatisticsCounters();
        failoverStatisticsCounters.conns = failoverablePooledConnectionArray.length;
        for (int i2 = 0; i2 < failoverStatisticsCounters.conns; ++i2) {
            if (!this.failoverHostEventMatch(failoverablePooledConnectionArray[i2], string, l2)) continue;
            ++failoverStatisticsCounters.affected;
            FailoverActionResult failoverActionResult = this.processFailoverAction(failoverablePooledConnectionArray[i2], bl2, false, n2);
            failoverStatisticsCounters.update(failoverActionResult);
        }
        return failoverStatisticsCounters;
    }

    private int processServiceUpEvent(FailoverablePooledConnection[] failoverablePooledConnectionArray, FailoverablePooledConnection[] failoverablePooledConnectionArray2, int n2, int n3, String string, String string2, String string3) {
        int n4;
        this.currentEvent.availConns = failoverablePooledConnectionArray == null ? 0 : failoverablePooledConnectionArray.length;
        int n5 = this.currentEvent.borrowedConns = failoverablePooledConnectionArray2 == null ? 0 : failoverablePooledConnectionArray2.length;
        assert (this.m_dbInstanceInfoList != null);
        if (string != null && !"".equals(string)) {
            this.m_dbInstanceInfoList.markUpInstanceForUpEvent(this.m_serviceName.get(), string, string2, string3);
        }
        this.m_cardinality = this.m_dbInstanceInfoList.getUpInstancesCount();
        int n6 = this.currentEvent.availConns + this.currentEvent.borrowedConns;
        if (this.m_cardinality == 0) {
            ClioSupport.ilogFinest(null, null, null, null, "cardinality == 0, incorrect instance status");
            n4 = 0;
        } else if (this.m_cardinality == 1) {
            n4 = n2 - n6;
            if (n4 > 0) {
                ClioSupport.ilogFinest(null, null, null, null, String.format("first up instance, to obtain %d connections", n4));
            } else {
                n4 = 0;
                ClioSupport.ilogFinest(null, null, null, null, "first up instance, no new connections to obtain");
            }
        } else {
            n4 = this.getUpEventConnectionsToCreateCount(failoverablePooledConnectionArray, failoverablePooledConnectionArray2, n3, n6);
            ClioSupport.ilogFinest(null, null, null, null, String.format("cardinality is %d, to get %d connections", this.m_cardinality, n4));
        }
        this.m_targetUpEventNewConnCount = n4;
        return n4;
    }

    private void processUpEvent2ndPhase(int n2) {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            try {
                this.getRACCallback().openNewConnection(null, null);
                ++this.m_upEventNewConnCount;
                continue;
            }
            catch (Exception exception) {
                ClioSupport.ilogFinest(null, null, null, null, "UP-event processing failed when adding new connections " + this.getStackTraceString(exception));
                this.m_errorInfo.append(", ").append(exception.getStackTrace()[0].toString());
            }
        }
        this.currentEvent.cardinality = this.m_cardinality;
        this.currentEvent.targetedToTearConns = this.m_targetTearDownConnCount;
        this.currentEvent.tornDownConns = this.m_tornDownConnCount;
        this.currentEvent.markedToCloseConns = this.m_markedToCloseConnCount;
        this.currentEvent.targetUpEventNewConns = this.m_targetUpEventNewConnCount;
        this.currentEvent.upEventNewConnCount = this.m_upEventNewConnCount;
        n3 = this.m_upEventNewConnCount == this.m_targetUpEventNewConnCount && this.m_targetTearDownConnCount == this.m_tornDownConnCount + this.m_markedToCloseConnCount && 0 == this.m_errorInfo.length() ? 1 : 0;
        this.currentEvent.successful = n3;
        ClioSupport.ilogFinest(null, null, null, null, "Fast Connection Failover " + (n3 != 0 ? "succeeded" : "failed"));
    }

    private int getUpEventConnectionsToCreateCount(FailoverablePooledConnection[] failoverablePooledConnectionArray, FailoverablePooledConnection[] failoverablePooledConnectionArray2, int n2, int n3) {
        int n4 = 0;
        int n5 = n3 / (this.m_cardinality - 1);
        int n6 = n2 - n3;
        n4 = n5 <= n6 ? n5 : n6;
        if (n4 < n5) {
            int n7;
            int n8 = n3 / this.m_cardinality;
            this.m_targetTearDownConnCount = n7 = this.tearDownConnections(failoverablePooledConnectionArray, failoverablePooledConnectionArray2, n8);
            if (n7 > 0) {
                n4 = n7;
            }
        }
        return n4;
    }

    private int tearDownConnections(FailoverablePooledConnection[] failoverablePooledConnectionArray, FailoverablePooledConnection[] failoverablePooledConnectionArray2, int n2) {
        OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo;
        boolean bl2;
        int n3;
        assert (failoverablePooledConnectionArray != null);
        assert (failoverablePooledConnectionArray2 != null);
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < failoverablePooledConnectionArray.length; ++n3) {
            bl2 = true;
            oracleDatabaseInstanceInfo = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(failoverablePooledConnectionArray[n3].getInstance(), failoverablePooledConnectionArray[n3].getDatabase());
            if (oracleDatabaseInstanceInfo.getNumToTearDown() == -1) {
                oracleDatabaseInstanceInfo.setNumToTearDown(oracleDatabaseInstanceInfo.getNumberOfConnectionsCount() - n2);
            }
            if (oracleDatabaseInstanceInfo.getNumToTearDown() <= 0) continue;
            bl2 = FailoverActionResult.FAILED != this.processFailoverAction(failoverablePooledConnectionArray[n3], true, false, 0);
            boolean bl3 = bl2 = bl2 && FailoverActionResult.FAILED != this.processFailoverAction(failoverablePooledConnectionArray[n3], true, false, 1);
            if (!bl2) continue;
            oracleDatabaseInstanceInfo.decrementNumToTearDown();
            ++n4;
        }
        this.m_tornDownConnCount += n4;
        for (n3 = 0; n3 < failoverablePooledConnectionArray2.length; ++n3) {
            bl2 = true;
            oracleDatabaseInstanceInfo = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(failoverablePooledConnectionArray2[n3].getInstance(), failoverablePooledConnectionArray2[n3].getDatabase());
            if (oracleDatabaseInstanceInfo.getNumToTearDown() == -1) {
                oracleDatabaseInstanceInfo.setNumToTearDown(oracleDatabaseInstanceInfo.getNumberOfConnectionsCount() - n2);
            }
            if (oracleDatabaseInstanceInfo.getNumToTearDown() <= 0) continue;
            try {
                failoverablePooledConnectionArray2[n3].setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                ClioSupport.ilogFinest(null, null, null, null, "Borrowed connection tearing failed when setting status " + this.getStackTraceString(universalConnectionPoolException));
                this.m_errorInfo.append(", ").append(universalConnectionPoolException.getStackTrace()[0].toString());
                bl2 = false;
            }
            if (!bl2) continue;
            oracleDatabaseInstanceInfo.decrementNumToTearDown();
            ++n5;
        }
        this.m_markedToCloseConnCount += n5;
        ClioSupport.ilogFinest(null, null, null, null, String.format("available torn: %d, borrowed marked to close: %d", n4, n5));
        return n4 + n5;
    }

    boolean failoverServiceEventMatch(FailoverablePooledConnection failoverablePooledConnection, String string, String string2, long l2) {
        Object object;
        if (!this.olderWLSCompatible) {
            object = failoverablePooledConnection.getInstanceStartTime();
            ClioSupport.ilogFinest(null, null, null, null, String.format("INSTANCE START TIME: " + (null != object ? ((Date)object).toString() : "null"), new Object[0]));
            if (object != null && ((Date)object).getTime() > l2) {
                ClioSupport.ilogFinest(null, null, null, null, "instance started after FAN event");
                return false;
            }
        }
        object = failoverablePooledConnection.getDatabase();
        if (string == null) {
            return object == null || string2 == null || string2.equals(object);
        }
        String string3 = failoverablePooledConnection.getInstance();
        if (string3 == null || object == null) {
            return false;
        }
        return string.equals(string3) && string2.equals(object);
    }

    private boolean failoverHostEventMatch(FailoverablePooledConnection failoverablePooledConnection, String string, long l2) {
        Object object;
        if (!this.olderWLSCompatible) {
            object = failoverablePooledConnection.getInstanceStartTime();
            ClioSupport.ilogFinest(null, null, null, null, String.format("INSTANCE START TIME: %t", object));
            if (object != null && ((Date)object).getTime() > l2) {
                ClioSupport.ilogFinest(null, null, null, null, "instance started after FAN event");
                return false;
            }
        }
        object = failoverablePooledConnection.getHost();
        return string != null && object != null && string.equals(object);
    }

    private void resetFCFInternalMetrics() {
        this.m_targetTearDownConnCount = 0;
        this.m_tornDownConnCount = 0;
        this.m_markedToCloseConnCount = 0;
        this.m_targetUpEventNewConnCount = 0;
        this.m_upEventNewConnCount = 0;
        int n2 = this.m_errorInfo.length();
        this.m_errorInfo.delete(0, n2);
    }

    @DisableTrace
    String getStackTraceString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter(1024);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }

    private void startONS(final String string) throws UniversalConnectionPoolException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public Object run() throws UniversalConnectionPoolException {
                    try {
                        RACManagerImpl.this.currentONS = new ONS(string);
                        ClioSupport.ilogFinest(null, null, null, null, String.format("ONS(%s) succeeded", Util.maskONSConfigurationString(string)));
                    }
                    catch (ONSException oNSException) {
                        RACManagerImpl.this.currentONS = null;
                        throw UCPErrorHandler.newUniversalConnectionPoolException(308, oNSException);
                    }
                    finally {
                        RACManagerImpl.this.calledStartONS = true;
                    }
                    return null;
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(RACManagerImpl.class, String.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.currentONS = null;
            throw UCPErrorHandler.newUniversalConnectionPoolException(308, privilegedActionException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws UniversalConnectionPoolException {
        if (this.m_state != 2) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(60);
        }
        this.olderWLSCompatible = Util.isPreWLS1212Compatible();
        String string = this.m_onsConfigurationString.get();
        if ((string == null || "".equals(string)) && !this.olderWLSCompatible) {
            this.getAutoONSConfigurationFromServer();
        }
        if ((string = this.m_onsConfigurationString.get()) != null && !"".equals(string)) {
            this.startONS(string);
        }
        Object object = this.m_failoverEventHandlerTask;
        synchronized (object) {
            if (this.m_failoverEventHandlerTask.get() != null) {
                this.stop();
            } else {
                this.m_failoverEventHandlerTask.set(new ONSDatabaseEventHandlerTask(this.m_serviceName.get(), this, this.m_taskManager));
            }
        }
        object = this.m_failoverEventHandlerTask.get();
        if (object != null) {
            ((ONSDatabaseEventHandlerTask)object).setTerminate(false);
            try {
                ((FailoverEventHandlerTaskBase)object).start();
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                throw new UniversalConnectionPoolException(rejectedExecutionException);
            }
        }
        this.m_state = 1;
        ClioSupport.ilogFine(null, null, null, null, "started");
    }

    private FailoverEventHandlerTask getFailoverEventHandlerTask() {
        return this.m_failoverEventHandlerTask.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws UniversalConnectionPoolException {
        if (this.m_state == 2) {
            ClioSupport.ilogFinest(null, null, null, null, "failover already stopped");
            return;
        }
        this.terminateRuntimeLoadBalancing();
        ONSDatabaseEventHandlerTask oNSDatabaseEventHandlerTask = this.m_failoverEventHandlerTask.get();
        if (oNSDatabaseEventHandlerTask != null) {
            oNSDatabaseEventHandlerTask.setTerminate(true);
            oNSDatabaseEventHandlerTask.waitTerminate();
        }
        AtomicReference<ONSDatabaseEventHandlerTask> atomicReference = this.m_failoverEventHandlerTask;
        synchronized (atomicReference) {
            this.m_failoverEventHandlerTask.set(null);
        }
        this.resetRACStatistics();
        this.olderWLSCompatible = false;
        if (this.currentONS != null) {
            this.currentONS.shutdown();
            this.currentONS = null;
            this.calledStartONS = false;
        }
        this.m_state = 2;
        ClioSupport.ilogFine(null, null, null, null, "stopped");
    }

    private void resetRACStatistics() {
        this.m_successfulAffinityBasedBorrowCount.set(0L);
        this.m_failedAffinityBasedBorrowCount.set(0L);
        this.m_successfulRCLBBasedBorrowCount.set(0L);
        this.m_failedRCLBBasedBorrowCount.set(0L);
        this.m_fcfProcessingInfo.set("");
        this.m_fcfProcessingInfoProcessedOnly.set("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFailoverEventHandlerTask(ONSDatabaseEventHandlerTask oNSDatabaseEventHandlerTask) {
        AtomicReference<ONSDatabaseEventHandlerTask> atomicReference = this.m_failoverEventHandlerTask;
        synchronized (atomicReference) {
            this.m_failoverEventHandlerTask.set(oNSDatabaseEventHandlerTask);
        }
    }

    @Override
    public void setFailoverInfo(Object object) throws UniversalConnectionPoolException {
        assert (false) : "internal error: this method must not be invoked";
    }

    void updateDatabaseInstanceInfo(Object object, boolean bl2, boolean bl3) throws UniversalConnectionPoolException {
        OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo = (OracleDatabaseInstanceInfo)object;
        this.m_serviceName.compareAndSet(null, oracleDatabaseInstanceInfo.getServiceName());
        assert (this.m_dbInstanceInfoList != null);
        this.m_dbInstanceInfoList.updateDatabaseInstanceInfo(oracleDatabaseInstanceInfo, bl2, bl3);
    }

    @Override
    @DisableTrace
    public Object getFailoverInfo() {
        return this.m_dbInstanceInfoList;
    }

    @Override
    @DisableTrace
    public String getONSConfiguration() {
        return this.m_onsConfigurationString.get();
    }

    @Override
    public void setONSConfiguration(String string) throws UniversalConnectionPoolException {
        String string2;
        ClioSupport.ilogFinest(null, null, null, null, "onsConfigStr: " + Util.maskONSConfigurationString(string));
        if (string == null) {
            string = "";
        }
        if (string.equals(string2 = this.m_onsConfigurationString.getAndSet(string))) {
            return;
        }
        if (this.m_state == 1) {
            this.stop();
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFCFProcessingInfo(String string) {
        AtomicReference<String> atomicReference = this.m_fcfProcessingInfo;
        synchronized (atomicReference) {
            this.m_fcfProcessingInfo.set(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFCFProcessingInfoProcessedOnly(String string) {
        AtomicReference<String> atomicReference = this.m_fcfProcessingInfoProcessedOnly;
        synchronized (atomicReference) {
            this.m_fcfProcessingInfoProcessedOnly.set(string);
        }
    }

    @Override
    public void markDownConnectionsForDownEvent(FailoverablePooledConnection[] failoverablePooledConnectionArray, FailoverablePooledConnection[] failoverablePooledConnectionArray2, OracleFailoverEvent oracleFailoverEvent) {
        this.processConnectionsForDownEvent(failoverablePooledConnectionArray, failoverablePooledConnectionArray2, oracleFailoverEvent, 100);
    }

    @Override
    public void cleanupConnectionsForDownEvent(FailoverablePooledConnection[] failoverablePooledConnectionArray, FailoverablePooledConnection[] failoverablePooledConnectionArray2, OracleFailoverEvent oracleFailoverEvent) {
        this.processConnectionsForDownEvent(failoverablePooledConnectionArray, failoverablePooledConnectionArray2, oracleFailoverEvent, 200);
    }

    private void processConnectionsForDownEvent(FailoverablePooledConnection[] failoverablePooledConnectionArray, FailoverablePooledConnection[] failoverablePooledConnectionArray2, OracleFailoverEvent oracleFailoverEvent, int n2) {
        String string = oracleFailoverEvent.getStatus();
        String string2 = oracleFailoverEvent.getEventType();
        long l2 = oracleFailoverEvent.getTimestamp();
        ClioSupport.ilogFinest(null, null, null, null, String.format("status=%s, eventType=%s", string, string2));
        if (string2.equals("database/event/service")) {
            if (string.equalsIgnoreCase("down") || string.equalsIgnoreCase("not_restarting") || string.equalsIgnoreCase("restart_failed")) {
                boolean bl2;
                String string3 = oracleFailoverEvent.getInstanceName();
                String string4 = oracleFailoverEvent.getDbUniqueName();
                String string5 = oracleFailoverEvent.getReason();
                boolean bl3 = bl2 = string5 != null && string5.equals("user");
                if (n2 == 100) {
                    if (!this.m_isEntireServiceDownProcessed) {
                        this.currentEvent.availMarked = this.processConnectionsForServiceDown(failoverablePooledConnectionArray, true, string3, string4, bl2, l2, 0);
                        this.currentEvent.borrowedMarked = this.processConnectionsForServiceDown(failoverablePooledConnectionArray2, false, string3, string4, bl2, l2, 0);
                        if (string3 == null) {
                            this.m_isEntireServiceDownProcessed = false;
                        }
                    }
                } else if (n2 == 200) {
                    boolean bl4;
                    this.currentEvent.availConns = failoverablePooledConnectionArray == null ? 0 : failoverablePooledConnectionArray.length;
                    int n3 = this.currentEvent.borrowedConns = failoverablePooledConnectionArray2 == null ? 0 : failoverablePooledConnectionArray2.length;
                    if (!bl2) {
                        this.currentEvent.borrowedClosed = this.processConnectionsForServiceDown(failoverablePooledConnectionArray2, false, string3, string4, bl2, l2, 1);
                    }
                    this.currentEvent.availClosed = this.processConnectionsForServiceDown(failoverablePooledConnectionArray, true, string3, string4, bl2, l2, 1);
                    assert (this.m_dbInstanceInfoList != null);
                    this.m_dbInstanceInfoList.markDownInstanceForServiceDownEvent(string3, string4);
                    this.currentEvent.reason = string5;
                    this.currentEvent.successful = bl4 = this.currentEvent.availClosed.failed == 0 && this.currentEvent.borrowedClosed.failed == 0 && this.m_errorInfo.length() == 0;
                    ClioSupport.ilogFinest(null, null, null, null, "Fast Connection Failover " + (bl4 ? "succeeded" : "failed"));
                }
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "The down event is invalid and not processed.");
            }
        } else if (string2.equals("database/event/host") && string.equalsIgnoreCase("nodedown")) {
            String string6 = oracleFailoverEvent.getHostName();
            if (n2 == 100) {
                this.currentEvent.availMarked = this.processConnectionsForHostDown(failoverablePooledConnectionArray, true, string6, l2, 0);
                this.currentEvent.borrowedMarked = this.processConnectionsForHostDown(failoverablePooledConnectionArray2, false, string6, l2, 0);
            } else if (n2 == 200) {
                boolean bl5;
                this.currentEvent.availConns = failoverablePooledConnectionArray == null ? 0 : failoverablePooledConnectionArray.length;
                this.currentEvent.borrowedConns = failoverablePooledConnectionArray2 == null ? 0 : failoverablePooledConnectionArray2.length;
                this.currentEvent.borrowedClosed = this.processConnectionsForHostDown(failoverablePooledConnectionArray2, false, string6, l2, 1);
                this.currentEvent.availClosed = this.processConnectionsForHostDown(failoverablePooledConnectionArray, true, string6, l2, 1);
                assert (this.m_dbInstanceInfoList != null);
                this.m_dbInstanceInfoList.markDownInstanceForHostDownEvent(string6);
                this.currentEvent.successful = bl5 = this.currentEvent.availClosed.failed == 0 && this.currentEvent.borrowedClosed.failed == 0 && this.m_errorInfo.length() == 0;
                ClioSupport.ilogFinest(null, null, null, null, "Fast Connection Failover " + (bl5 ? "succeeded" : "failed"));
            }
        } else {
            ClioSupport.ilogFinest(null, null, null, null, "Invalid Event received " + string2);
        }
    }

    @Override
    public synchronized void registerRACCallback(RACCallback rACCallback) {
        this.m_cbk = new RACCallbackGuard(rACCallback);
    }

    @Override
    public synchronized void unregisterRACCallback(RACCallback rACCallback) {
        if (this.m_cbk == rACCallback) {
            this.m_cbk = null;
        }
    }

    public synchronized RACCallbackGuard getRACCallback() {
        return this.m_cbk;
    }

    @Override
    public void connectionOpened(FailoverablePooledConnection failoverablePooledConnection) throws UniversalConnectionPoolException {
        OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo = new OracleDatabaseInstanceInfo(failoverablePooledConnection.getDatabase(), failoverablePooledConnection.getInstance(), failoverablePooledConnection.getHost());
        oracleDatabaseInstanceInfo.setServiceName(failoverablePooledConnection.getService());
        oracleDatabaseInstanceInfo.setId(failoverablePooledConnection.getInstanceNumber());
        this.updateDatabaseInstanceInfo(oracleDatabaseInstanceInfo, true, true);
        if (this.m_state == 1 && !this.isRuntimeLoadBalancingEnabled()) {
            this.setRuntimeLoadBalancingEnabled(true);
            this.setDatabaseVersion(failoverablePooledConnection.getDatabaseVersion());
        }
    }

    @Override
    public void connectionClosed(FailoverablePooledConnection failoverablePooledConnection) throws UniversalConnectionPoolException {
        OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo = new OracleDatabaseInstanceInfo(failoverablePooledConnection.getDatabase(), failoverablePooledConnection.getInstance(), failoverablePooledConnection.getHost());
        oracleDatabaseInstanceInfo.setServiceName(failoverablePooledConnection.getService());
        this.updateDatabaseInstanceInfo(oracleDatabaseInstanceInfo, true, false);
        if (failoverablePooledConnection.isNamedInstanceConnection()) {
            this.decrementNamedInstanceConnCount(oracleDatabaseInstanceInfo);
        }
    }

    @Override
    @DisableTrace
    public String getFCFProcessingInfoProcessedOnly() {
        return this.m_fcfProcessingInfoProcessedOnly.get();
    }

    @Override
    @DisableTrace
    public String getFCFProcessingInfo() {
        return this.m_fcfProcessingInfo.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementNamedInstanceConnCount(OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo) {
        RACManagerImpl rACManagerImpl = this;
        synchronized (rACManagerImpl) {
            OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo2 = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(oracleDatabaseInstanceInfo.getInstanceName(), oracleDatabaseInstanceInfo.getDatabaseName());
            if (oracleDatabaseInstanceInfo2.getNumNamedInstanceConns() > 0) {
                oracleDatabaseInstanceInfo2.decrementNumNamedInstanceConns();
            }
        }
    }

    @Override
    public boolean isRuntimeLoadBalancingEnabled() {
        return this.m_runtimeLoadBalancingEnabled.get();
    }

    public synchronized void setRuntimeLoadBalancingEnabled(boolean bl2) throws UniversalConnectionPoolException {
        this.m_runtimeLoadBalancingEnabled.set(bl2);
        if (bl2) {
            this.initRuntimeLoadBalancing(this.m_serviceName.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void initRuntimeLoadBalancing(String string) throws UniversalConnectionPoolException {
        AtomicReference<ONSRuntimeLBEventHandlerTask> atomicReference = this.m_rlbEventHandlerTask;
        synchronized (atomicReference) {
            if (this.m_rlbEventHandlerTask.get() == null) {
                this.m_rlbEventHandlerTask.set(new ONSRuntimeLBEventHandlerTask(this.m_serviceName.get(), this));
            }
        }
        try {
            this.m_rlbEventHandlerTask.get().start();
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new UniversalConnectionPoolException(rejectedExecutionException);
        }
        this.generateMixTable();
    }

    protected synchronized void terminateRuntimeLoadBalancing() throws UniversalConnectionPoolException {
        this.cleanupRLBTasks();
        this.setRuntimeLoadBalancingEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRuntimeLoadBalancingEventHandlerTask(ONSRuntimeLBEventHandlerTask oNSRuntimeLBEventHandlerTask) {
        AtomicReference<ONSRuntimeLBEventHandlerTask> atomicReference = this.m_rlbEventHandlerTask;
        synchronized (atomicReference) {
            this.m_rlbEventHandlerTask.set(oNSRuntimeLBEventHandlerTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDatabaseInstances() {
        assert (this.m_dbInstanceInfoList != null);
        this.m_dbInstanceInfoList.scheduleInstancesForGravitation(this.m_instancesToGravitateQueue);
        this.setRCLBMetricsPolicyEnabled(true);
        AtomicReference<OracleGravitateConnectionPoolTask> atomicReference = this.m_gravitatePoolTask;
        synchronized (atomicReference) {
            OracleGravitateConnectionPoolTask oracleGravitateConnectionPoolTask = this.m_gravitatePoolTask.get();
            if (oracleGravitateConnectionPoolTask != null && this.m_gravitateTaskBusy.get()) {
                ClioSupport.ilogFinest(null, null, null, null, "about to stop gravitate thread");
                oracleGravitateConnectionPoolTask.stop();
            }
            this.m_gravitatePoolTask.set(new OracleGravitateConnectionPoolTask(this));
            this.m_gravitatePoolTask.get().start();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void gravitatePool() {
        this.m_gravitateTaskBusy.set(true);
        try {
            while (true) {
                ClioSupport.ilogFinest(null, null, null, null, "polling instance queue");
                OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo = this.m_instancesToGravitateQueue.poll(1L, TimeUnit.SECONDS);
                if (null == oracleDatabaseInstanceInfo) {
                    ClioSupport.ilogFinest(null, null, null, null, "no more instances to retire");
                    return;
                }
                try {
                    this.getRACCallback().tearDownConnectionsForInstance(oracleDatabaseInstanceInfo, oracleDatabaseInstanceInfo.getConnsToTearDown());
                    continue;
                }
                finally {
                    oracleDatabaseInstanceInfo.setRebalancingState(OracleDatabaseInstanceInfo.RebalancingState.SHRUNK);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            ClioSupport.ilogThrowing(null, null, null, null, interruptedException);
            return;
        }
        finally {
            this.m_gravitateTaskBusy.set(false);
            ClioSupport.ilogFinest(null, null, null, null, "gravitation done");
        }
    }

    @Override
    public FailoverablePooledConnection selectConnectionPerRCLBAndAffinity(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        ConnectionAffinityCallback connectionAffinityCallback = this.getConnectionAffinityCallback();
        ClioSupport.ilogFinest(null, null, null, null, "affinityPolicy=" + (Object)((Object)connectionAffinityCallback.getAffinityPolicy()));
        if (connectionAffinityCallback.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.DATA_BASED_AFFINITY) {
            return this.selectConnectionPerDataBasedAffinity(connectionRetrievalInfo);
        }
        Object object = connectionAffinityCallback.getConnectionAffinityContext();
        FailoverablePooledConnection failoverablePooledConnection = null;
        if (object == null) {
            ClioSupport.ilogFinest(null, null, null, null, "Application has no affinity context established");
            boolean bl2 = connectionAffinityCallback.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY || this.rlbMetricsAccumulator.getReel().size() == 0;
            ClioSupport.ilogFinest(null, null, null, null, "isInstanceAffinityEnabled=" + bl2);
            failoverablePooledConnection = this.selectConnectionPerRCLB(connectionRetrievalInfo);
            ClioSupport.ilogFinest(null, null, null, null, "Connection obtained based on RCLB: " + failoverablePooledConnection);
            if (failoverablePooledConnection != null) {
                OracleConnectionAffinityContext oracleConnectionAffinityContext = this.getUpdatedAffinityContextAfterRCLB(failoverablePooledConnection, bl2);
                if (oracleConnectionAffinityContext != null) {
                    connectionAffinityCallback.setConnectionAffinityContext(oracleConnectionAffinityContext.clone());
                }
                ClioSupport.ilogFinest(null, null, null, null, "Application affinity context: " + oracleConnectionAffinityContext);
            }
        } else {
            Object object2;
            ClioSupport.ilogFinest(null, null, null, null, "Application has affinity context established");
            OracleConnectionAffinityContext oracleConnectionAffinityContext = (OracleConnectionAffinityContext)object;
            boolean bl3 = oracleConnectionAffinityContext.isForInstanceAffinity();
            String string = oracleConnectionAffinityContext.getInstanceName();
            String string2 = oracleConnectionAffinityContext.getDatabaseUniqueName();
            String string3 = oracleConnectionAffinityContext.getServiceName();
            boolean bl4 = false;
            if (!bl3) {
                object2 = this.generateDatabaseInstanceKey(string, string2, string3);
                bl4 = this.getConnectionAffinityValue((String)object2);
            }
            if (bl3 || bl4) {
                ClioSupport.ilogFinest(null, null, null, null, (bl3 ? "Database instance" : "Temporal") + " affinity");
                ClioSupport.ilogFinest(null, null, null, null, "use application's affinityContext: " + oracleConnectionAffinityContext.toString());
                failoverablePooledConnection = this.getRACCallback().getAvailableConnectionToInstance(connectionRetrievalInfo, new RACInstanceImpl(string3, string, "", string2));
                ClioSupport.ilogFinest(null, null, null, null, "Connection found matching affinity context: " + failoverablePooledConnection);
                if (failoverablePooledConnection == null) {
                    ClioSupport.ilogFinest(null, null, null, null, "Affinity contexts match but no connection available to " + oracleConnectionAffinityContext.toString());
                    failoverablePooledConnection = this.getConnectionToNamedInstance(string, string2, bl3);
                    ClioSupport.ilogFinest(null, null, null, null, "Connection obtained to named instance: " + failoverablePooledConnection);
                    if (failoverablePooledConnection == null) {
                        if (Util.isAffinityStrict() || connectionAffinityCallback.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.WEBSESSION_BASED_AFFINITY && this.isStrictWSAffinity || connectionAffinityCallback.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY && this.isStrictXAAffinity) {
                            ClioSupport.ilogFinest(null, null, null, null, "unable to follow affinity strictly, setting affinity context to null");
                            connectionAffinityCallback.setConnectionAffinityContext(null);
                        } else {
                            failoverablePooledConnection = this.selectConnectionPerRCLB(connectionRetrievalInfo);
                            ClioSupport.ilogFinest(null, null, null, null, "Connection obtained based on RCLB: " + failoverablePooledConnection);
                            if (failoverablePooledConnection != null) {
                                object2 = this.getUpdatedAffinityContextAfterRCLB(failoverablePooledConnection, bl3);
                                if (!bl3) {
                                    connectionAffinityCallback.setConnectionAffinityContext(object2);
                                    ClioSupport.ilogFinest(null, null, null, null, "Temporal affinity. Application affinity context is updated: " + object2);
                                }
                            }
                        }
                        this.incrementFailedAffinityBasedBorrowCount();
                    } else {
                        this.incrementSuccessfulAffinityBasedBorrowCount();
                    }
                } else {
                    this.incrementSuccessfulAffinityBasedBorrowCount();
                }
            } else {
                failoverablePooledConnection = this.selectConnectionPerRCLB(connectionRetrievalInfo);
                ClioSupport.ilogFinest(null, null, null, null, "Connection obtained based on RCLB: " + failoverablePooledConnection);
                if (failoverablePooledConnection != null) {
                    object2 = this.getUpdatedAffinityContextAfterRCLB(failoverablePooledConnection, false);
                    connectionAffinityCallback.setConnectionAffinityContext(object2);
                    ClioSupport.ilogFinest(null, null, null, null, "Temporal affinity miss. Application affinity context is updated: " + object2);
                }
                this.incrementFailedAffinityBasedBorrowCount();
            }
        }
        return failoverablePooledConnection;
    }

    private OracleConnectionAffinityContext getUpdatedAffinityContextAfterRCLB(FailoverablePooledConnection failoverablePooledConnection, boolean bl2) {
        Object object;
        boolean bl3 = true;
        String string = failoverablePooledConnection.getInstance();
        String string2 = failoverablePooledConnection.getDatabase();
        String string3 = failoverablePooledConnection.getService();
        if (!bl2) {
            ClioSupport.ilogFinest(null, null, null, null, "Checking affinity hint for this instance");
            object = this.generateDatabaseInstanceKey(string, string2, string3);
            if (!this.getConnectionAffinityValue((String)object)) {
                bl3 = false;
            }
        }
        if (bl3) {
            ClioSupport.ilogFinest(null, null, null, null, "Creating temporary updated affinity context");
            object = new OracleConnectionAffinityContext();
            ((OracleConnectionAffinityContext)object).setConnectionPoolID(this.getRACCallback().getPoolName());
            ((OracleConnectionAffinityContext)object).setInstanceName(string);
            ((OracleConnectionAffinityContext)object).setDatabaseUniqueName(string2);
            ((OracleConnectionAffinityContext)object).setServiceName(string3);
            if (bl2) {
                ClioSupport.ilogFinest(null, null, null, null, "New context is for instance affinity");
                ((OracleConnectionAffinityContext)object).setForInstanceAffinity(true);
            }
            ClioSupport.ilogFinest(null, null, null, null, "New Affinity context created: " + object);
            return object;
        }
        ClioSupport.ilogFinest(null, null, null, null, "Temporal Affinity hint is false");
        return null;
    }

    private FailoverablePooledConnection getConnectionToNamedInstance(String string, String string2, boolean bl2) {
        FailoverablePooledConnection failoverablePooledConnection = null;
        if (this.m_dbInstanceInfoList.isNamedInstanceConnectingAllowed(string, string2, bl2)) {
            ClioSupport.ilogFinest(null, null, null, null, "named instance connecting allowed");
            OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(string, string2);
            String string3 = oracleDatabaseInstanceInfo.getNamedInstanceUrl();
            try {
                RACInstanceImpl rACInstanceImpl = new RACInstanceImpl(oracleDatabaseInstanceInfo);
                failoverablePooledConnection = this.getRACCallback().openNewConnection(string3, rACInstanceImpl);
            }
            catch (Exception exception) {
                failoverablePooledConnection = null;
                ClioSupport.ilogThrowing(null, null, null, null, exception);
            }
            if (failoverablePooledConnection != null) {
                failoverablePooledConnection.setAsNamedInstanceConnection();
                oracleDatabaseInstanceInfo.incrementNumNamedInstanceConns();
            }
        } else {
            ClioSupport.ilogFinest(null, null, null, null, "named instance connecting disallowed");
        }
        return failoverablePooledConnection;
    }

    protected FailoverablePooledConnection selectConnectionPerDataBasedAffinity(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        DataBasedConnectionAffinityCallback dataBasedConnectionAffinityCallback = (DataBasedConnectionAffinityCallback)this.getConnectionAffinityCallback();
        int n2 = dataBasedConnectionAffinityCallback.getPartitionId();
        Object object = null;
        if (n2 < 0) {
            ClioSupport.ilogFinest(null, null, null, null, "Callback returns incorrect partition-id.");
        } else {
            ClioSupport.ilogFinest(null, null, null, null, "Callback returns partition-id: " + n2);
            int n3 = 128;
            int n4 = this.m_dbInstanceInfoList.size();
            if (n4 > 128) {
                ClioSupport.ilogFinest(null, null, null, null, String.format("data affinity is disabled, cardinality>128 (%d)", n4));
            }
            while (true) {
                int n5 = (n2 %= 4096) % 128;
                OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(n5);
                ClioSupport.ilogFinest(null, null, null, null, String.format("Partition-id=%d, dbInstance=%s", n2, oracleDatabaseInstanceInfo));
                if (oracleDatabaseInstanceInfo == null) {
                    n2 = this.m_mixTable[n2];
                    ClioSupport.ilogFinest(null, null, null, null, "Bad instance, dbinfo == null in table, remap to partition-id:" + n2);
                    continue;
                }
                OracleDatabaseInstanceInfoList.INSTANCE_CATEGORY_FOR_DATA_AFFINITY iNSTANCE_CATEGORY_FOR_DATA_AFFINITY = this.m_dbInstanceInfoList.getInstanceCategory(oracleDatabaseInstanceInfo);
                String string = oracleDatabaseInstanceInfo.getInstanceName();
                String string2 = oracleDatabaseInstanceInfo.getDatabaseName();
                String string3 = oracleDatabaseInstanceInfo.getServiceName();
                switch (iNSTANCE_CATEGORY_FOR_DATA_AFFINITY) {
                    case GOOD_INSTANCE: {
                        ClioSupport.ilogFinest(null, null, null, null, "Data-based affinity. Found good instance based on partition-id.");
                        ClioSupport.ilogFinest(null, null, null, null, "Partition-id=" + n2);
                        ClioSupport.ilogFinest(null, null, null, null, String.format("Good instance: instance=%s, service=%s, db=%s", string, string3, string2));
                        RACInstanceImpl rACInstanceImpl = new RACInstanceImpl(string3, string, "", string2);
                        object = this.getRACCallback().getAvailableConnectionToInstance(connectionRetrievalInfo, rACInstanceImpl);
                        ClioSupport.ilogFinest(null, null, null, null, "Available connection found in chosen good instance: " + object);
                        if (object == null) {
                            ClioSupport.ilogFinest(null, null, null, null, String.format("Found good instance but no connection available to serviceName: %s, instanceName: %s, dbUniqueName: %s", string3, string, string2));
                            object = this.getConnectionToNamedInstance(string, string2, true);
                            ClioSupport.ilogFinest(null, null, null, null, "Connection obtained to named instance: " + object);
                            if (object == null) {
                                object = this.selectConnectionPerRCLB(connectionRetrievalInfo);
                                ClioSupport.ilogFinest(null, null, null, null, "Connection obtained based on RCLB: " + object);
                                this.incrementFailedAffinityBasedBorrowCount();
                                break;
                            }
                            this.incrementSuccessfulAffinityBasedBorrowCount();
                            break;
                        }
                        this.incrementSuccessfulAffinityBasedBorrowCount();
                        break;
                    }
                    case VIOLATING_INSTANCE: {
                        ClioSupport.ilogFinest(null, null, null, null, String.format("Violating instance: instance=%s, service=%s, db=%s", string, string3, string2));
                        object = this.selectConnectionPerRCLB(connectionRetrievalInfo);
                        ClioSupport.ilogFinest(null, null, null, null, "Connection obtained based on RCLB: " + object);
                        this.incrementFailedAffinityBasedBorrowCount();
                        break;
                    }
                    case BAD_INSTANCE: {
                        n2 = this.m_mixTable[n2];
                        ClioSupport.ilogFinest(null, null, null, null, String.format("Bad instance, service: %s, instance: %s, db: %s; remap to partition-id: %d", string3, string, string2, n2));
                    }
                }
                if (object != null) break;
            }
        }
        ClioSupport.ilogFinest(null, null, null, null, "method returns connection: " + object.toString());
        return object;
    }

    private void generateMixTable() {
        if (this.m_mixTable != null) {
            return;
        }
        int[] nArray = new int[4096];
        nArray[0] = 1;
        for (int i2 = 1; i2 < 4096; ++i2) {
            nArray[i2] = nArray[i2 - 1] << 1 ^ nArray[i2 - 1];
            if ((nArray[i2] & 0x1000) == 0) continue;
            int n2 = i2;
            nArray[n2] = nArray[n2] ^ 0x1009;
        }
        int[] nArray2 = new int[4096];
        for (int i3 = 0; i3 < 4096; ++i3) {
            nArray2[nArray[i3]] = i3;
        }
        nArray2[0] = 4096;
        int[] nArray3 = new int[4096];
        for (int i4 = 1; i4 < 4096; ++i4) {
            nArray3[nArray2[i4 - 1] - 1] = nArray2[i4] - 1;
        }
        nArray3[nArray2[4095] - 1] = nArray2[0] - 1;
        this.m_mixTable = nArray3;
    }

    private void destroyMixTable() {
        this.m_mixTable = null;
    }

    @Override
    public FailoverablePooledConnection selectConnectionPerRCLB(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        boolean bl2;
        assert (this.m_dbInstanceInfoList != null);
        FailoverablePooledConnection failoverablePooledConnection = null;
        boolean bl3 = bl2 = this.isRCLBMetricsPolicyEnabled() && this.m_dbInstanceInfoList.size() > 0 && this.m_dbInstanceInfoList.useGoodGroup();
        if (bl2) {
            failoverablePooledConnection = this.m_dbInstanceInfoList.selectConnectionPerRLBMetrics(connectionRetrievalInfo, this);
        }
        if (!bl2) {
            int n2;
            Collection<FailoverablePooledConnection> collection = this.getRACCallback().getAvailableConnections(connectionRetrievalInfo);
            if (collection == null || collection.size() == 0) {
                return null;
            }
            int n3 = collection.size();
            int n4 = this.m_rand.nextInt(n3);
            Iterator<FailoverablePooledConnection> iterator = collection.iterator();
            for (n2 = 0; n2 < (n4 + n3) % n3; ++n2) {
                iterator.next();
            }
            for (n2 = 0; n2 < n3; ++n2) {
                FailoverablePooledConnection failoverablePooledConnection2;
                UniversalPooledConnectionStatus universalPooledConnectionStatus;
                if (!iterator.hasNext()) {
                    iterator = collection.iterator();
                }
                if (!(universalPooledConnectionStatus = (failoverablePooledConnection2 = iterator.next()).getStatus()).equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) continue;
                failoverablePooledConnection = failoverablePooledConnection2;
                break;
            }
            this.incrementFailedRCLBBasedBorrowCount();
        }
        return failoverablePooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupRLBTasks() {
        ProlongedTask prolongedTask;
        AtomicReference<ProlongedTask> atomicReference = this.m_rlbEventHandlerTask;
        synchronized (atomicReference) {
            prolongedTask = this.m_rlbEventHandlerTask.get();
            if (prolongedTask != null) {
                ((ONSRuntimeLBEventHandlerTask)prolongedTask).setTerminate(true);
            }
        }
        atomicReference = this.m_gravitatePoolTask;
        synchronized (atomicReference) {
            prolongedTask = this.m_gravitatePoolTask.get();
            if (prolongedTask != null) {
                prolongedTask.stop();
                this.m_gravitatePoolTask.set(null);
            }
        }
        this.destroyMixTable();
    }

    @Override
    @DisableTrace
    public long getSuccessfulAffinityBasedBorrowCount() {
        return this.m_successfulAffinityBasedBorrowCount.get();
    }

    @Override
    @DisableTrace
    public long getFailedAffinityBasedBorrowCount() {
        return this.m_failedAffinityBasedBorrowCount.get();
    }

    @Override
    @DisableTrace
    public long getSuccessfulRCLBBasedBorrowCount() {
        return this.m_successfulRCLBBasedBorrowCount.get();
    }

    @Override
    @DisableTrace
    public long getFailedRCLBBasedBorrowCount() {
        return this.m_failedRCLBBasedBorrowCount.get();
    }

    public void incrementSuccessfulAffinityBasedBorrowCount() {
        this.m_successfulAffinityBasedBorrowCount.incrementAndGet();
    }

    protected void incrementFailedAffinityBasedBorrowCount() {
        this.m_failedAffinityBasedBorrowCount.incrementAndGet();
    }

    public void incrementSuccessfulRCLBBasedBorrowCount() {
        this.m_successfulRCLBBasedBorrowCount.incrementAndGet();
    }

    public void incrementFailedRCLBBasedBorrowCount() {
        this.m_failedRCLBBasedBorrowCount.incrementAndGet();
    }

    boolean isRCLBMetricsPolicyEnabled() {
        return this.m_rclbMetricsPolicyEnabled.get();
    }

    void setRCLBMetricsPolicyEnabled(boolean bl2) {
        this.m_rclbMetricsPolicyEnabled.set(bl2);
    }

    @DisableTrace
    public int getDatabaseVersion() {
        return this.m_dbVersion.get();
    }

    void setDatabaseVersion(int n2) {
        this.m_dbVersion.compareAndSet(0, n2);
    }

    @Override
    public void registerConnectionAffinityCallback(ConnectionAffinityCallback connectionAffinityCallback) throws UniversalConnectionPoolException {
        this.m_connectionAffinityCallback = connectionAffinityCallback;
    }

    @Override
    public void unregisterConnectionAffinityCallback(ConnectionAffinityCallback connectionAffinityCallback) throws UniversalConnectionPoolException {
        this.m_connectionAffinityCallback = null;
        this.m_affinityMap.clear();
    }

    public synchronized ConnectionAffinityCallback getConnectionAffinityCallback() {
        return this.m_connectionAffinityCallback;
    }

    void setConnectionAffinityValue(String string, boolean bl2) {
        assert (string != null);
        this.m_affinityMap.put(string, bl2);
    }

    public boolean getConnectionAffinityValue(String string) {
        assert (string != null);
        Boolean bl2 = this.m_affinityMap.get(string);
        if (bl2 == null) {
            ClioSupport.ilogFinest(null, null, null, null, "instance/context not in map, lookup returns null");
        }
        return bl2 != null ? bl2 : false;
    }

    public String generateDatabaseInstanceKey(String string, String string2, String string3) {
        return string + "##" + string2 + "##" + string3;
    }

    /*
     * WARNING - void declaration
     */
    void handleLoadBalancingEvent(OracleLoadBalancingEvent oracleLoadBalancingEvent) throws UniversalConnectionPoolException {
        Object object;
        this.rlbMetricsAccumulator.newEvent(oracleLoadBalancingEvent.getServiceName(), oracleLoadBalancingEvent.getEventBody(), this.m_dbInstanceInfoList.getRacMetadata());
        for (OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo : this.m_dbInstanceInfoList.getAllInstances()) {
            if (OracleDatabaseInstanceInfo.RebalancingState.SHRINKING == oracleDatabaseInstanceInfo.getRebalancingState()) continue;
            oracleDatabaseInstanceInfo.setRebalancingState(OracleDatabaseInstanceInfo.RebalancingState.QUIESCENT);
        }
        ClioSupport.ilogFinest(null, null, null, null, this.rlbMetricsAccumulator.toString(1));
        MetricsAccumulator.Frame frame = this.rlbMetricsAccumulator.getPreviousFrame();
        if (null != frame) {
            int n2 = 0;
            for (MetricsAccumulator.InstanceStats object2 : frame.distribution.values()) {
                n2 += object2.getConnsTotal();
            }
            ClioSupport.ilogFinest(null, null, null, null, String.format("serviceName=%s, eventBody=%s", oracleLoadBalancingEvent.getServiceName(), new String(oracleLoadBalancingEvent.getEventBody())));
            for (String string : frame.distribution.keySet()) {
                object = frame.distribution.get(string);
                if (null == object) continue;
                float f2 = (float)((MetricsAccumulator.InstanceStats)object).getConnsTotal() / (float)n2 * 100.0f;
                float f3 = (float)((MetricsAccumulator.InstanceStats)object).getConnsBorrowed() / (float)frame.totalBorrowed * 100.0f;
                float f4 = ((MetricsAccumulator.InstanceStats)object).getAdvisoryPercent();
                ClioSupport.ilogFinest(null, null, null, null, " -- " + string + " #c=" + ((MetricsAccumulator.InstanceStats)object).getConnsTotal() + " (" + f2 + "%)" + " load=" + f3 + "%" + " ONS=" + f4 + '%' + " (new=" + ((MetricsAccumulator.InstanceStats)object).getConnsCreated() + ", closed=" + ((MetricsAccumulator.InstanceStats)object).getConnsClosed() + ')');
            }
        }
        String string = null;
        Iterator<String> iterator = null;
        boolean bl2 = false;
        object = this.getConnectionAffinityCallback();
        if (object != null) {
            boolean bl3 = object.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY;
        } else {
            boolean bl4 = false;
        }
        Set<RACInstance> set = oracleLoadBalancingEvent.getRACInstances();
        for (RACInstance rACInstance : set) {
            void var5_13;
            string = rACInstance.getInstance();
            iterator = rACInstance.getDatabase();
            OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo = new OracleDatabaseInstanceInfo((String)((Object)iterator), string);
            oracleDatabaseInstanceInfo.setAdvisoryPercent(this.olderWLSCompatible ? (float)rACInstance.getPercent() : rACInstance.getFloatPercent());
            oracleDatabaseInstanceInfo.flag = rACInstance.getInstanceStatus().ordinal() + 1;
            oracleDatabaseInstanceInfo.setServiceName(this.m_serviceName.get());
            this.updateDatabaseInstanceInfo(oracleDatabaseInstanceInfo, false, false);
            if (var5_13 != false) continue;
            String string2 = this.generateDatabaseInstanceKey(string, (String)((Object)iterator), this.m_serviceName.get());
            this.setConnectionAffinityValue(string2, ((RACInstanceImpl)rACInstance).getAffinityHint());
        }
        if (null != this.rlbMetricsAccumulator.getPreviousFrame()) {
            this.processDatabaseInstances();
        }
        this.getRACCallback().lbaEventOccurred(oracleLoadBalancingEvent);
    }

    TaskManager getTaskManager() {
        return this.m_taskManager;
    }

    @Override
    public RACInstance getMostDesirableInstanceToGrow() {
        return this.m_dbInstanceInfoList.getMostDesirableInstanceToGrow();
    }

    @Override
    public RACAffinityContext createRACAffinityContext(String string, String string2, String string3, String string4, RACAffinityContext.AffinityType affinityType) {
        OracleConnectionAffinityContext oracleConnectionAffinityContext = new OracleConnectionAffinityContext();
        oracleConnectionAffinityContext.setServiceName(string);
        oracleConnectionAffinityContext.setDatabaseUniqueName(string2);
        oracleConnectionAffinityContext.setInstanceName(string3);
        oracleConnectionAffinityContext.setVersionNumber(string4);
        oracleConnectionAffinityContext.setForInstanceAffinity(affinityType == RACAffinityContext.AffinityType.TRANSACTION_BASED_AFFINITY);
        return oracleConnectionAffinityContext;
    }

    protected void getAutoONSConfigurationFromServer() throws UniversalConnectionPoolException {
        FailoverablePooledConnection failoverablePooledConnection = null;
        try {
            failoverablePooledConnection = this.getRACCallback().openNewConnection(null, null);
            if (failoverablePooledConnection != null) {
                ClioSupport.ilogFinest(null, null, null, null, "got new physical connection: " + failoverablePooledConnection);
                Properties properties = failoverablePooledConnection.getConnectionInfo();
                String string = properties.getProperty("AUTH_ONS_CONFIG");
                if (string != null && !string.equals("")) {
                    ClioSupport.ilogFinest(null, null, null, null, "ONS auto-config: " + string);
                    this.setONSConfiguration(string.trim());
                } else {
                    ClioSupport.ilogFinest(null, null, null, null, "ONS auto-config: null");
                }
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "got null physical connection");
            }
        }
        catch (Throwable throwable) {
            ClioSupport.ilogFinest(null, null, null, null, "Getting ONS auto-config failed: " + this.getStackTraceString(throwable));
            throw UCPErrorHandler.newUniversalConnectionPoolException(313, throwable);
        }
        finally {
            if (failoverablePooledConnection != null) {
                try {
                    failoverablePooledConnection.abort();
                    failoverablePooledConnection.close(false);
                    ClioSupport.ilogFinest(null, null, null, null, "closed physical connection: " + failoverablePooledConnection);
                }
                catch (UniversalConnectionPoolException universalConnectionPoolException) {
                    ClioSupport.ilogFinest(null, null, null, null, "connection cleanup failed after getting ONS auto-config:");
                    universalConnectionPoolException.printStackTrace();
                }
            }
        }
    }

    protected ONS getONS() throws UniversalConnectionPoolException {
        if (this.calledStartONS && this.currentONS == null && !"".equals(this.getONSConfiguration())) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(312);
        }
        return this.currentONS;
    }

    @Override
    public ShardManager createShardManager() throws UniversalConnectionPoolException {
        return new ShardManagerImpl(this.getONS());
    }

    static {
        try {
            $$$methodRef$$$69 = RACManagerImpl.class.getDeclaredConstructor(TaskManager.class, TimerManager.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$68 = RACManagerImpl.class.getDeclaredMethod("createShardManager", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$67 = RACManagerImpl.class.getDeclaredMethod("getONS", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$66 = RACManagerImpl.class.getDeclaredMethod("getAutoONSConfigurationFromServer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$65 = RACManagerImpl.class.getDeclaredMethod("createRACAffinityContext", String.class, String.class, String.class, String.class, RACAffinityContext.AffinityType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$64 = RACManagerImpl.class.getDeclaredMethod("getMostDesirableInstanceToGrow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$63 = RACManagerImpl.class.getDeclaredMethod("getTaskManager", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$62 = RACManagerImpl.class.getDeclaredMethod("handleLoadBalancingEvent", OracleLoadBalancingEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$61 = RACManagerImpl.class.getDeclaredMethod("generateDatabaseInstanceKey", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$60 = RACManagerImpl.class.getDeclaredMethod("getConnectionAffinityValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$59 = RACManagerImpl.class.getDeclaredMethod("setConnectionAffinityValue", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$58 = RACManagerImpl.class.getDeclaredMethod("getConnectionAffinityCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$57 = RACManagerImpl.class.getDeclaredMethod("unregisterConnectionAffinityCallback", ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$56 = RACManagerImpl.class.getDeclaredMethod("registerConnectionAffinityCallback", ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$55 = RACManagerImpl.class.getDeclaredMethod("setDatabaseVersion", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$54 = RACManagerImpl.class.getDeclaredMethod("setRCLBMetricsPolicyEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$53 = RACManagerImpl.class.getDeclaredMethod("isRCLBMetricsPolicyEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$52 = RACManagerImpl.class.getDeclaredMethod("incrementFailedRCLBBasedBorrowCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$51 = RACManagerImpl.class.getDeclaredMethod("incrementSuccessfulRCLBBasedBorrowCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$50 = RACManagerImpl.class.getDeclaredMethod("incrementFailedAffinityBasedBorrowCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$49 = RACManagerImpl.class.getDeclaredMethod("incrementSuccessfulAffinityBasedBorrowCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$48 = RACManagerImpl.class.getDeclaredMethod("cleanupRLBTasks", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$47 = RACManagerImpl.class.getDeclaredMethod("selectConnectionPerRCLB", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$46 = RACManagerImpl.class.getDeclaredMethod("destroyMixTable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$45 = RACManagerImpl.class.getDeclaredMethod("generateMixTable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$44 = RACManagerImpl.class.getDeclaredMethod("selectConnectionPerDataBasedAffinity", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$43 = RACManagerImpl.class.getDeclaredMethod("getConnectionToNamedInstance", String.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$42 = RACManagerImpl.class.getDeclaredMethod("getUpdatedAffinityContextAfterRCLB", FailoverablePooledConnection.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$41 = RACManagerImpl.class.getDeclaredMethod("selectConnectionPerRCLBAndAffinity", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$40 = RACManagerImpl.class.getDeclaredMethod("gravitatePool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$39 = RACManagerImpl.class.getDeclaredMethod("processDatabaseInstances", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$38 = RACManagerImpl.class.getDeclaredMethod("setRuntimeLoadBalancingEventHandlerTask", ONSRuntimeLBEventHandlerTask.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$37 = RACManagerImpl.class.getDeclaredMethod("terminateRuntimeLoadBalancing", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$36 = RACManagerImpl.class.getDeclaredMethod("initRuntimeLoadBalancing", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$35 = RACManagerImpl.class.getDeclaredMethod("setRuntimeLoadBalancingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$34 = RACManagerImpl.class.getDeclaredMethod("isRuntimeLoadBalancingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$33 = RACManagerImpl.class.getDeclaredMethod("decrementNamedInstanceConnCount", OracleDatabaseInstanceInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$32 = RACManagerImpl.class.getDeclaredMethod("connectionClosed", FailoverablePooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$31 = RACManagerImpl.class.getDeclaredMethod("connectionOpened", FailoverablePooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$30 = RACManagerImpl.class.getDeclaredMethod("getRACCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$29 = RACManagerImpl.class.getDeclaredMethod("unregisterRACCallback", RACCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$28 = RACManagerImpl.class.getDeclaredMethod("registerRACCallback", RACCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$27 = RACManagerImpl.class.getDeclaredMethod("processConnectionsForDownEvent", FailoverablePooledConnection[].class, FailoverablePooledConnection[].class, OracleFailoverEvent.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$26 = RACManagerImpl.class.getDeclaredMethod("cleanupConnectionsForDownEvent", FailoverablePooledConnection[].class, FailoverablePooledConnection[].class, OracleFailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$25 = RACManagerImpl.class.getDeclaredMethod("markDownConnectionsForDownEvent", FailoverablePooledConnection[].class, FailoverablePooledConnection[].class, OracleFailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$24 = RACManagerImpl.class.getDeclaredMethod("updateFCFProcessingInfoProcessedOnly", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$23 = RACManagerImpl.class.getDeclaredMethod("updateFCFProcessingInfo", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$22 = RACManagerImpl.class.getDeclaredMethod("setONSConfiguration", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$21 = RACManagerImpl.class.getDeclaredMethod("updateDatabaseInstanceInfo", Object.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$20 = RACManagerImpl.class.getDeclaredMethod("setFailoverInfo", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$19 = RACManagerImpl.class.getDeclaredMethod("setFailoverEventHandlerTask", ONSDatabaseEventHandlerTask.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$18 = RACManagerImpl.class.getDeclaredMethod("resetRACStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$17 = RACManagerImpl.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$16 = RACManagerImpl.class.getDeclaredMethod("getFailoverEventHandlerTask", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$15 = RACManagerImpl.class.getDeclaredMethod("start", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$14 = RACManagerImpl.class.getDeclaredMethod("startONS", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$13 = RACManagerImpl.class.getDeclaredMethod("resetFCFInternalMetrics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$12 = RACManagerImpl.class.getDeclaredMethod("failoverHostEventMatch", FailoverablePooledConnection.class, String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$11 = RACManagerImpl.class.getDeclaredMethod("failoverServiceEventMatch", FailoverablePooledConnection.class, String.class, String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$10 = RACManagerImpl.class.getDeclaredMethod("tearDownConnections", FailoverablePooledConnection[].class, FailoverablePooledConnection[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$9 = RACManagerImpl.class.getDeclaredMethod("getUpEventConnectionsToCreateCount", FailoverablePooledConnection[].class, FailoverablePooledConnection[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$8 = RACManagerImpl.class.getDeclaredMethod("processUpEvent2ndPhase", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$7 = RACManagerImpl.class.getDeclaredMethod("processServiceUpEvent", FailoverablePooledConnection[].class, FailoverablePooledConnection[].class, Integer.TYPE, Integer.TYPE, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$6 = RACManagerImpl.class.getDeclaredMethod("processConnectionsForHostDown", FailoverablePooledConnection[].class, Boolean.TYPE, String.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$5 = RACManagerImpl.class.getDeclaredMethod("processFailoverAction", FailoverablePooledConnection.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$4 = RACManagerImpl.class.getDeclaredMethod("processConnectionsForServiceDown", FailoverablePooledConnection[].class, Boolean.TYPE, String.class, String.class, Boolean.TYPE, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$3 = RACManagerImpl.class.getDeclaredMethod("processUpEvent", FailoverablePooledConnection[].class, FailoverablePooledConnection[].class, Integer.TYPE, Integer.TYPE, OracleFailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = RACManagerImpl.class.getDeclaredMethod("handleFailoverEvent", FailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = RACManagerImpl.class.getDeclaredMethod("validateHostDownEvent", OracleFailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = RACManagerImpl.class.getDeclaredMethod("validateServiceEvent", OracleFailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }

    public static interface RACCallbackExtended
    extends RACCallback {
        public void tearDownConnectionsForInstance(OracleDatabaseInstanceInfo var1, int var2);
    }
}

