/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.replay.OracleDataSourceImpl;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleDataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class ReplayDataSourceConnectionFactoryAdapter
extends OracleDataSourceConnectionFactoryAdapter {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    public ReplayDataSourceConnectionFactoryAdapter(DataSource dataSource) throws UniversalConnectionPoolException {
        super(dataSource);
    }

    @Override
    public void initializeUrlFromConnectionFactory() {
        Class<?> clazz = this.m_dataSource.getClass();
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName("oracle.jdbc.replay.OracleDataSourceImpl", true, clazz.getClassLoader());
            Method method = clazz2.getMethod("getURL", new Class[0]);
            this.m_url = (String)method.invoke((Object)this.m_dataSource, new Object[0]);
            ClioSupport.ilogFinest(null, null, null, null, "initializeUrlFromConnectionFactory() succeeded");
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
    }

    @Override
    public void setUrl(String string) {
        Class<?> clazz = this.m_dataSource.getClass();
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName("oracle.jdbc.replay.OracleDataSourceImpl", true, clazz.getClassLoader());
            Method method = clazz2.getMethod("setURL", String.class);
            method.invoke((Object)this.m_dataSource, string);
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
    }

    @Override
    public Object createConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        OracleDataSourceImpl oracleDataSourceImpl = null;
        Connection connection = null;
        try {
            if (!(this.m_dataSource instanceof OracleDataSourceImpl)) {
                ClioSupport.ilogFinest(null, null, null, null, "about to create connection without specifying instance");
                connection = (Connection)super.createConnection(connectionRetrievalInfo);
            } else {
                String string;
                oracleDataSourceImpl = (OracleDataSourceImpl)this.m_dataSource;
                JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
                if (connectionRetrievalInfo instanceof OracleJDBCConnectionRetrievalInfo) {
                    string = ((OracleJDBCConnectionRetrievalInfo)connectionRetrievalInfo).getInstanceName();
                    ClioSupport.ilogFinest(null, null, null, null, "about to create connection to the instance " + string);
                } else {
                    string = null;
                }
                OracleConnectionBuilderImpl oracleConnectionBuilderImpl = oracleDataSourceImpl.createConnectionBuilder();
                connection = oracleConnectionBuilderImpl.user(jDBCConnectionRetrievalInfo.getUser()).password(jDBCConnectionRetrievalInfo.getPassword().get()).instanceName(string).serviceName(jDBCConnectionRetrievalInfo.getServiceName()).shardingKey(jDBCConnectionRetrievalInfo.getShardingKey()).superShardingKey(jDBCConnectionRetrievalInfo.getSuperShardingKey()).build();
                if (connection instanceof OracleConnection) {
                    Properties properties;
                    String string2 = ((OracleConnection)connection).getServerSessionInfo().getProperty("INSTANCE_NAME");
                    assert (null != string2);
                    assert (string == null || Util.equalsNormalized(string2, string)) : "internal error: got connection from the wrong instance";
                    if (string != null && !"".equals(string) && !Util.equalsNormalized(string2, string)) {
                        ClioSupport.ilogFinest(null, null, null, null, "wrong conn opened, desired:" + string + ", actual:" + string2);
                    }
                    if ((properties = jDBCConnectionRetrievalInfo.getProxyProperties()) != null) {
                        int n2 = jDBCConnectionRetrievalInfo.getProxyType();
                        ClioSupport.ilogFinest(null, null, null, null, " Opening proxy session with Properties = " + properties);
                        ((OracleConnection)connection).openProxySession(n2, properties);
                    }
                } else {
                    ClioSupport.ilogFinest(null, null, null, null, "not an oracle connection");
                }
            }
        }
        catch (SQLException sQLException) {
            ClioSupport.ilogThrowing(null, null, null, null, sQLException);
            UCPErrorHandler.throwUniversalConnectionPoolException(257, sQLException);
        }
        return connection;
    }

    static {
        try {
            $$$methodRef$$$3 = ReplayDataSourceConnectionFactoryAdapter.class.getDeclaredConstructor(DataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = ReplayDataSourceConnectionFactoryAdapter.class.getDeclaredMethod("createConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = ReplayDataSourceConnectionFactoryAdapter.class.getDeclaredMethod("setUrl", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = ReplayDataSourceConnectionFactoryAdapter.class.getDeclaredMethod("initializeUrlFromConnectionFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

