/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Failoverable;
import oracle.ucp.jdbc.oracle.FailoverActionResult;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.RACManager;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TimerManager;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
class ReplayableRACManagerImpl
extends RACManagerImpl
implements Failoverable,
RACManager {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;

    ReplayableRACManagerImpl(TaskManager taskManager, TimerManager timerManager, boolean bl2, boolean bl3) throws UniversalConnectionPoolException {
        super(taskManager, timerManager, bl2, bl3);
    }

    @Override
    FailoverActionResult processFailoverAction(FailoverablePooledConnection failoverablePooledConnection, boolean bl2, boolean bl3, int n2) {
        FailoverActionResult failoverActionResult = FailoverActionResult.NOOP;
        switch (n2) {
            case 0: {
                try {
                    if (!bl2 && bl3) {
                        failoverablePooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
                        failoverActionResult = FailoverActionResult.MARKED_CLOSE_ON_RETURN;
                        break;
                    }
                    if (!bl2) {
                        failoverablePooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_RECONNECTING);
                        failoverActionResult = FailoverActionResult.MARKED_BAD;
                        break;
                    }
                    failoverablePooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                    failoverActionResult = FailoverActionResult.MARKED_BAD;
                }
                catch (UniversalConnectionPoolException universalConnectionPoolException) {
                    ClioSupport.ilogFinest(null, null, null, null, this.getStackTraceString(universalConnectionPoolException));
                    this.m_errorInfo.append(", ").append(universalConnectionPoolException.getStackTrace()[0].toString());
                    failoverActionResult = FailoverActionResult.FAILED;
                }
                break;
            }
            case 1: {
                if (failoverablePooledConnection.getStatus() != UniversalPooledConnectionStatus.STATUS_BAD && failoverablePooledConnection.getStatus() != UniversalPooledConnectionStatus.STATUS_RECONNECTING) {
                    ClioSupport.ilogFinest(null, null, null, null, "AC replugging already happened - no FCF cleanup");
                    break;
                }
                try {
                    failoverablePooledConnection.abort();
                }
                catch (Exception exception) {
                    ClioSupport.ilogFinest(null, null, null, null, this.getStackTraceString(exception));
                    this.m_errorInfo.append(", ").append(exception.getStackTrace()[0].toString());
                    failoverActionResult = FailoverActionResult.FAILED;
                }
                try {
                    failoverablePooledConnection.close(!bl2);
                    failoverActionResult = FailoverActionResult.ABORTED_AND_CLOSED;
                }
                catch (UniversalConnectionPoolException universalConnectionPoolException) {
                    ClioSupport.ilogFinest(null, null, null, null, this.getStackTraceString(universalConnectionPoolException));
                    this.m_errorInfo.append(", ").append(universalConnectionPoolException.getStackTrace()[0].toString());
                    failoverActionResult = FailoverActionResult.FAILED;
                }
                break;
            }
        }
        return failoverActionResult;
    }

    static {
        try {
            $$$methodRef$$$1 = ReplayableRACManagerImpl.class.getDeclaredConstructor(TaskManager.class, TimerManager.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = ReplayableRACManagerImpl.class.getDeclaredMethod("processFailoverAction", FailoverablePooledConnection.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

