/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle.rlb;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Executable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.OracleLoadBalancingEvent;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.RACInstanceImpl;
import oracle.ucp.logging.ClioSupport;

@DefaultLogger(value="oracle.ucp.jdbc.oracle.rlb")
@Supports(value={Feature.LOAD_BALANCING})
public final class ONSRuntimeLoadBalancingEvent
implements OracleLoadBalancingEvent {
    private static final String ONS_RCLB_EVENT_DELIMITER = "{} =";
    public static final int RLB_INSTANCE_GOOD = 1;
    public static final int RLB_INSTANCE_UNKNOWN = 2;
    public static final int RLB_INSTANCE_VIOLATING = 3;
    public static final int RLB_INSTANCE_NO_DATA = 4;
    public static final int RLB_INSTANCE_BLOCKED = 5;
    public static final int RLB_NUMBER_OF_HITS_PER_INSTANCE = 1000;
    private Set<RACInstance> m_racInstances = Collections.synchronizedSet(new HashSet());
    private byte[] m_eventBody = null;
    private final String m_serviceName;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    public ONSRuntimeLoadBalancingEvent(String string, byte[] byArray) throws UniversalConnectionPoolException {
        this.m_serviceName = string;
        this.m_eventBody = byArray;
        StringTokenizer stringTokenizer = null;
        String string2 = null;
        String string3 = null;
        int n2 = 0;
        float f2 = 0.0f;
        OracleLoadBalancingEvent.InstanceStatus instanceStatus = OracleLoadBalancingEvent.InstanceStatus.UNKNOWN;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            stringTokenizer = new StringTokenizer(new String(byArray, "UTF-8"), ONS_RCLB_EVENT_DELIMITER, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ClioSupport.ilogThrowing(null, null, null, null, unsupportedEncodingException);
        }
        String string4 = null;
        String string5 = null;
        String string6 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string5 = null;
            string4 = stringTokenizer.nextToken();
            if (string4.equals("=") && stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
            } else {
                if (string4.equals("}")) {
                    if (!bl2) continue;
                    RACInstanceImpl rACInstanceImpl = new RACInstanceImpl(this.m_serviceName, string2, "", string3);
                    if (f2 > 0.0f) {
                        rACInstanceImpl.setFloatPercent(f2);
                    } else {
                        rACInstanceImpl.setPercent(n2);
                    }
                    rACInstanceImpl.setStatus(instanceStatus);
                    rACInstanceImpl.setAffinityHint(bl3);
                    this.m_racInstances.add(rACInstanceImpl);
                    bl2 = false;
                    bl3 = false;
                    continue;
                }
                if (string4.equals("{") || string4.equals(" ")) continue;
                string6 = string4;
                bl2 = true;
            }
            if (string6.equalsIgnoreCase("version") && string5 != null) {
                if (string5.startsWith("1.")) continue;
                ClioSupport.ilogFine(null, null, null, null, "Invalid Event version " + string5);
                break;
            }
            if (string6.equalsIgnoreCase("database") && string5 != null) {
                string3 = string5.trim().toLowerCase();
                continue;
            }
            if (string6.equalsIgnoreCase("instance") && string5 != null) {
                string2 = string5.trim().toLowerCase();
                continue;
            }
            if (string6.equalsIgnoreCase("percent") && string5 != null) {
                try {
                    n2 = Integer.parseInt(string5);
                    if (n2 != 0) continue;
                    n2 = 1;
                }
                catch (NumberFormatException numberFormatException) {
                    ClioSupport.ilogThrowing(null, null, null, null, numberFormatException);
                }
                continue;
            }
            if (string6.equalsIgnoreCase("percentf") && string5 != null) {
                try {
                    f2 = Float.parseFloat(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    ClioSupport.ilogThrowing(null, null, null, null, numberFormatException);
                }
                continue;
            }
            if (string6.equalsIgnoreCase("flag") && string5 != null) {
                if (string5.equalsIgnoreCase("good")) {
                    instanceStatus = OracleLoadBalancingEvent.InstanceStatus.GOOD;
                    continue;
                }
                if (string5.equalsIgnoreCase("violating")) {
                    instanceStatus = OracleLoadBalancingEvent.InstanceStatus.VIOLATING;
                    continue;
                }
                if (string5.equalsIgnoreCase("NO_DATA")) {
                    instanceStatus = OracleLoadBalancingEvent.InstanceStatus.NO_DATA;
                    continue;
                }
                if (string5.equalsIgnoreCase("UNKNOWN")) {
                    instanceStatus = OracleLoadBalancingEvent.InstanceStatus.UNKNOWN;
                    continue;
                }
                if (!string5.equalsIgnoreCase("BLOCKED")) continue;
                instanceStatus = OracleLoadBalancingEvent.InstanceStatus.BLOCKED;
                continue;
            }
            if (!string6.equalsIgnoreCase("aff") || string5 == null) continue;
            bl3 = string5.equalsIgnoreCase("true");
        }
    }

    @Override
    public Set<RACInstance> getRACInstances() {
        return this.m_racInstances;
    }

    @Override
    public String getServiceName() {
        return this.m_serviceName;
    }

    @Override
    public byte[] getEventBody() {
        return this.m_eventBody;
    }

    static {
        try {
            $$$methodRef$$$3 = ONSRuntimeLoadBalancingEvent.class.getDeclaredConstructor(String.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$2 = ONSRuntimeLoadBalancingEvent.class.getDeclaredMethod("getEventBody", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$1 = ONSRuntimeLoadBalancingEvent.class.getDeclaredMethod("getServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$0 = ONSRuntimeLoadBalancingEvent.class.getDeclaredMethod("getRACInstances", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
    }
}

