/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle.rlb;

import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.ucp.jdbc.oracle.rlb")
@Supports(value={Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
public class OracleDatabaseInstanceInfo {
    static final int STATUS_UP = 1;
    static final int STATUS_DOWN = 2;
    private final String databaseUniqueName;
    private final String instanceName;
    private final String hostName;
    private String serviceName = null;
    private float percent = 0.0f;
    public int flag = 2;
    private int numberOfConnectionsCount = 0;
    int status = 1;
    private int numToTearDown = -1;
    private String namedInstanceUrl = null;
    private int numNamedInstanceConns = 0;
    private int id = -1;
    private int connsToTearDown = 0;
    private RebalancingState rebalancingState = RebalancingState.QUIESCENT;
    String m_equalKey;
    final String m_hashKey;
    private final int m_hashCode;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;

    public synchronized RebalancingState getRebalancingState() {
        return this.rebalancingState;
    }

    public synchronized void setRebalancingState(RebalancingState rebalancingState) {
        this.rebalancingState = rebalancingState;
    }

    public OracleDatabaseInstanceInfo(String string, String string2) {
        this(string, string2, null);
    }

    public OracleDatabaseInstanceInfo(String string, String string2, String string3) {
        this.databaseUniqueName = string;
        this.instanceName = string2;
        this.hostName = string3;
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(string2 == null ? "" : string2).append("##").append(string == null ? "" : string);
        this.m_hashKey = stringBuffer.toString();
        this.m_hashCode = this.m_hashKey.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof OracleDatabaseInstanceInfo)) {
            return false;
        }
        OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo = (OracleDatabaseInstanceInfo)object;
        String string = this.m_hashKey == null ? "" : this.m_hashKey;
        String string2 = oracleDatabaseInstanceInfo.m_hashKey == null ? "" : oracleDatabaseInstanceInfo.m_hashKey;
        return string.equals(string2);
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    @DisableTrace
    public String toString() {
        return "Database unique name: " + this.databaseUniqueName + ", Instance name: " + this.instanceName + ", Service name: " + this.serviceName + ", Host name: " + this.hostName + ", Instance id: " + this.id + ", percent: " + this.percent + ", Flag: " + this.flag + ", Connection count: " + this.getNumberOfConnectionsCount() + ", Status: " + (this.status == 1 ? "UP" : "DOWN");
    }

    @DisableTrace
    public String getDatabaseName() {
        return this.databaseUniqueName;
    }

    @DisableTrace
    public String getInstanceName() {
        return this.instanceName;
    }

    @DisableTrace
    public String getHostName() {
        return this.hostName;
    }

    @DisableTrace
    public synchronized int getNumberOfConnectionsCount() {
        return this.numberOfConnectionsCount;
    }

    synchronized void incrementNumberOfConnectionsCount() {
        ++this.numberOfConnectionsCount;
    }

    synchronized void decrementNumberOfConnectionsCount() {
        assert (this.numberOfConnectionsCount >= 0) : "internal error: numberOfConnectionsCount cannot be negative";
        --this.numberOfConnectionsCount;
    }

    synchronized void setNumberOfConnectionsCount(int n2) {
        this.numberOfConnectionsCount = n2;
    }

    synchronized void setConnsToTearDown(int n2) {
        this.connsToTearDown = n2;
    }

    @DisableTrace
    public synchronized int getConnsToTearDown() {
        return this.connsToTearDown;
    }

    @DisableTrace
    public synchronized String getServiceName() {
        return this.serviceName;
    }

    public synchronized void setServiceName(String string) {
        this.serviceName = string;
    }

    @DisableTrace
    public int getId() {
        return this.id;
    }

    public void setId(int n2) {
        this.id = n2;
    }

    @DisableTrace
    public int getNumNamedInstanceConns() {
        return this.numNamedInstanceConns;
    }

    private void setNumNamedInstanceConns(int n2) {
        this.numNamedInstanceConns = n2;
    }

    public void decrementNumNamedInstanceConns() {
        --this.numNamedInstanceConns;
    }

    public void incrementNumNamedInstanceConns() {
        ++this.numNamedInstanceConns;
    }

    @DisableTrace
    public int getNumToTearDown() {
        return this.numToTearDown;
    }

    public void setNumToTearDown(int n2) {
        this.numToTearDown = n2;
    }

    public void decrementNumToTearDown() {
        --this.numToTearDown;
    }

    @DisableTrace
    public synchronized float getAdvisoryPercent() {
        return this.percent;
    }

    public synchronized void setAdvisoryPercent(float f2) {
        this.percent = f2;
    }

    @DisableTrace
    public synchronized String getNamedInstanceUrl() {
        return this.namedInstanceUrl;
    }

    public synchronized void setNamedInstanceUrl(String string) {
        this.namedInstanceUrl = string;
    }

    static {
        try {
            $$$methodRef$$$18 = OracleDatabaseInstanceInfo.class.getDeclaredConstructor(String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$17 = OracleDatabaseInstanceInfo.class.getDeclaredConstructor(String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$16 = OracleDatabaseInstanceInfo.class.getDeclaredMethod("setNamedInstanceUrl", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$15 = OracleDatabaseInstanceInfo.class.getDeclaredMethod("setAdvisoryPercent", Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$14 = OracleDatabaseInstanceInfo.class.getDeclaredMethod("decrementNumToTearDown", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$13 = OracleDatabaseInstanceInfo.class.getDeclaredMethod("setNumToTearDown", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$12 = OracleDatabaseInstanceInfo.class.getDeclaredMethod("incrementNumNamedInstanceConns", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$11 = OracleDatabaseInstanceInfo.class.getDeclaredMethod("decrementNumNamedInstanceConns", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$10 = OracleDatabaseInstanceInfo.class.getDeclaredMethod("setNumNamedInstanceConns", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$9 = OracleDatabaseInstanceInfo.class.getDeclaredMethod("setId", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$8 = OracleDatabaseInstanceInfo.class.getDeclaredMethod("setServiceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$7 = OracleDatabaseInstanceInfo.class.getDeclaredMethod("setConnsToTearDown", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$6 = OracleDatabaseInstanceInfo.class.getDeclaredMethod("setNumberOfConnectionsCount", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$5 = OracleDatabaseInstanceInfo.class.getDeclaredMethod("decrementNumberOfConnectionsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$4 = OracleDatabaseInstanceInfo.class.getDeclaredMethod("incrementNumberOfConnectionsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$3 = OracleDatabaseInstanceInfo.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$2 = OracleDatabaseInstanceInfo.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$1 = OracleDatabaseInstanceInfo.class.getDeclaredMethod("setRebalancingState", RebalancingState.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$0 = OracleDatabaseInstanceInfo.class.getDeclaredMethod("getRebalancingState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
    }

    public static final class RebalancingState
    extends Enum<RebalancingState> {
        public static final /* enum */ RebalancingState QUIESCENT;
        public static final /* enum */ RebalancingState SHRINKING;
        public static final /* enum */ RebalancingState SHRUNK;
        public static final /* enum */ RebalancingState GROWING;
        private static final /* synthetic */ RebalancingState[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static RebalancingState[] values() {
            return (RebalancingState[])$VALUES.clone();
        }

        public static RebalancingState valueOf(String string) {
            return Enum.valueOf(RebalancingState.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = RebalancingState.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = RebalancingState.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = RebalancingState.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            QUIESCENT = new RebalancingState();
            SHRINKING = new RebalancingState();
            SHRUNK = new RebalancingState();
            GROWING = new RebalancingState();
            $VALUES = new RebalancingState[]{QUIESCENT, SHRINKING, SHRUNK, GROWING};
        }
    }
}

