/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle.rlb;

import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.RACCallbackGuard;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.RACInstanceImpl;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.jdbc.oracle.rlb.ConnectionsDispatcher;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;
import oracle.ucp.jdbc.oracle.rlb.Policy;
import oracle.ucp.jdbc.oracle.rlb.PolicyImpl;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.jdbc.oracle.rlb")
@Supports(value={Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
public class OracleDatabaseInstanceInfoList {
    private final Instances instances = new Instances();
    private Policy rlbPolicy;
    private final RACManagerImpl m_racMngr;
    private static final String CONNECT_DATA_KEYWORD = "CONNECT_DATA";
    private OracleDatabaseInstanceInfo lastUsedInstanceToGrow;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;

    public Collection<OracleDatabaseInstanceInfo> getAllInstances() {
        return this.instances.getAllInstances();
    }

    public OracleDatabaseInstanceInfoList(RACManagerImpl rACManagerImpl) {
        String string = null;
        try {
            string = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public Object run() {
                    return System.getProperty("oracle.ucp.jdbc.oracle.rlb.policy");
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(OracleDatabaseInstanceInfoList.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
            this.rlbPolicy = null == string || "".equals(string) ? new PolicyImpl() : (Policy)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            ClioSupport.ilogWarning(null, null, null, null, "unable to use policy class " + string + ", using default RLB policy instead");
            this.rlbPolicy = new PolicyImpl();
        }
        this.lastUsedInstanceToGrow = null;
        this.m_racMngr = rACManagerImpl;
        this.rlbPolicy.plugRLBInfo(this.m_racMngr.rlbMetricsAccumulator);
        this.rlbPolicy.plugConnectionsDispatcher(new ConnectionsDispatcher(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public FailoverablePooledConnection borrowConnection(OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo, ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
                return OracleDatabaseInstanceInfoList.this.m_racMngr.getRACCallback().getAvailableConnectionToInstance(connectionRetrievalInfo, new RACInstanceImpl(oracleDatabaseInstanceInfo));
            }

            static {
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredConstructor(OracleDatabaseInstanceInfoList.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("borrowConnection", OracleDatabaseInstanceInfo.class, ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    public synchronized void updateDatabaseInstanceInfo(OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo, boolean bl2, boolean bl3) {
        int n2;
        Integer n3 = this.instances.getId(oracleDatabaseInstanceInfo);
        int n4 = n2 = n3 != null ? n3 : -1;
        if (bl2) {
            if (n2 != -1) {
                if (bl3 && n2 != oracleDatabaseInstanceInfo.getId()) {
                    ClioSupport.ilogFinest(null, null, null, null, "name->id mapping out-of-sync, instance=" + oracleDatabaseInstanceInfo.getInstanceName() + ", id=" + oracleDatabaseInstanceInfo.getId() + ", id-in-table=" + n2);
                    return;
                }
                OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo2 = this.instances.getInstance(n2);
                if (bl3) {
                    oracleDatabaseInstanceInfo2.incrementNumberOfConnectionsCount();
                    if (oracleDatabaseInstanceInfo2.status == 2) {
                        oracleDatabaseInstanceInfo2.status = 1;
                    }
                } else {
                    oracleDatabaseInstanceInfo2.decrementNumberOfConnectionsCount();
                }
            } else {
                oracleDatabaseInstanceInfo.incrementNumberOfConnectionsCount();
                this.setNamedInstanceUrl(oracleDatabaseInstanceInfo, oracleDatabaseInstanceInfo.getInstanceName());
                oracleDatabaseInstanceInfo.status = 1;
                if (oracleDatabaseInstanceInfo.getId() >= 0) {
                    this.instances.add(oracleDatabaseInstanceInfo, oracleDatabaseInstanceInfo.getId());
                }
            }
        } else if (n2 >= 0) {
            OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo3 = this.instances.getInstance(n2);
            oracleDatabaseInstanceInfo3.setAdvisoryPercent(oracleDatabaseInstanceInfo.getAdvisoryPercent());
            oracleDatabaseInstanceInfo3.flag = oracleDatabaseInstanceInfo.flag;
        }
    }

    private void setNamedInstanceUrl(OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo, String string) {
        StringBuffer stringBuffer = new StringBuffer(this.m_racMngr.getRACCallback().getUrl());
        int n2 = stringBuffer.indexOf(CONNECT_DATA_KEYWORD);
        if (n2 == -1) {
            oracleDatabaseInstanceInfo.setNamedInstanceUrl(null);
            ClioSupport.ilogFinest(null, null, null, null, "connect data keyword not found");
        } else {
            int n3 = stringBuffer.indexOf("=", n2 + CONNECT_DATA_KEYWORD.length());
            if (n3 == -1) {
                oracleDatabaseInstanceInfo.setNamedInstanceUrl(null);
                ClioSupport.ilogFinest(null, null, null, null, "equal sign was not found");
            } else {
                stringBuffer.insert(n3 + 1, "(INSTANCE_NAME=" + string + ")");
                oracleDatabaseInstanceInfo.setNamedInstanceUrl(stringBuffer.toString());
            }
        }
        ClioSupport.ilogFinest(null, null, null, null, "instance=" + oracleDatabaseInstanceInfo.getInstanceName() + ", namedInstanceUrl=" + stringBuffer.toString());
    }

    public boolean isNamedInstanceConnectingAllowed(String string, String string2, boolean bl2) {
        int n2;
        RACCallbackGuard rACCallbackGuard = this.m_racMngr.getRACCallback();
        OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo = new OracleDatabaseInstanceInfo(string2, string);
        Integer n3 = this.instances.getId(oracleDatabaseInstanceInfo);
        int n4 = n2 = n3 != null ? n3 : -1;
        if (n2 < 0) {
            ClioSupport.ilogFinest(null, null, null, null, "instId < 0");
            return false;
        }
        OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo2 = this.instances.getInstance(n2);
        if (oracleDatabaseInstanceInfo2 == null) {
            ClioSupport.ilogFinest(null, null, null, null, "dbInstance is null");
            return false;
        }
        if (oracleDatabaseInstanceInfo2.status == 1 && oracleDatabaseInstanceInfo2.flag <= 3) {
            int n5;
            ClioSupport.ilogFinest(null, null, null, null, "instance is alive");
            int n6 = this.m_racMngr.getDatabaseVersion();
            if (n6 >= 11100 || !bl2) {
                ClioSupport.ilogFinest(null, null, null, null, "recent RAC version or instance affinity not enabled");
                float f2 = 0 == this.m_racMngr.rlbMetricsAccumulator.getReel().size() ? 100.0f / (float)this.getUpInstancesCount() : oracleDatabaseInstanceInfo2.getAdvisoryPercent();
                ClioSupport.ilogFinest(null, null, null, null, String.format("advisoryPercent=%f, roomToGrowPool=%d", Float.valueOf(f2), rACCallbackGuard.getRoomToGrowPool()));
                n5 = Math.round(f2 * (float)rACCallbackGuard.getMaxPoolSize() / 100.0f);
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "older RAC version and instance affinity enabled");
                n5 = rACCallbackGuard.getRoomToGrowPool() + oracleDatabaseInstanceInfo2.getNumNamedInstanceConns();
            }
            ClioSupport.ilogFinest(null, null, null, null, String.format("dbVersion=%d, threshold=%d, connNum=%d", n6, n5, oracleDatabaseInstanceInfo2.getNumberOfConnectionsCount()));
            return n5 > oracleDatabaseInstanceInfo2.getNumberOfConnectionsCount();
        }
        ClioSupport.ilogFinest(null, null, null, null, "instance is not alive");
        return false;
    }

    public int size() {
        return this.instances.size();
    }

    public RACInstance getMostDesirableInstanceToGrow() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("most desirable instance to grow: ");
        int n2 = Integer.MIN_VALUE;
        OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo = this.lastUsedInstanceToGrow;
        for (Map.Entry<OracleDatabaseInstanceInfo, Integer> entry : this.rlbPolicy.getCurrentRebalancePolicy().entrySet()) {
            OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo2 = entry.getKey();
            int n3 = entry.getValue();
            stringBuilder.append("(").append(oracleDatabaseInstanceInfo2.getInstanceName()).append(":").append(n3).append(")");
            OracleDatabaseInstanceInfo.RebalancingState rebalancingState = oracleDatabaseInstanceInfo2.getRebalancingState();
            if (OracleDatabaseInstanceInfo.RebalancingState.SHRINKING == rebalancingState || OracleDatabaseInstanceInfo.RebalancingState.SHRUNK == rebalancingState || n3 <= 0 || n3 <= n2) continue;
            this.lastUsedInstanceToGrow = oracleDatabaseInstanceInfo = oracleDatabaseInstanceInfo2;
            n2 = n3;
        }
        if (null != oracleDatabaseInstanceInfo) {
            stringBuilder.append(" grow on ").append(oracleDatabaseInstanceInfo.getInstanceName());
            oracleDatabaseInstanceInfo.setRebalancingState(OracleDatabaseInstanceInfo.RebalancingState.GROWING);
        } else {
            stringBuilder.append("no instance to grow");
        }
        ClioSupport.ilogFinest(null, null, null, null, stringBuilder.toString());
        return null == oracleDatabaseInstanceInfo ? null : new RACInstanceImpl(oracleDatabaseInstanceInfo);
    }

    public FailoverablePooledConnection selectConnectionPerRLBMetrics(ConnectionRetrievalInfo connectionRetrievalInfo, RACManagerImpl rACManagerImpl) throws UniversalConnectionPoolException {
        FailoverablePooledConnection failoverablePooledConnection = this.rlbPolicy.borrowConnection(connectionRetrievalInfo);
        if (failoverablePooledConnection != null) {
            rACManagerImpl.incrementSuccessfulRCLBBasedBorrowCount();
        } else {
            rACManagerImpl.incrementFailedRCLBBasedBorrowCount();
        }
        return failoverablePooledConnection;
    }

    public synchronized void scheduleInstancesForGravitation(BlockingQueue<OracleDatabaseInstanceInfo> blockingQueue) {
        for (Map.Entry<OracleDatabaseInstanceInfo, Integer> entry : this.rlbPolicy.getCurrentRebalancePolicy().entrySet()) {
            OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo = entry.getKey();
            int n2 = entry.getValue();
            OracleDatabaseInstanceInfo.RebalancingState rebalancingState = oracleDatabaseInstanceInfo.getRebalancingState();
            if (OracleDatabaseInstanceInfo.RebalancingState.GROWING == rebalancingState || n2 >= 0) continue;
            ClioSupport.ilogFinest(null, null, null, null, "gravitate " + oracleDatabaseInstanceInfo.getInstanceName() + ", " + n2 + " connections");
            oracleDatabaseInstanceInfo.setConnsToTearDown(Math.abs(n2));
            oracleDatabaseInstanceInfo.setRebalancingState(OracleDatabaseInstanceInfo.RebalancingState.SHRINKING);
            blockingQueue.add(oracleDatabaseInstanceInfo);
        }
    }

    public boolean useGoodGroup() {
        float f2 = 0.0f;
        for (OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo : this.instances.getAllInstances()) {
            if (1 != oracleDatabaseInstanceInfo.status || 4 == oracleDatabaseInstanceInfo.flag || 5 == oracleDatabaseInstanceInfo.flag) continue;
            f2 += oracleDatabaseInstanceInfo.getAdvisoryPercent();
        }
        return f2 > 0.0f;
    }

    private FailoverablePooledConnection getConnectionToNamedInstance(OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo, boolean bl2) {
        FailoverablePooledConnection failoverablePooledConnection = null;
        String string = oracleDatabaseInstanceInfo.getNamedInstanceUrl();
        try {
            RACInstanceImpl rACInstanceImpl = new RACInstanceImpl(oracleDatabaseInstanceInfo);
            failoverablePooledConnection = this.m_racMngr.getRACCallback().openNewConnection(string, rACInstanceImpl);
        }
        catch (Exception exception) {
            failoverablePooledConnection = null;
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
        if (failoverablePooledConnection != null) {
            failoverablePooledConnection.setAsNamedInstanceConnection();
            if (!bl2) {
                oracleDatabaseInstanceInfo.incrementNumNamedInstanceConns();
            }
        }
        return failoverablePooledConnection;
    }

    public void markUpInstanceForUpEvent(String string, String string2, String string3, String string4) {
        int n2;
        OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo = new OracleDatabaseInstanceInfo(string4, string2, string3);
        oracleDatabaseInstanceInfo.setServiceName(string);
        Integer n3 = this.instances.getId(oracleDatabaseInstanceInfo);
        int n4 = n2 = n3 != null ? n3 : -1;
        if (n2 != -1) {
            oracleDatabaseInstanceInfo = this.instances.getInstance(n2);
            oracleDatabaseInstanceInfo.status = 1;
        } else {
            this.setNamedInstanceUrl(oracleDatabaseInstanceInfo, oracleDatabaseInstanceInfo.getInstanceName());
            oracleDatabaseInstanceInfo.status = 1;
            FailoverablePooledConnection failoverablePooledConnection = this.getConnectionToNamedInstance(oracleDatabaseInstanceInfo, true);
            if (null != failoverablePooledConnection) {
                int n5 = failoverablePooledConnection.getInstanceNumber();
                if (n5 >= 0) {
                    this.instances.add(oracleDatabaseInstanceInfo, n5);
                }
                try {
                    failoverablePooledConnection.close(false);
                }
                catch (UniversalConnectionPoolException universalConnectionPoolException) {
                    ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                }
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "namedInstanceConn is null");
            }
        }
    }

    public void markDownInstanceForServiceDownEvent(String string, String string2) {
        for (OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo : this.instances.getAllInstances()) {
            if (string == null) {
                oracleDatabaseInstanceInfo.status = 2;
                continue;
            }
            if (!Util.sameOrEqual(string2, oracleDatabaseInstanceInfo.getDatabaseName()) || !Util.sameOrEqual(string, oracleDatabaseInstanceInfo.getInstanceName())) continue;
            oracleDatabaseInstanceInfo.status = 2;
        }
    }

    public void markDownInstanceForHostDownEvent(String string) {
        for (OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo : this.instances.getAllInstances()) {
            if (!Util.sameOrEqual(string, oracleDatabaseInstanceInfo.getHostName())) continue;
            oracleDatabaseInstanceInfo.status = 2;
        }
    }

    public int getUpInstancesCount() {
        int n2 = 0;
        for (OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo : this.instances.getAllInstances()) {
            if (oracleDatabaseInstanceInfo.status != 1) continue;
            ++n2;
        }
        return n2;
    }

    public OracleDatabaseInstanceInfo getOracleDatabaseInstanceInfo(String string, String string2) {
        return this.instances.getInstance(string2, string);
    }

    public OracleDatabaseInstanceInfo getOracleDatabaseInstanceInfo(int n2) {
        return this.instances.getInstance(n2);
    }

    public INSTANCE_CATEGORY_FOR_DATA_AFFINITY getInstanceCategory(OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo) {
        String string = this.m_racMngr.generateDatabaseInstanceKey(oracleDatabaseInstanceInfo.getInstanceName(), oracleDatabaseInstanceInfo.getDatabaseName(), oracleDatabaseInstanceInfo.getServiceName());
        boolean bl2 = this.m_racMngr.getConnectionAffinityValue(string);
        if (oracleDatabaseInstanceInfo.status == 1 && (oracleDatabaseInstanceInfo.flag == 1 || oracleDatabaseInstanceInfo.flag == 2) && bl2) {
            return INSTANCE_CATEGORY_FOR_DATA_AFFINITY.GOOD_INSTANCE;
        }
        if (!(oracleDatabaseInstanceInfo.status != 1 || oracleDatabaseInstanceInfo.flag != 3 && bl2)) {
            return INSTANCE_CATEGORY_FOR_DATA_AFFINITY.VIOLATING_INSTANCE;
        }
        return INSTANCE_CATEGORY_FOR_DATA_AFFINITY.BAD_INSTANCE;
    }

    public Collection<OracleDatabaseInstanceInfo> getRacMetadata() {
        return this.instances.getAllInstances();
    }

    static {
        try {
            $$$methodRef$$$19 = OracleDatabaseInstanceInfoList.class.getDeclaredConstructor(RACManagerImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$18 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("access$000", OracleDatabaseInstanceInfoList.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$17 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("getRacMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$16 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("getInstanceCategory", OracleDatabaseInstanceInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$15 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("getOracleDatabaseInstanceInfo", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$14 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("getOracleDatabaseInstanceInfo", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$13 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("getUpInstancesCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$12 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("markDownInstanceForHostDownEvent", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$11 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("markDownInstanceForServiceDownEvent", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$10 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("markUpInstanceForUpEvent", String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$9 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("getConnectionToNamedInstance", OracleDatabaseInstanceInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$8 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("useGoodGroup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$7 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("scheduleInstancesForGravitation", BlockingQueue.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$6 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("selectConnectionPerRLBMetrics", ConnectionRetrievalInfo.class, RACManagerImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$5 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("getMostDesirableInstanceToGrow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$4 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("size", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$3 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("isNamedInstanceConnectingAllowed", String.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$2 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("setNamedInstanceUrl", OracleDatabaseInstanceInfo.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$1 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("updateDatabaseInstanceInfo", OracleDatabaseInstanceInfo.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$0 = OracleDatabaseInstanceInfoList.class.getDeclaredMethod("getAllInstances", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
    }

    public static final class INSTANCE_CATEGORY_FOR_DATA_AFFINITY
    extends Enum<INSTANCE_CATEGORY_FOR_DATA_AFFINITY> {
        public static final /* enum */ INSTANCE_CATEGORY_FOR_DATA_AFFINITY GOOD_INSTANCE;
        public static final /* enum */ INSTANCE_CATEGORY_FOR_DATA_AFFINITY VIOLATING_INSTANCE;
        public static final /* enum */ INSTANCE_CATEGORY_FOR_DATA_AFFINITY BAD_INSTANCE;
        private static final /* synthetic */ INSTANCE_CATEGORY_FOR_DATA_AFFINITY[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static INSTANCE_CATEGORY_FOR_DATA_AFFINITY[] values() {
            return (INSTANCE_CATEGORY_FOR_DATA_AFFINITY[])$VALUES.clone();
        }

        public static INSTANCE_CATEGORY_FOR_DATA_AFFINITY valueOf(String string) {
            return Enum.valueOf(INSTANCE_CATEGORY_FOR_DATA_AFFINITY.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = INSTANCE_CATEGORY_FOR_DATA_AFFINITY.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = INSTANCE_CATEGORY_FOR_DATA_AFFINITY.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = INSTANCE_CATEGORY_FOR_DATA_AFFINITY.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            GOOD_INSTANCE = new INSTANCE_CATEGORY_FOR_DATA_AFFINITY();
            VIOLATING_INSTANCE = new INSTANCE_CATEGORY_FOR_DATA_AFFINITY();
            BAD_INSTANCE = new INSTANCE_CATEGORY_FOR_DATA_AFFINITY();
            $VALUES = new INSTANCE_CATEGORY_FOR_DATA_AFFINITY[]{GOOD_INSTANCE, VIOLATING_INSTANCE, BAD_INSTANCE};
        }
    }

    public static class Instances {
        private static final String BROKEN = "instance info base integrity is broken";
        private Map<OracleDatabaseInstanceInfo, Integer> instanceToId = new HashMap<OracleDatabaseInstanceInfo, Integer>();
        private Map<Integer, OracleDatabaseInstanceInfo> idToInstance = new HashMap<Integer, OracleDatabaseInstanceInfo>();
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        synchronized OracleDatabaseInstanceInfo getInstance(int n2) {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            assert (n2 >= 0) : "negative id";
            return this.idToInstance.get(n2);
        }

        synchronized OracleDatabaseInstanceInfo getInstance(String string, String string2) {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            return this.idToInstance.get(this.instanceToId.get(new OracleDatabaseInstanceInfo(string, string2)));
        }

        synchronized Collection<OracleDatabaseInstanceInfo> getAllInstances() {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            return new ArrayList<OracleDatabaseInstanceInfo>(this.idToInstance.values());
        }

        synchronized Integer getId(OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo) {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            return this.instanceToId.get(oracleDatabaseInstanceInfo);
        }

        public synchronized void add(OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo, int n2) {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            assert (n2 >= 0) : "negative id";
            assert (null != oracleDatabaseInstanceInfo) : "instance is null";
            Integer n3 = this.instanceToId.get(oracleDatabaseInstanceInfo);
            OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo2 = this.idToInstance.get(n2);
            if (null != n3 && n3.equals(n2) && null != oracleDatabaseInstanceInfo2 && oracleDatabaseInstanceInfo2.equals(oracleDatabaseInstanceInfo)) {
                return;
            }
            assert (null == n3 && null == oracleDatabaseInstanceInfo2) : "some other pair with either given instance or id has been previously written";
            this.instanceToId.put(oracleDatabaseInstanceInfo, n2);
            this.idToInstance.put(n2, oracleDatabaseInstanceInfo);
        }

        synchronized int size() {
            assert (this.instanceToId.size() == this.idToInstance.size()) : "instance info base integrity is broken";
            return this.instanceToId.size();
        }

        static {
            try {
                $$$methodRef$$$6 = Instances.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = Instances.class.getDeclaredMethod("size", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = Instances.class.getDeclaredMethod("add", OracleDatabaseInstanceInfo.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = Instances.class.getDeclaredMethod("getId", OracleDatabaseInstanceInfo.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = Instances.class.getDeclaredMethod("getAllInstances", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = Instances.class.getDeclaredMethod("getInstance", String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = Instances.class.getDeclaredMethod("getInstance", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

