/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle.rlb;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;
import oracle.ucp.jdbc.oracle.rlb.PolicyBase;
import oracle.ucp.jdbc.oracle.rlb.RLBInfo;
import oracle.ucp.logging.ClioSupport;

@DefaultLogger(value="oracle.ucp.jdbc.oracle.rlb")
@Supports(value={Feature.LOAD_BALANCING})
class PolicyImpl
extends PolicyBase {
    public static final int NUMBER_OF_HITS_PER_INSTANCE = 1000;
    private final Map<String, SpecificStats> mapSpecificStats = new HashMap<String, SpecificStats>();
    private float advisoryPercentTotal = 100.0f;
    private final Random m_rand = new Random(0L);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    PolicyImpl() {
    }

    private long getAttemptedConnRequestCount(String string) {
        SpecificStats specificStats = this.mapSpecificStats.get(string);
        return null == specificStats ? 0L : specificStats.attemptedConnRequestsCount;
    }

    private void incrementAttemptedConnRequestCount(String string) {
        SpecificStats specificStats = this.mapSpecificStats.get(string);
        if (null == specificStats) {
            specificStats = new SpecificStats();
            this.mapSpecificStats.put(string, specificStats);
        }
        ++specificStats.attemptedConnRequestsCount;
    }

    @Override
    public Map<OracleDatabaseInstanceInfo, Integer> getCurrentRebalancePolicy() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Connection rebalancing policy requested: ");
        HashMap<OracleDatabaseInstanceInfo, Integer> hashMap = new HashMap<OracleDatabaseInstanceInfo, Integer>();
        RLBInfo.Frame frame = this.getRLBInfo().getPreviousFrame();
        if (null == frame) {
            stringBuilder.append("empty");
            ClioSupport.ilogFinest(null, null, null, null, stringBuilder.toString());
            return hashMap;
        }
        float f2 = 0.0f;
        int n2 = 0;
        int n3 = 0;
        ArrayList<OracleDatabaseInstanceInfo> arrayList = new ArrayList<OracleDatabaseInstanceInfo>();
        for (OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo : this.getRLBInfo().getInstances()) {
            Iterator iterator = oracleDatabaseInstanceInfo.getInstanceName();
            if (1 != oracleDatabaseInstanceInfo.status || 4 == oracleDatabaseInstanceInfo.flag || 5 == oracleDatabaseInstanceInfo.flag) continue;
            arrayList.add(oracleDatabaseInstanceInfo);
            f2 += oracleDatabaseInstanceInfo.getAdvisoryPercent();
            n2 = (int)((long)n2 + this.getAttemptedConnRequestCount((String)((Object)iterator)));
            n3 += oracleDatabaseInstanceInfo.getNumberOfConnectionsCount();
        }
        this.advisoryPercentTotal = f2;
        boolean bl2 = false;
        boolean bl3 = true;
        for (OracleDatabaseInstanceInfo object : arrayList) {
            int n4;
            string = object.getInstanceName();
            RLBInfo.InstanceStats instanceStats = frame.getStats(string);
            float f3 = 100.0f * (float)instanceStats.getConnsBorrowed() / (float)frame.getTotalBorrowed();
            float f4 = object.getAdvisoryPercent();
            float f5 = f4 - f3;
            int n5 = Math.round((float)n3 * f5 / 100.0f);
            long l2 = instanceStats.getConnsBorrowedPeak();
            if (l2 > (long)(n4 = Math.round((float)n3 * f4 / 100.0f))) {
                bl3 = false;
                ClioSupport.ilogFinest(null, null, null, null, string + ": bandwidth is too narrow, rebalance");
            }
            if (n5 > 0) {
                hashMap.put(object, n5);
                continue;
            }
            if (n2 > arrayList.size() * 1000) {
                float f6 = (float)this.getAttemptedConnRequestCount(string) / (float)n2;
                int n6 = object.getNumberOfConnectionsCount();
                float f7 = (float)n6 / (float)n3;
                if (f7 > f6 * 0.75f) {
                    if (n5 < 0) {
                        hashMap.put(object, n5);
                    }
                    bl2 = true;
                    continue;
                }
                ClioSupport.ilogFinest(null, null, null, null, "connRatio=" + f7 + " is less than ACRRatio=" + f6 + ", condition is under gravitation threshold");
                continue;
            }
            ClioSupport.ilogFinest(null, null, null, null, "totalAttemptedConnRequestsCount=" + n2 + " is lower than a designated gravitation threshold");
        }
        if (bl2) {
            this.mapSpecificStats.clear();
            bl2 = false;
        }
        if (0 == hashMap.keySet().size()) {
            stringBuilder.append("empty");
        } else {
            for (Map.Entry entry : hashMap.entrySet()) {
                string = ((OracleDatabaseInstanceInfo)entry.getKey()).getInstanceName();
                int n7 = (Integer)entry.getValue();
                stringBuilder.append("(").append(string).append(", ").append(n7).append(")");
            }
        }
        ClioSupport.ilogFinest(null, null, null, null, stringBuilder.toString());
        if (bl3) {
            ClioSupport.ilogFinest(null, null, null, null, "wide bandwidth - no rebalance necessary");
            return Collections.emptyMap();
        }
        return hashMap;
    }

    @Override
    public FailoverablePooledConnection borrowConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        int n2;
        RLBInfo.Frame frame = this.getRLBInfo().getCurrentFrame();
        if (null == frame) {
            return null;
        }
        Collection<OracleDatabaseInstanceInfo> collection = this.getRLBInfo().getInstances();
        int n3 = collection.size();
        boolean[] blArray = new boolean[n3];
        int n4 = this.getViolatingInstancesCount();
        int n5 = n2 = n4 != 0 ? this.getUpInstancesCount() / n4 : Integer.MAX_VALUE;
        if (this.advisoryPercentTotal > 0.0f && n3 > 0) {
            float f2 = this.advisoryPercentTotal;
            block0: for (int i2 = 0; i2 < n3; ++i2) {
                float f3 = 0.0f;
                int n6 = 0;
                float f4 = this.m_rand.nextFloat() * f2;
                for (OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo : this.getRLBInfo().getInstances()) {
                    String string = oracleDatabaseInstanceInfo.getInstanceName();
                    int n7 = oracleDatabaseInstanceInfo.flag;
                    if (!(blArray[n6] || 1 != n7 && 2 != n7 && 3 != n7)) {
                        if (3 == n7 && n2 > 2) {
                            blArray[n6] = true;
                            ++n6;
                            continue;
                        }
                        if (f4 < (f3 += oracleDatabaseInstanceInfo.getAdvisoryPercent())) {
                            FailoverablePooledConnection failoverablePooledConnection;
                            if (i2 == 0) {
                                this.incrementAttemptedConnRequestCount(string);
                            }
                            if (null != (failoverablePooledConnection = this.getConnectionsDispatcher().borrowConnection(oracleDatabaseInstanceInfo, connectionRetrievalInfo))) {
                                return failoverablePooledConnection;
                            }
                            f2 -= oracleDatabaseInstanceInfo.getAdvisoryPercent();
                            blArray[n6] = true;
                            continue block0;
                        }
                    }
                    ++n6;
                }
            }
        }
        return null;
    }

    private int getViolatingInstancesCount() {
        int n2 = 0;
        for (OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo : this.getRLBInfo().getInstances()) {
            if (oracleDatabaseInstanceInfo.status != 1 || 3 != oracleDatabaseInstanceInfo.flag) continue;
            ++n2;
        }
        return n2;
    }

    private int getUpInstancesCount() {
        int n2 = 0;
        for (OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo : this.getRLBInfo().getInstances()) {
            if (oracleDatabaseInstanceInfo.status != 1) continue;
            ++n2;
        }
        return n2;
    }

    static {
        try {
            $$$methodRef$$$6 = PolicyImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$5 = PolicyImpl.class.getDeclaredMethod("getUpInstancesCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$4 = PolicyImpl.class.getDeclaredMethod("getViolatingInstancesCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$3 = PolicyImpl.class.getDeclaredMethod("borrowConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$2 = PolicyImpl.class.getDeclaredMethod("getCurrentRebalancePolicy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$1 = PolicyImpl.class.getDeclaredMethod("incrementAttemptedConnRequestCount", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$0 = PolicyImpl.class.getDeclaredMethod("getAttemptedConnRequestCount", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
    }

    private static final class SpecificStats {
        long attemptedConnRequestsCount = 0L;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        private SpecificStats() {
        }

        static {
            try {
                $$$methodRef$$$1 = SpecificStats.class.getDeclaredConstructor(1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = SpecificStats.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

