/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.XAConnection;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.ClientDataSupport;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Clock;
import oracle.ucp.jdbc.ConnectionWithAbandonedTimeout;
import oracle.ucp.jdbc.ConnectionWithTimeToLiveTimeout;
import oracle.ucp.jdbc.HarvestableConnection;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.LabelableConnection;
import oracle.ucp.jdbc.ValidConnection;
import oracle.ucp.jdbc.oracle.Poolable;
import oracle.ucp.jdbc.proxy.Creator;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.oracle.StatementProxy;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.Chain;
import oracle.ucp.util.MapChain;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
abstract class ConnectionProxyBase
implements XAConnection,
ClientDataSupport,
ConnectionWithAbandonedTimeout,
ConnectionWithTimeToLiveTimeout,
HarvestableConnection,
LabelableConnection,
ValidConnection,
Poolable,
LogicalObject {
    protected final long creationTS = Clock.clock();
    final AtomicBoolean closed = new AtomicBoolean(false);
    protected final AtomicBoolean actuallyReturned = new AtomicBoolean(false);
    protected Chain<StatementProxy> statementsToClose = new MapChain<StatementProxy>();

    ConnectionProxyBase() {
    }

    UniversalPooledConnection getUPC() {
        Object object = this.getCreator();
        return object instanceof Creator ? ((Creator)object).getUPC() : ((ConnectionProxyBase)object).getUPC();
    }

    UniversalConnectionPool getUCP() {
        Object object = this.getCreator();
        return object instanceof Creator ? ((Creator)object).getUCP() : ((ConnectionProxyBase)object).getUCP();
    }

    protected abstract Connection getDelegate();

    protected abstract Object getCreator();

    protected void handleSQRecoverableException(SQLException sQLException) throws SQLException {
        if (sQLException instanceof SQLRecoverableException && !this.actuallyReturned.get()) {
            try {
                for (StatementProxy statementProxy : this.statementsToClose.toList()) {
                    statementProxy.close();
                }
                this.statementsToClose.clear();
                this.getUPC().setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                this.getUCP().returnConnection(this.getUPC());
                this.actuallyReturned.set(true);
                this.closed.set(true);
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        UniversalConnectionPool universalConnectionPool = this.getUCP();
        UniversalPooledConnection universalPooledConnection = this.getUPC();
        universalPooledConnection.heartbeat();
        if (this.closed.get()) {
            return;
        }
        try {
            for (StatementProxy statementProxy : this.statementsToClose.toList()) {
                statementProxy.close();
            }
            this.statementsToClose.clear();
            this.closed.set(true);
            universalConnectionPool.returnConnection(universalPooledConnection);
            this.actuallyReturned.set(true);
            universalPooledConnection.heartbeat();
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            Throwable throwable = universalConnectionPoolException.getCause();
            if (null == throwable) {
                throw new SQLException(universalConnectionPoolException);
            }
            Throwable throwable2 = throwable.getCause();
            if (null == throwable2 || !(throwable2 instanceof SQLException)) {
                throw new SQLException(universalConnectionPoolException);
            }
            throw (SQLException)throwable2;
        }
    }

    public void close(int n2) throws SQLException {
        ConnectionRetrievalInfo connectionRetrievalInfo;
        UniversalPooledConnection universalPooledConnection = this.getUPC();
        universalPooledConnection.heartbeat();
        ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).close(n2);
        if (1 == n2 && (connectionRetrievalInfo = universalPooledConnection.getConnectionRetrievalInfo()) instanceof JDBCConnectionRetrievalInfo) {
            JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
            universalPooledConnection.setConnectionRetrievalInfo(jDBCConnectionRetrievalInfo.getCopyWithNewProxyProperties(-1, null));
        }
        universalPooledConnection.heartbeat();
    }

    public void close(Properties properties) throws SQLException {
        UniversalPooledConnection universalPooledConnection = this.getUPC();
        universalPooledConnection.heartbeat();
        ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).close(properties);
        universalPooledConnection.heartbeat();
    }

    public boolean isUsable() {
        if (this.closed.get()) {
            return false;
        }
        return ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).isUsable();
    }

    public boolean isValid(int n2) throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        return this.getDelegate().isValid(n2);
    }

    public boolean isValid(OracleConnection.ConnectionValidation connectionValidation, int n2) throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        return ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).isValid(connectionValidation, n2);
    }

    @Override
    public boolean isValid() throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        return this.getUPC().isValid();
    }

    @Override
    public void setInvalid() throws SQLException {
        this.getUPC().heartbeat();
        try {
            this.getUPC().setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            throw new SQLException(universalConnectionPoolException);
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.closed.get()) {
            return true;
        }
        return this.getDelegate().isClosed();
    }

    @Override
    public UniversalPooledConnection getPooledObject() {
        return this.getUPC();
    }

    @Override
    public boolean isLogicallyClosed() {
        return this.closed.get();
    }

    @Override
    public void applyConnectionLabel(String string, String string2) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().applyConnectionLabel(string, string2);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(32, universalConnectionPoolException);
        }
    }

    @Override
    public void removeConnectionLabel(String string) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().removeConnectionLabel(string);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(33, universalConnectionPoolException);
        }
    }

    @Override
    public Properties getConnectionLabels() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        Properties properties = null;
        try {
            properties = this.getUPC().getConnectionLabels();
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(34, universalConnectionPoolException);
        }
        return properties;
    }

    @Override
    public Properties getUnmatchedConnectionLabels(Properties properties) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        Properties properties2 = null;
        try {
            properties2 = this.getUPC().getUnmatchedConnectionLabels(properties);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(35, universalConnectionPoolException);
        }
        return properties2;
    }

    @Override
    public void setConnectionHarvestable(boolean bl2) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().setConnectionHarvestable(bl2);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(36, universalConnectionPoolException);
        }
    }

    @Override
    public boolean isConnectionHarvestable() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        return this.getUPC().isConnectionHarvestable();
    }

    @Override
    public void registerConnectionHarvestingCallback(ConnectionHarvestingCallback connectionHarvestingCallback) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().registerConnectionHarvestingCallback(connectionHarvestingCallback);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(37, universalConnectionPoolException);
        }
    }

    @Override
    public void removeConnectionHarvestingCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().removeConnectionHarvestingCallback();
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(38, universalConnectionPoolException);
        }
    }

    @Override
    public void registerAbandonedConnectionTimeoutCallback(AbandonedConnectionTimeoutCallback abandonedConnectionTimeoutCallback) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().registerAbandonedConnectionTimeoutCallback(abandonedConnectionTimeoutCallback);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(39, universalConnectionPoolException);
        }
    }

    @Override
    public void removeAbandonedConnectionTimeoutCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().removeAbandonedConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(40, universalConnectionPoolException);
        }
    }

    @Override
    public void registerTimeToLiveConnectionTimeoutCallback(TimeToLiveConnectionTimeoutCallback timeToLiveConnectionTimeoutCallback) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().registerTimeToLiveConnectionTimeoutCallback(timeToLiveConnectionTimeoutCallback);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(41, universalConnectionPoolException);
        }
    }

    @Override
    public void removeTimeToLiveConnectionTimeoutCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().removeTimeToLiveConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(42, universalConnectionPoolException);
        }
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.getDelegate().equals(object instanceof ConnectionProxyBase ? ((ConnectionProxyBase)object).getDelegate() : object);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public Object getClientData(Object object) {
        return ((OracleConnection)this.getDelegate()).getClientData(object);
    }

    @Override
    public Object setClientData(Object object, Object object2) {
        return ((OracleConnection)this.getDelegate()).setClientData(object, object2);
    }

    @Override
    public Object removeClientData(Object object) {
        return ((OracleConnection)this.getDelegate()).removeClientData(object);
    }

    protected void saveStatementProxy(Object object) {
        if (object instanceof StatementProxy) {
            StatementProxy statementProxy = (StatementProxy)object;
            statementProxy.setStatementChainAtom(this.statementsToClose.add(statementProxy));
        }
    }
}

