/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.oracle;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.sql.ConcreteProxyUtil;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Clock;
import oracle.ucp.jdbc.proxy.ProxyException;
import oracle.ucp.jdbc.proxy.oracle.ConnectionProxyBase;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.proxy.annotation.GetCreator;
import oracle.ucp.proxy.annotation.GetDelegate;
import oracle.ucp.proxy.annotation.Methods;
import oracle.ucp.proxy.annotation.OnError;
import oracle.ucp.proxy.annotation.Post;
import oracle.ucp.proxy.annotation.Pre;
import oracle.ucp.proxy.annotation.ProxyFor;
import oracle.ucp.proxy.annotation.ProxyResult;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import oracle.ucp.proxy.annotation.Signature;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
@ProxyFor(value={Connection.class, XAConnection.class, OracleConnection.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class ReplayableConnectionProxy
extends ConnectionProxyBase
implements ReplayableConnection {
    @Override
    @GetDelegate
    protected abstract Connection getDelegate();

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Pre
    @Methods(signatures={@Signature(name="addConnectionEventListener", args={ConnectionEventListener.class}), @Signature(name="addStatementEventListener", args={StatementEventListener.class}), @Signature(name="removeConnectionEventListener", args={ConnectionEventListener.class}), @Signature(name="removeStatementEventListener", args={StatementEventListener.class}), @Signature(name="IsNCharFixedWith", args={}), @Signature(name="_getPC", args={}), @Signature(name="classForNameAndSchema", args={String.class, String.class}), @Signature(name="descriptorCacheKeys", args={}), @Signature(name="getACProxy", args={}), @Signature(name="getByteBufferCacheStatistics", args={}), @Signature(name="getC2SNlsRatio", args={}), @Signature(name="getCharBufferCacheStatistics", args={}), @Signature(name="getClassForType", args={String.class, Map.class}), @Signature(name="getCreateStatementAsRefCursor", args={}), @Signature(name="getDefaultExecuteBatch", args={}), @Signature(name="getDefaultFixedString", args={}), @Signature(name="getDefaultRowPrefetch", args={}), @Signature(name="getDescriptor", args={byte[].class}), @Signature(name="getDescriptor", args={String.class}), @Signature(name="getDriverCharSet", args={}), @Signature(name="getExecutingRPCFunctionCode", args={}), @Signature(name="getExecutingRPCSQL", args={}), @Signature(name="getHAManager", args={}), @Signature(name="getIncludeSynonyms", args={}), @Signature(name="getJDBCStandardBehavior", args={}), @Signature(name="getJavaObjectTypeMap", args={}), @Signature(name="getMapDateToTimestamp", args={}), @Signature(name="getMaxCharbyteSize", args={}), @Signature(name="getMaxNCharbyteSize", args={}), @Signature(name="getNCharSet", args={}), @Signature(name="getNetworkStat", args={}), @Signature(name="getProperties", args={}), @Signature(name="getProtocolType", args={}), @Signature(name="getRemarksReporting", args={}), @Signature(name="getRestrictGetTables", args={}), @Signature(name="getSessionTimeZone", args={}), @Signature(name="getStmtCacheSize", args={}), @Signature(name="getTimestamptzInGmt", args={}), @Signature(name="getTxnMode", args={}), @Signature(name="getUse1900AsYearForTime", args={}), @Signature(name="getUsingXAFlag", args={}), @Signature(name="getWrapper", args={}), @Signature(name="getXAErrorFlag", args={}), @Signature(name="isCharSetMultibyte", args={short.class}), @Signature(name="isLogicalConnection", args={}), @Signature(name="isNetworkCompressionEnabled", args={}), @Signature(name="isProxySession", args={}), @Signature(name="isStatementCacheInitialized", args={}), @Signature(name="isUsable", args={boolean.class}), @Signature(name="setClientInfo", args={String.class, String.class}), @Signature(name="setClientInfo", args={Properties.class}), @Signature(name="numberOfDescriptorCacheEntries", args={}), @Signature(name="removeAllDescriptor", args={}), @Signature(name="removeDescriptor", args={String.class}), @Signature(name="setACProxy", args={Object.class}), @Signature(name="setCreateStatementAsRefCursor", args={boolean.class}), @Signature(name="setDefaultFixedString", args={boolean.class}), @Signature(name="setIncludeSynonyms", args={boolean.class}), @Signature(name="setJavaObjectTypeMap", args={Map.class}), @Signature(name="setRemarksReporting", args={boolean.class}), @Signature(name="setRestrictGetTables", args={boolean.class}), @Signature(name="setTxnMode", args={int.class}), @Signature(name="setUsable", args={boolean.class}), @Signature(name="setUsingXAFlag", args={boolean.class}), @Signature(name="setWrapper", args={oracle.jdbc.OracleConnection.class}), @Signature(name="setXAErrorFlag", args={boolean.class})})
    protected void preNoThrow(Method method, Object object, Object ... objectArray) {
        try {
            this.pre(method, object, objectArray);
        }
        catch (SQLException sQLException) {
            throw new ProxyException(sQLException);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="getLogicalTransactionId", args={})})
    protected void preNoThrowGetLTXID(Method method, Object object, Object ... objectArray) {
        try {
            this.pre(method, object, objectArray);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Pre
    protected void pre(Method method, Object object, Object ... objectArray) throws SQLException {
        if (this.closed.get()) {
            String string = UCPErrorHandler.findSQLMessage(31, null);
            throw new SQLRecoverableException(string, null, 31);
        }
        this.getUPC().heartbeat();
        if (Clock.isBefore(this.creationTS, this.getUPC().getAvailableStartTime()) || Clock.isBefore(this.creationTS, this.getUPC().getBorrowedStartTime())) {
            try {
                this.getUPC().setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                this.getUCP().returnConnection(this.getUPC());
                this.closed.set(true);
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
            }
        }
    }

    @Post
    @Methods(signatures={@Signature(name="createStatement", args={}), @Signature(name="createStatement", args={int.class, int.class}), @Signature(name="createStatement", args={int.class, int.class, int.class})})
    protected Statement post(Method method, Statement statement) {
        this.getUPC().heartbeat();
        this.saveStatementProxy(statement);
        return statement;
    }

    @Post
    @Methods(signatures={@Signature(name="prepareCall", args={String.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class, int.class}), @Signature(name="prepareCall", args={String.class, Properties.class})})
    protected CallableStatement post(Method method, CallableStatement callableStatement) {
        this.getUPC().heartbeat();
        this.saveStatementProxy(callableStatement);
        return callableStatement;
    }

    @Post
    @Methods(signatures={@Signature(name="prepareStatement", args={String.class}), @Signature(name="prepareStatement", args={String.class, int.class}), @Signature(name="prepareStatement", args={String.class, int[].class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, String[].class})})
    protected PreparedStatement post(Method method, PreparedStatement preparedStatement) {
        this.getUPC().heartbeat();
        this.saveStatementProxy(preparedStatement);
        return preparedStatement;
    }

    @Post
    protected Object postRest(Method method, Object object) {
        this.getUPC().heartbeat();
        this.saveStatementProxy(object);
        return object;
    }

    @OnError(value=SQLException.class)
    protected void onErrorVoid(Method method, SQLException sQLException) throws SQLException {
        this.onError(method, sQLException);
    }

    @OnError(value=SQLException.class)
    protected Object onError(Method method, SQLException sQLException) throws SQLException {
        this.getUPC().heartbeat();
        this.handleSQRecoverableException(sQLException);
        throw sQLException;
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getPhysicalConnection() {
        OracleConnection oracleConnection = ((OracleConnection)this.getDelegate()).getPhysicalConnection();
        oracle.jdbc.OracleConnection oracleConnection2 = ConcreteProxyUtil.getThinDriverReplayableConnectionDelegate(oracleConnection);
        return null == oracleConnection2 ? oracleConnection : oracleConnection2;
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        this.getUPC().heartbeat();
        if (clazz.isInterface()) {
            if (clazz.isInstance(this.getDelegate())) {
                return (T)this.getDelegate();
            }
            return this.getDelegate().unwrap(clazz);
        }
        throw new SQLException("unable to unwrap interface " + clazz.toString());
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public oracle.jdbc.OracleConnection unwrap() {
        return ((OracleConnection)this.getDelegate()).unwrap();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection physicalConnectionWithin() {
        OracleConnection oracleConnection = ((OracleConnection)this.getDelegate()).physicalConnectionWithin();
        oracle.jdbc.OracleConnection oracleConnection2 = ConcreteProxyUtil.getThinDriverReplayableConnectionDelegate(oracleConnection);
        return null == oracleConnection2 ? oracleConnection : oracleConnection2;
    }

    private ReplayableConnection getReplayableConnection() {
        return (ReplayableConnection)this.getUPC().getPhysicalConnection();
    }

    @Override
    public void beginRequest() throws SQLException {
        this.getReplayableConnection().beginRequest();
    }

    @Override
    public void endRequest() throws SQLException {
        this.getReplayableConnection().endRequest();
    }

    @Override
    public void disableReplay() throws SQLException {
        this.getReplayableConnection().disableReplay();
    }

    @Override
    public ReplayStatistics getReplayStatistics(ReplayableConnection.StatisticsReportType statisticsReportType) {
        return this.getReplayableConnection().getReplayStatistics(statisticsReportType);
    }

    @Override
    public void clearReplayStatistics(ReplayableConnection.StatisticsReportType statisticsReportType) {
        this.getReplayableConnection().clearReplayStatistics(statisticsReportType);
    }
}

