/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.oracle;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.Clock;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.ProxyException;
import oracle.ucp.jdbc.proxy.oracle.ConnectionProxyBase;
import oracle.ucp.jdbc.proxy.oracle.ResultSetProxy;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.proxy.annotation.GetCreator;
import oracle.ucp.proxy.annotation.GetDelegate;
import oracle.ucp.proxy.annotation.Methods;
import oracle.ucp.proxy.annotation.OnError;
import oracle.ucp.proxy.annotation.Post;
import oracle.ucp.proxy.annotation.Pre;
import oracle.ucp.proxy.annotation.ProxyFor;
import oracle.ucp.proxy.annotation.ProxyResult;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import oracle.ucp.proxy.annotation.Signature;
import oracle.ucp.util.Chain;
import oracle.ucp.util.MapChain;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
@ProxyFor(value={OracleCallableStatement.class, OraclePreparedStatement.class, OracleStatement.class, LogicalObject.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class StatementProxy
implements LogicalObject {
    private final long creationTS = Clock.clock();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private static final int ORAERROR_INVALID_SHARDKEYS = 45582;
    private AtomicBoolean initialQueryTimeoutSet = new AtomicBoolean(false);
    protected Chain<ResultSetProxy> resultSetsToClose = new MapChain<ResultSetProxy>();
    private Chain.Atom<StatementProxy> statementChainAtom = null;
    private boolean sqlWithQueryTimeoutInProgress = false;

    void setStatementChainAtom(Chain.Atom<StatementProxy> atom) {
        this.statementChainAtom = atom;
    }

    private void prepare() {
        this.getUPC().heartbeat();
        if (this.initialQueryTimeoutSet.compareAndSet(false, true)) {
            try {
                this.getDelegate().setQueryTimeout(((UniversalConnectionPoolBase)this.getUCP()).getQueryTimeout());
            }
            catch (SQLException sQLException) {
                ClioSupport.ilogThrowing(null, null, null, null, sQLException);
            }
        }
    }

    @GetDelegate
    protected abstract Statement getDelegate();

    @GetCreator
    protected abstract Object getCreator();

    UniversalPooledConnection getUPC() {
        return ((ConnectionProxyBase)this.getCreator()).getUPC();
    }

    UniversalConnectionPool getUCP() {
        return ((ConnectionProxyBase)this.getCreator()).getUCP();
    }

    @Override
    public boolean isLogicallyClosed() {
        this.prepare();
        return this.closed.get();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getConnection() throws SQLException {
        this.prepare();
        if (this.isClosed()) {
            throw UCPErrorHandler.newSQLException(44);
        }
        return (Connection)this.getCreator();
    }

    public void setQueryTimeout(int n2) throws SQLException {
        this.sqlWithQueryTimeoutInProgress = n2 > 0;
        this.prepare();
        this.getDelegate().setQueryTimeout(n2);
        this.getUPC().heartbeat();
    }

    public void closeOnCompletion() throws SQLException {
        this.prepare();
        this.getDelegate().closeOnCompletion();
        this.getUPC().heartbeat();
    }

    public boolean isClosed() throws SQLException {
        this.prepare();
        return this.closed.get() || this.getDelegate().isClosed() || ((ConnectionProxyBase)this.getCreator()).closed.get();
    }

    public void close() throws SQLException {
        this.prepare();
        if (this.closed.get()) {
            return;
        }
        for (ResultSetProxy resultSetProxy : this.resultSetsToClose.toList()) {
            resultSetProxy.close();
        }
        this.resultSetsToClose.clear();
        this.statementChainAtom.remove();
        this.closed.set(true);
        this.getDelegate().close();
        this.getUPC().heartbeat();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        this.prepare();
        if (clazz.isInterface()) {
            if (clazz.isInstance(this.getDelegate())) {
                return (T)this.getDelegate();
            }
            return this.getDelegate().unwrap(clazz);
        }
        throw new SQLException("unable to unwrap interface " + clazz.toString());
    }

    @Pre
    @Methods(signatures={@Signature(name="creationState", args={}), @Signature(name="getACProxy", args={}), @Signature(name="getExecuteBatch", args={}), @Signature(name="getFixedString", args={}), @Signature(name="getRowPrefetch", args={}), @Signature(name="getcacheState", args={}), @Signature(name="getserverCursor", args={}), @Signature(name="getstatementType", args={}), @Signature(name="setACProxy", args={Object.class}), @Signature(name="setCheckBindTypes", args={boolean.class}), @Signature(name="setDisableStmtCaching", args={boolean.class}), @Signature(name="setFixedString", args={boolean.class}), @Signature(name="setFormOfUse", args={int.class, short.class})})
    protected void preNoThrow(Method method, Object object, Object ... objectArray) {
        try {
            this.pre(method, object, objectArray);
        }
        catch (SQLException sQLException) {
            throw new ProxyException(sQLException);
        }
    }

    @Pre
    protected void pre(Method method, Object object, Object ... objectArray) throws SQLException {
        ConnectionProxyBase connectionProxyBase;
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(44);
        }
        this.prepare();
        this.getUPC().setSqlWithQueryTimeoutInProgress(this.sqlWithQueryTimeoutInProgress);
        if (Clock.isBefore(this.creationTS, this.getUPC().getAvailableStartTime()) || Clock.isBefore(this.creationTS, this.getUPC().getBorrowedStartTime())) {
            this.closed.set(true);
            ((Connection)this.getCreator()).close();
        }
        if ((connectionProxyBase = (ConnectionProxyBase)this.getCreator()).isLogicallyClosed()) {
            throw UCPErrorHandler.newSQLException(31);
        }
    }

    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="executeQuery", args={String.class}), @Signature(name="getResultSet", args={}), @Signature(name="getGeneratedKeys", args={})})
    protected ResultSet post(Method method, ResultSet resultSet) {
        this.getUPC().heartbeat();
        this.sqlWithQueryTimeoutInProgress = false;
        this.getUPC().setSqlWithQueryTimeoutInProgress(false);
        this.saveResultSetProxy(resultSet);
        return resultSet;
    }

    @Post
    protected Object postRest(Method method, Object object) {
        this.getUPC().heartbeat();
        this.saveResultSetProxy(object);
        return object;
    }

    protected void saveResultSetProxy(Object object) {
        if (object instanceof ResultSetProxy) {
            ResultSetProxy resultSetProxy = (ResultSetProxy)object;
            resultSetProxy.setResultSetChainAtom(this.resultSetsToClose.add(resultSetProxy));
        }
    }

    @Post
    protected void postRestVoid(Method method) {
        this.getUPC().heartbeat();
    }

    @OnError(value=SQLException.class)
    protected void onErrorVoid(Method method, SQLException sQLException) throws SQLException {
        this.onError(method, sQLException);
    }

    @OnError(value=SQLException.class)
    protected Object onError(Method method, SQLException sQLException) throws SQLException {
        int n2;
        this.getUPC().heartbeat();
        ((ConnectionProxyBase)this.getCreator()).handleSQRecoverableException(sQLException);
        if (sQLException instanceof SQLException && (n2 = sQLException.getErrorCode()) == 45582) {
            this.getUPC().getDelegator().onError();
        }
        throw sQLException;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.getDelegate().equals(object instanceof StatementProxy ? ((StatementProxy)object).getDelegate() : object);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }
}

