/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.other;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Clock;
import oracle.ucp.jdbc.ConnectionWithAbandonedTimeout;
import oracle.ucp.jdbc.ConnectionWithTimeToLiveTimeout;
import oracle.ucp.jdbc.HarvestableConnection;
import oracle.ucp.jdbc.LabelableConnection;
import oracle.ucp.jdbc.ValidConnection;
import oracle.ucp.jdbc.proxy.Creator;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.ProxyException;
import oracle.ucp.jdbc.proxy.other.StatementProxy;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.proxy.annotation.GetCreator;
import oracle.ucp.proxy.annotation.GetDelegate;
import oracle.ucp.proxy.annotation.Methods;
import oracle.ucp.proxy.annotation.OnError;
import oracle.ucp.proxy.annotation.Post;
import oracle.ucp.proxy.annotation.Pre;
import oracle.ucp.proxy.annotation.ProxyFor;
import oracle.ucp.proxy.annotation.ProxyResult;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import oracle.ucp.proxy.annotation.Signature;
import oracle.ucp.util.Chain;
import oracle.ucp.util.MapChain;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
@ProxyFor(value={Connection.class, XAConnection.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class ConnectionProxy
implements XAConnection,
ConnectionWithAbandonedTimeout,
ConnectionWithTimeToLiveTimeout,
HarvestableConnection,
LabelableConnection,
ValidConnection,
LogicalObject {
    protected final long creationTS = Clock.clock();
    final AtomicBoolean closed = new AtomicBoolean(false);
    protected final AtomicBoolean actuallyReturned = new AtomicBoolean(false);
    protected Chain<StatementProxy> statementsToClose = new MapChain<StatementProxy>();

    UniversalPooledConnection getUPC() {
        Object object = this.getCreator();
        return object instanceof Creator ? ((Creator)object).getUPC() : ((ConnectionProxy)object).getUPC();
    }

    UniversalConnectionPool getUCP() {
        Object object = this.getCreator();
        return object instanceof Creator ? ((Creator)object).getUCP() : ((ConnectionProxy)object).getUCP();
    }

    @GetDelegate
    protected abstract Connection getDelegate();

    @GetCreator
    protected abstract Object getCreator();

    @Pre
    @Methods(signatures={@Signature(name="addConnectionEventListener", args={ConnectionEventListener.class}), @Signature(name="addStatementEventListener", args={StatementEventListener.class}), @Signature(name="removeConnectionEventListener", args={ConnectionEventListener.class}), @Signature(name="removeStatementEventListener", args={StatementEventListener.class}), @Signature(name="setClientInfo", args={String.class, String.class}), @Signature(name="setClientInfo", args={Properties.class})})
    protected void preNoThrow(Method method, Object object, Object ... objectArray) {
        try {
            this.pre(method, object, objectArray);
        }
        catch (SQLException sQLException) {
            throw new ProxyException(sQLException);
        }
    }

    @Pre
    protected void pre(Method method, Object object, Object ... objectArray) throws SQLException {
        this.getUPC().heartbeat();
        if (this.closed.get()) {
            String string = UCPErrorHandler.findSQLMessage(31, null);
            throw new SQLRecoverableException(string, null, 31);
        }
        if (Clock.isBefore(this.creationTS, this.getUPC().getAvailableStartTime()) || Clock.isBefore(this.creationTS, this.getUPC().getBorrowedStartTime())) {
            try {
                this.getUPC().setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                this.getUCP().returnConnection(this.getUPC());
                this.closed.set(true);
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
            }
        }
    }

    @Post
    @Methods(signatures={@Signature(name="createStatement", args={}), @Signature(name="createStatement", args={int.class, int.class}), @Signature(name="createStatement", args={int.class, int.class, int.class})})
    protected Statement post(Method method, Statement statement) {
        this.getUPC().heartbeat();
        this.saveStatementProxy(statement);
        return statement;
    }

    @Post
    @Methods(signatures={@Signature(name="prepareCall", args={String.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class, int.class}), @Signature(name="prepareCall", args={String.class, Properties.class})})
    protected CallableStatement post(Method method, CallableStatement callableStatement) {
        this.getUPC().heartbeat();
        this.saveStatementProxy(callableStatement);
        return callableStatement;
    }

    @Post
    @Methods(signatures={@Signature(name="prepareStatement", args={String.class}), @Signature(name="prepareStatement", args={String.class, int.class}), @Signature(name="prepareStatement", args={String.class, int[].class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, String[].class})})
    protected PreparedStatement post(Method method, PreparedStatement preparedStatement) {
        this.getUPC().heartbeat();
        this.saveStatementProxy(preparedStatement);
        return preparedStatement;
    }

    @Post
    protected Object postRest(Method method, Object object) {
        this.getUPC().heartbeat();
        this.saveStatementProxy(object);
        return object;
    }

    @OnError(value=SQLException.class)
    protected void onErrorVoid(Method method, SQLException sQLException) throws SQLException {
        this.onError(method, sQLException);
    }

    @OnError(value=SQLException.class)
    protected Object onError(Method method, SQLException sQLException) throws SQLException {
        this.getUPC().heartbeat();
        this.handleSQRecoverableException(sQLException);
        throw sQLException;
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        this.getUPC().heartbeat();
        if (clazz.isInterface()) {
            if (clazz.isInstance(this.getDelegate())) {
                return (T)this.getDelegate();
            }
            return this.getDelegate().unwrap(clazz);
        }
        throw new SQLException("unable to unwrap interface " + clazz.toString());
    }

    protected void handleSQRecoverableException(SQLException sQLException) throws SQLException {
        if (sQLException instanceof SQLRecoverableException && !this.actuallyReturned.get()) {
            try {
                for (StatementProxy statementProxy : this.statementsToClose.toList()) {
                    statementProxy.close();
                }
                this.statementsToClose.clear();
                this.getUPC().setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                this.getUCP().returnConnection(this.getUPC());
                this.actuallyReturned.set(true);
                this.closed.set(true);
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        UniversalConnectionPool universalConnectionPool = this.getUCP();
        UniversalPooledConnection universalPooledConnection = this.getUPC();
        universalPooledConnection.heartbeat();
        if (this.closed.get()) {
            return;
        }
        try {
            for (StatementProxy statementProxy : this.statementsToClose.toList()) {
                statementProxy.close();
            }
            this.statementsToClose.clear();
            this.closed.set(true);
            universalConnectionPool.returnConnection(universalPooledConnection);
            this.actuallyReturned.set(true);
            universalPooledConnection.heartbeat();
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            Throwable throwable = universalConnectionPoolException.getCause();
            if (null == throwable) {
                throw new SQLException(universalConnectionPoolException);
            }
            Throwable throwable2 = throwable.getCause();
            if (null == throwable2 || !(throwable2 instanceof SQLException)) {
                throw new SQLException(universalConnectionPoolException);
            }
            throw (SQLException)throwable2;
        }
    }

    public boolean isValid(int n2) throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        return this.getDelegate().isValid(n2);
    }

    @Override
    public boolean isValid() throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        return this.getUPC().isValid();
    }

    @Override
    public void setInvalid() throws SQLException {
        this.getUPC().heartbeat();
        try {
            this.getUPC().setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            throw new SQLException(universalConnectionPoolException);
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.closed.get()) {
            return true;
        }
        return this.getDelegate().isClosed();
    }

    @Override
    public boolean isLogicallyClosed() {
        return this.closed.get();
    }

    @Override
    public void applyConnectionLabel(String string, String string2) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().applyConnectionLabel(string, string2);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(32, universalConnectionPoolException);
        }
    }

    @Override
    public void removeConnectionLabel(String string) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().removeConnectionLabel(string);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(33, universalConnectionPoolException);
        }
    }

    @Override
    public Properties getConnectionLabels() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        Properties properties = null;
        try {
            properties = this.getUPC().getConnectionLabels();
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(34, universalConnectionPoolException);
        }
        return properties;
    }

    @Override
    public Properties getUnmatchedConnectionLabels(Properties properties) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        Properties properties2 = null;
        try {
            properties2 = this.getUPC().getUnmatchedConnectionLabels(properties);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(35, universalConnectionPoolException);
        }
        return properties2;
    }

    @Override
    public void setConnectionHarvestable(boolean bl2) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().setConnectionHarvestable(bl2);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(36, universalConnectionPoolException);
        }
    }

    @Override
    public boolean isConnectionHarvestable() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        return this.getUPC().isConnectionHarvestable();
    }

    @Override
    public void registerConnectionHarvestingCallback(ConnectionHarvestingCallback connectionHarvestingCallback) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().registerConnectionHarvestingCallback(connectionHarvestingCallback);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(37, universalConnectionPoolException);
        }
    }

    @Override
    public void removeConnectionHarvestingCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().removeConnectionHarvestingCallback();
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(38, universalConnectionPoolException);
        }
    }

    @Override
    public void registerAbandonedConnectionTimeoutCallback(AbandonedConnectionTimeoutCallback abandonedConnectionTimeoutCallback) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().registerAbandonedConnectionTimeoutCallback(abandonedConnectionTimeoutCallback);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(39, universalConnectionPoolException);
        }
    }

    @Override
    public void removeAbandonedConnectionTimeoutCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().removeAbandonedConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(40, universalConnectionPoolException);
        }
    }

    @Override
    public void registerTimeToLiveConnectionTimeoutCallback(TimeToLiveConnectionTimeoutCallback timeToLiveConnectionTimeoutCallback) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().registerTimeToLiveConnectionTimeoutCallback(timeToLiveConnectionTimeoutCallback);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(41, universalConnectionPoolException);
        }
    }

    @Override
    public void removeTimeToLiveConnectionTimeoutCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        try {
            this.getUPC().removeTimeToLiveConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(42, universalConnectionPoolException);
        }
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.getDelegate().equals(object instanceof ConnectionProxy ? ((ConnectionProxy)object).getDelegate() : object);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    protected void saveStatementProxy(Object object) {
        if (object instanceof StatementProxy) {
            StatementProxy statementProxy = (StatementProxy)object;
            statementProxy.setStatementChainAtom(this.statementsToClose.add(statementProxy));
        }
    }
}

