/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.other;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.Clock;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.other.ConnectionProxy;
import oracle.ucp.jdbc.proxy.other.StatementProxy;
import oracle.ucp.proxy.annotation.GetCreator;
import oracle.ucp.proxy.annotation.GetDelegate;
import oracle.ucp.proxy.annotation.OnError;
import oracle.ucp.proxy.annotation.Pre;
import oracle.ucp.proxy.annotation.ProxyFor;
import oracle.ucp.proxy.annotation.ProxyResult;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import oracle.ucp.util.Chain;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
@ProxyFor(value={ResultSet.class, LogicalObject.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class ResultSetProxy
implements LogicalObject {
    private final long creationTS = Clock.clock();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private Chain.Atom<ResultSetProxy> resultSetChainAtom = null;

    void setResultSetChainAtom(Chain.Atom<ResultSetProxy> atom) {
        this.resultSetChainAtom = atom;
    }

    @GetDelegate
    protected abstract ResultSet getDelegate();

    @GetCreator
    protected abstract Object getCreator();

    private UniversalPooledConnection getUPC() {
        return ((StatementProxy)this.getCreator()).getUPC();
    }

    private UniversalConnectionPool getUCP() {
        return ((StatementProxy)this.getCreator()).getUCP();
    }

    private void throwIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw UCPErrorHandler.newSQLException(43);
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Statement getStatement() throws SQLException {
        this.getUPC().heartbeat();
        this.throwIfClosed();
        return (Statement)this.getCreator();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int n2) throws SQLException {
        this.getUPC().heartbeat();
        this.throwIfClosed();
        return this.getDelegate().getObject(n2);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int n2, Class clazz) throws SQLException {
        this.getUPC().heartbeat();
        this.throwIfClosed();
        return this.getDelegate().getObject(n2, clazz);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int n2, Map map) throws SQLException {
        this.getUPC().heartbeat();
        this.throwIfClosed();
        return this.getDelegate().getObject(n2, map);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String string) throws SQLException {
        this.getUPC().heartbeat();
        this.throwIfClosed();
        return this.getDelegate().getObject(string);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String string, Class clazz) throws SQLException {
        this.getUPC().heartbeat();
        this.throwIfClosed();
        return this.getDelegate().getObject(string, clazz);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String string, Map map) throws SQLException {
        this.getUPC().heartbeat();
        this.throwIfClosed();
        return this.getDelegate().getObject(string, map);
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.resultSetChainAtom.remove();
        this.closed.set(true);
        this.getDelegate().close();
    }

    public boolean isClosed() throws SQLException {
        return this.closed.get() || ((Statement)this.getCreator()).isClosed();
    }

    @Override
    public boolean isLogicallyClosed() {
        return this.closed.get();
    }

    @Pre
    protected void pre(Method method, Object object, Object ... objectArray) throws SQLException {
        StatementProxy statementProxy;
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(43);
        }
        this.getUPC().heartbeat();
        if (Clock.isBefore(this.creationTS, this.getUPC().getAvailableStartTime()) || Clock.isBefore(this.creationTS, this.getUPC().getBorrowedStartTime())) {
            this.closed.set(true);
            ((Statement)this.getCreator()).getConnection().close();
        }
        if ((statementProxy = (StatementProxy)this.getCreator()).isLogicallyClosed()) {
            throw UCPErrorHandler.newSQLException(44);
        }
        ConnectionProxy connectionProxy = (ConnectionProxy)statementProxy.getCreator();
        if (connectionProxy.isLogicallyClosed()) {
            throw UCPErrorHandler.newSQLException(31);
        }
    }

    @OnError(value=SQLException.class)
    protected void onErrorvoid(Method method, SQLException sQLException) throws SQLException {
        this.onError(method, sQLException);
    }

    @OnError(value=SQLException.class)
    protected Object onError(Method method, SQLException sQLException) throws SQLException {
        this.getUPC().heartbeat();
        StatementProxy statementProxy = (StatementProxy)this.getCreator();
        ConnectionProxy connectionProxy = (ConnectionProxy)statementProxy.getCreator();
        connectionProxy.handleSQRecoverableException(sQLException);
        throw sQLException;
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        this.getUPC().heartbeat();
        if (clazz.isInterface()) {
            if (clazz.isInstance(this.getDelegate())) {
                return (T)this.getDelegate();
            }
            return this.getDelegate().unwrap(clazz);
        }
        throw new SQLException("unable to unwrap interface " + clazz.toString());
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.getDelegate().equals(object instanceof ResultSetProxy ? ((ResultSetProxy)object).getDelegate() : object);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }
}

