/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.proxy;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.proxy.HashUtil;

@DisableTrace
class GeneratedProxiesRegistry {
    private Map<Key, Value> registry = new ConcurrentHashMap<Key, Value>();

    GeneratedProxiesRegistry() {
    }

    void put(String string, Class clazz, Class clazz2, Value value) {
        this.registry.put(new Key(string, clazz, clazz2), value);
    }

    Value get(String string, Class clazz, Class clazz2) {
        return this.registry.get(new Key(string, clazz, clazz2));
    }

    int size() {
        return this.registry.size();
    }

    Set<Key> keySet() {
        return this.registry.keySet();
    }

    Collection<Value> values() {
        return this.registry.values();
    }

    @DisableTrace
    static class Value {
        private final String name;
        private final String source;
        private final Class clazz;
        private final Constructor constructor;

        Value(String string, String string2, Class clazz, Constructor constructor) {
            this.name = string;
            this.source = string2;
            this.clazz = clazz;
            this.constructor = constructor;
        }

        String getName() {
            return this.name;
        }

        String getSource() {
            return this.source;
        }

        Class getClazz() {
            return this.clazz;
        }

        Constructor getConstructor() {
            return this.constructor;
        }
    }

    @DisableTrace
    static class Key {
        private final String proxyPackage;
        private static final String SUFFIX = "$$$Proxy";
        private final Class iface;
        private final Class superclass;
        private Integer hashCode = null;

        Key(String string, Class clazz, Class clazz2) {
            this.proxyPackage = Key.endWithDot(string);
            this.iface = clazz;
            this.superclass = clazz2;
        }

        Key(String string, String string2) {
            this(string, Key.parseIface(string, string2), Key.parseSuperclass(string, string2));
        }

        private static String endWithDot(String string) {
            return string.endsWith(".") ? string : string + ".";
        }

        public boolean equals(Object object) {
            if (null == object) {
                return false;
            }
            try {
                Key key = (Key)object;
                return this.iface.equals(key.iface) && this.superclass.equals(key.superclass);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            if (null == this.hashCode) {
                this.hashCode = 23;
                this.hashCode = HashUtil.hash((int)this.hashCode, this.iface);
                this.hashCode = HashUtil.hash((int)this.hashCode, this.superclass);
            }
            return this.hashCode;
        }

        public String toString() {
            return this.proxyPackage + this.superclass.getName().replace(".", "$1") + "$2" + this.iface.getName().replace(".", "$1") + SUFFIX;
        }

        private static Class parseSuperclass(String string, String string2) {
            try {
                String string3 = string2.substring(string.length());
                String string4 = string3.replaceAll("\\$1", ".");
                String string5 = string4.substring(0, string4.indexOf("$2"));
                return Class.forName(string5);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
        }

        private static Class parseIface(String string, String string2) {
            try {
                String string3 = string2.substring(string.length());
                String string4 = string3.replaceAll("\\$1", ".");
                String string5 = string4.substring(string4.indexOf("$2") + 2, string4.indexOf(SUFFIX));
                return Class.forName(string5);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
        }

        public Class getIface() {
            return this.iface;
        }

        public Class getSuperclass() {
            return this.superclass;
        }

        public String makePathname() {
            return this.toString().replace(".", "/") + ".class";
        }
    }
}

