/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.routing.ShardingKeys;

class HashRangeShardingKeys
implements ShardingKeys {
    private final OracleShardingKey keyLowHash;
    private final OracleShardingKey keyHighHash;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    HashRangeShardingKeys(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2) {
        this.keyLowHash = oracleShardingKey2;
        this.keyHighHash = oracleShardingKey;
    }

    @Override
    public boolean contains(OracleShardingKey oracleShardingKey) {
        return oracleShardingKey.compareTo(this.keyHighHash) < 0 && oracleShardingKey.compareTo(this.keyLowHash) >= 0;
    }

    @DisableTrace
    public String toString() {
        return "{Low:" + this.keyLowHash + ", High:" + this.keyHighHash + "}";
    }

    public int hashCode() {
        return 31 * this.keyLowHash.hashCode() + this.keyHighHash.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof HashRangeShardingKeys)) {
            return false;
        }
        HashRangeShardingKeys hashRangeShardingKeys = (HashRangeShardingKeys)object;
        return this.keyLowHash.equals(hashRangeShardingKeys.keyLowHash) && this.keyHighHash.equals(hashRangeShardingKeys.keyHighHash);
    }

    @Override
    public int compareTo(ShardingKeys shardingKeys) {
        HashRangeShardingKeys hashRangeShardingKeys = (HashRangeShardingKeys)shardingKeys;
        int n2 = this.keyLowHash.compareTo(hashRangeShardingKeys.keyLowHash);
        if (n2 != 0) {
            return n2;
        }
        return this.keyHighHash.compareTo(hashRangeShardingKeys.keyHighHash);
    }

    List<ShardingKeys> split(OracleShardingKey oracleShardingKey) {
        ArrayList<ShardingKeys> arrayList = new ArrayList<ShardingKeys>(2);
        arrayList.add(new HashRangeShardingKeys(oracleShardingKey, this.keyLowHash));
        arrayList.add(new HashRangeShardingKeys(this.keyHighHash, oracleShardingKey));
        return arrayList;
    }

    static {
        try {
            $$$methodRef$$$5 = HashRangeShardingKeys.class.getDeclaredConstructor(OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = HashRangeShardingKeys.class.getDeclaredMethod("split", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = HashRangeShardingKeys.class.getDeclaredMethod("compareTo", ShardingKeys.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = HashRangeShardingKeys.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = HashRangeShardingKeys.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = HashRangeShardingKeys.class.getDeclaredMethod("contains", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

