/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.lang.reflect.Executable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import oracle.ucp.common.ServiceMember;

class InstanceSet {
    static final InstanceSet EMPTY;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock rLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.rwLock.writeLock();
    private final Set<ServiceMember> instanceSet = new HashSet<ServiceMember>();
    private final AtomicReference<Set<ServiceMember>> instanceSetSnapshot = new AtomicReference<Set<ServiceMember>>(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.instanceSet)));
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    InstanceSet() {
    }

    void add(ServiceMember serviceMember) {
        if (null == serviceMember) {
            throw new IllegalArgumentException();
        }
        this.wLock.lock();
        try {
            this.instanceSet.add(serviceMember);
            this.instanceSetSnapshot.set(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.instanceSet)));
        }
        finally {
            this.wLock.unlock();
        }
    }

    void remove(ServiceMember serviceMember) {
        if (null == serviceMember) {
            throw new IllegalArgumentException();
        }
        this.wLock.lock();
        try {
            this.instanceSet.remove(serviceMember);
            this.instanceSetSnapshot.set(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.instanceSet)));
        }
        finally {
            this.wLock.unlock();
        }
    }

    Set<ServiceMember> allInstances() {
        return this.instanceSetSnapshot.get();
    }

    static {
        try {
            $$$methodRef$$$3 = InstanceSet.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = InstanceSet.class.getDeclaredMethod("allInstances", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = InstanceSet.class.getDeclaredMethod("remove", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = InstanceSet.class.getDeclaredMethod("add", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        EMPTY = new InstanceSet();
    }
}

