/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleType;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleShardingKeyBuilderImpl;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.routing.Chunk;
import oracle.ucp.routing.HashRangeShardingKeys;
import oracle.ucp.routing.ShardRoutingCache;
import oracle.ucp.routing.SuperShardingKeys;

@DefaultLogger(value="oracle.ucp.jdbc.routing")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public abstract class RACDataAffinityRoutingCache
extends ShardRoutingCache {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    @Override
    protected ShardRoutingCache.RoutingKey makeRoutingKey(Chunk.Metadata metadata) throws SQLException {
        SuperShardingKeys superShardingKeys = SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS;
        OracleShardingKeyImpl oracleShardingKeyImpl = new OracleShardingKeyBuilderImpl().subkey(metadata.chunkId, OracleType.NUMBER).build();
        HashRangeShardingKeys hashRangeShardingKeys = new HashRangeShardingKeys(oracleShardingKeyImpl, oracleShardingKeyImpl);
        return new ShardRoutingCache.RoutingKey(hashRangeShardingKeys, superShardingKeys);
    }

    @Override
    protected boolean entryContainsRoutingKey(Map.Entry<ShardRoutingCache.RoutingKey, Chunk> entry, OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2, OracleShardingKey oracleShardingKey3) {
        long l2 = this.getChunkId(oracleShardingKey);
        return (long)entry.getValue().Id().get() == l2;
    }

    @Override
    protected boolean hasKeyMapped(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2) {
        return true;
    }

    private long getChunkId(OracleShardingKey oracleShardingKey) {
        long l2 = this.chunksCount();
        long l3 = 1L;
        long l4 = l2;
        while ((l4 >>= 1) > 0L) {
            l3 <<= 1;
        }
        l3 = (l3 << 1) - 1L;
        long l5 = ((OracleShardingKeyImpl)oracleShardingKey).shardKeyOraHash(this.shardingMetadata());
        long l6 = l5 & l3;
        if (l6 >= l2) {
            l6 = l5 & l3 >> 1;
        }
        return l6 + 1L;
    }

    @Override
    public ServiceMember getBestInstanceToGrow(ConnectionRetrievalInfo connectionRetrievalInfo) {
        return this.getAffinitizedInstance(connectionRetrievalInfo);
    }

    @Override
    public Set<ServiceMember> instancesToGrow(ConnectionRetrievalInfo connectionRetrievalInfo) {
        return this.allInstances(connectionRetrievalInfo);
    }

    @Override
    public Set<ServiceMember> allInstances(ConnectionRetrievalInfo connectionRetrievalInfo) {
        HashSet<ServiceMember> hashSet = new HashSet<ServiceMember>();
        ServiceMember serviceMember = this.getAffinitizedInstance(connectionRetrievalInfo);
        if (serviceMember != null) {
            hashSet.add(serviceMember);
        }
        return hashSet;
    }

    @Override
    public Set<ServiceMember> allPriorityInstances(ConnectionRetrievalInfo connectionRetrievalInfo) {
        return this.allInstances(connectionRetrievalInfo);
    }

    private ServiceMember getAffinitizedInstance(ConnectionRetrievalInfo connectionRetrievalInfo) {
        List<Chunk> list = this.chunks(connectionRetrievalInfo);
        if (list != null && list.size() > 0) {
            for (Chunk chunk : list) {
                Set<ServiceMember> set = chunk.instances();
                for (ServiceMember serviceMember : set) {
                    if (serviceMember.dbInstanceId() != chunk.affinitizedInstId().get()) continue;
                    return serviceMember;
                }
            }
        }
        return null;
    }

    static {
        try {
            $$$methodRef$$$9 = RACDataAffinityRoutingCache.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$8 = RACDataAffinityRoutingCache.class.getDeclaredMethod("getAffinitizedInstance", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$7 = RACDataAffinityRoutingCache.class.getDeclaredMethod("allPriorityInstances", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$6 = RACDataAffinityRoutingCache.class.getDeclaredMethod("allInstances", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$5 = RACDataAffinityRoutingCache.class.getDeclaredMethod("instancesToGrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$4 = RACDataAffinityRoutingCache.class.getDeclaredMethod("getBestInstanceToGrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$3 = RACDataAffinityRoutingCache.class.getDeclaredMethod("getChunkId", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$2 = RACDataAffinityRoutingCache.class.getDeclaredMethod("hasKeyMapped", OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$1 = RACDataAffinityRoutingCache.class.getDeclaredMethod("entryContainsRoutingKey", Map.Entry.class, OracleShardingKey.class, OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$0 = RACDataAffinityRoutingCache.class.getDeclaredMethod("makeRoutingKey", Chunk.Metadata.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
    }
}

