/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.io.InputStream;
import java.lang.reflect.Executable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleType;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleShardingKeyBuilderImpl;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.jdbc.pool.ShardingMetadata;
import oracle.sql.SQLUtil;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.FailoverDriver;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.routing.Chunk;
import oracle.ucp.routing.ChunkEventHandler;
import oracle.ucp.routing.DataDependentRoutingCache;
import oracle.ucp.routing.HashRangeShardingKeys;
import oracle.ucp.routing.ListShardingKeys;
import oracle.ucp.routing.ListSuperShardingKeys;
import oracle.ucp.routing.RangeShardingKeys;
import oracle.ucp.routing.RangeSuperShardKeys;
import oracle.ucp.routing.ShardRoutingCacheBase;
import oracle.ucp.routing.ShardingKeys;
import oracle.ucp.routing.SuperShardingKeys;
import oracle.ucp.util.MappedLongAdder;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.jdbc.routing")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public abstract class ShardRoutingCache
extends ShardRoutingCacheBase
implements DataDependentRoutingCache {
    private final Map<L2RoutingKey, List<Chunk>> l2RoutingCache = new ConcurrentHashMap<L2RoutingKey, List<Chunk>>();
    private final Map<OracleShardingKey, OracleShardingKey> lookupKeyCache = new ConcurrentHashMap<OracleShardingKey, OracleShardingKey>();
    protected final ChunkEventHandler chunkEventHandler = this.prepareChunkEventHandler();
    protected final AtomicReference<ShardingMetadata> shardingMetadata = new AtomicReference<Object>(null);
    private final MappedLongAdder<String> shardConnectionCounter = new MappedLongAdder();
    private final MappedLongAdder<String> shardPendingConnectionCounter = new MappedLongAdder();
    private final Map<String, String> currentActiveShards = new ConcurrentHashMap<String, String>();
    private static final short DB_VERSION_19c = 19000;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;

    private RoutingKey routingKeysForVersionedChunk(String string) {
        Optional optional = this.keyForChunk(string).stream().findFirst();
        return optional.isPresent() ? (RoutingKey)optional.get() : null;
    }

    protected boolean hasKeyMapped(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2) {
        L2RoutingKey l2RoutingKey = new L2RoutingKey(oracleShardingKey, oracleShardingKey2);
        if (this.l2RoutingCache.containsKey(l2RoutingKey)) {
            return true;
        }
        OracleShardingKey oracleShardingKey3 = this.lookupKey(oracleShardingKey);
        NavigableSet<RoutingKey> navigableSet = this.allKeys();
        for (RoutingKey routingKey : navigableSet) {
            if (!routingKey.containsShardingKey(oracleShardingKey3, oracleShardingKey2)) continue;
            return true;
        }
        return false;
    }

    private Chunk update(RoutingKey routingKey, String string) {
        if (routingKey == null || string == null || string.equals("")) {
            return null;
        }
        Chunk chunk3 = new Chunk(string);
        Chunk chunk4 = this.get(routingKey);
        if (chunk4 != null && !chunk4.name().equals(string)) {
            ClioSupport.ilogFinest(null, null, null, null, "Replace chunk for key:" + routingKey + " with new Chunk:" + string + " , (old chunk:" + chunk4.name() + ")");
            this.replace(routingKey, chunk4, chunk3);
            this.l2RoutingCache.clear();
            return chunk4;
        }
        if (chunk4 == null) {
            RoutingKey routingKey2 = this.routingKeysForVersionedChunk(string);
            if (this.putIfAbsent(routingKey, chunk3) == null) {
                this.l2RoutingCache.clear();
                if (routingKey2 != null && !routingKey.equals(routingKey2)) {
                    int n2 = ((Chunk)this.chunks(string).stream().max((chunk, chunk2) -> chunk.version() - chunk2.version()).get()).version();
                    this.get(routingKey2).setVersion(n2 + 1);
                    ClioSupport.ilogFinest(null, null, null, null, "Chunk keys:" + routingKey2 + " has split,hence updated chunk name to:" + this.get(routingKey2).name());
                }
            }
        }
        return this.get(routingKey);
    }

    @Override
    public void onConnectionBorrow(Connection connection, ConnectionRetrievalInfo connectionRetrievalInfo) throws SQLException {
        if (!(connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo)) {
            return;
        }
        JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
        OracleShardingKey oracleShardingKey = jDBCConnectionRetrievalInfo.getShardingKey();
        OracleShardingKey oracleShardingKey2 = jDBCConnectionRetrievalInfo.getSuperShardingKey();
        OracleConnection oracleConnection = (OracleConnection)connection;
        if (oracleConnection != null && jDBCConnectionRetrievalInfo.getShardingKey() != null) {
            String string = this.getChunkNameForKey(jDBCConnectionRetrievalInfo);
            oracleConnection.setChunkInfo(oracleShardingKey, oracleShardingKey2, string);
        }
        if (oracleShardingKey != null) {
            this.lookupKeyCache.remove(oracleShardingKey);
        }
        this.l2RoutingCache.remove(new L2RoutingKey(oracleShardingKey, oracleShardingKey2));
    }

    protected void cleanup() {
        Set<Chunk> set = this.noInstsChunks();
        set.forEach(chunk -> this.remove((Chunk)chunk));
        if (set.size() > 0) {
            this.l2RoutingCache.clear();
            ClioSupport.ilogFinest(null, null, null, null, "Cleaned up shard routing cache!");
        }
    }

    protected void clearCache() {
        this.lookupKeyCache.clear();
        this.l2RoutingCache.clear();
        super.clear();
    }

    protected boolean isMaxPerShardReached(ServiceMember serviceMember) {
        String string = serviceMember.dbUniqueId();
        if (string == null || string.equals("")) {
            return false;
        }
        int n2 = this.service().connectionSource().limits().getMaxPerShard();
        return this.shardConnectionCounter.get(string).sum() + this.shardPendingConnectionCounter.get(string).sum() >= (long)n2;
    }

    boolean isMaxPerShardConfigured() {
        int n2 = this.service().connectionSource().limits().getMaxPerShard();
        return n2 < Integer.MAX_VALUE;
    }

    @Override
    public void onConnectionRequest(ServiceMember serviceMember) {
        String string = serviceMember.dbUniqueId();
        if (string == null || string.equals("")) {
            return;
        }
        this.shardPendingConnectionCounter.get(string).increment();
    }

    @Override
    public void onConnectionRequestComplete(ServiceMember serviceMember) {
        String string = serviceMember.dbUniqueId();
        if (string == null || string.equals("")) {
            return;
        }
        this.shardPendingConnectionCounter.get(string).decrement();
    }

    @Override
    public ServiceMember getBestInstanceToGrow(ConnectionRetrievalInfo connectionRetrievalInfo) {
        return this.instancesToGrow(connectionRetrievalInfo).stream().sorted((serviceMember, serviceMember2) -> serviceMember.activeCount.get() - serviceMember2.activeCount.get()).findFirst().orElse(null);
    }

    @Override
    public void onConnectionCreation(Connection connection, ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        if (!(connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo)) {
            return;
        }
        try {
            Chunk chunk;
            String string = this.service().connectionSource().defaultServiceName();
            if (this.shardingMetadata.get() == null) {
                this.shardingMetadata.compareAndSet(null, ShardRoutingCache.fetchShardingMetadata(connection, string));
            }
            ServiceMember serviceMember = this.getConnectionInstance(connection);
            String string2 = serviceMember.dbUniqueId();
            String string3 = ShardRoutingCache.getShardNameFromConnection(connection);
            if (this.isMaxPerShardReached(serviceMember)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(389);
            }
            this.shardConnectionCounter.get(string2).increment();
            this.currentActiveShards.putIfAbsent(string2, string3);
            JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
            ClioSupport.ilogFinest(null, null, null, null, String.format("\n\tCreating connection with OracleShardingKey(%s,%s)\n", jDBCConnectionRetrievalInfo.getShardingKey(), jDBCConnectionRetrievalInfo.getSuperShardingKey()));
            if (!this.allInstances(jDBCConnectionRetrievalInfo).contains(serviceMember)) {
                this.buildTopologyForInstance(connection, string);
                return;
            }
            if (jDBCConnectionRetrievalInfo.getShardingKey() == null) {
                return;
            }
            String string4 = ShardRoutingCache.fetchDatabaseChunkName(connection);
            String string5 = this.getChunkNameForKey(jDBCConnectionRetrievalInfo);
            if (string5 == null) {
                this.buildTopologyForInstance(connection, string);
                return;
            }
            if (string4 == null) {
                return;
            }
            RoutingKey routingKey = this.routingKeysForVersionedChunk(string4);
            Chunk.Metadata metadata = null;
            if (routingKey == null) {
                metadata = ShardRoutingCache.fetchChunkMetadata(connection, string4, string);
                if (metadata == null) {
                    return;
                }
                routingKey = this.makeRoutingKey(metadata);
            }
            if ((chunk = this.update(routingKey, string4)) != null && !chunk.hasInstance(serviceMember)) {
                if (metadata == null) {
                    metadata = ShardRoutingCache.fetchChunkMetadata(connection, string4, string);
                }
                chunk.addInstanceWithPriority(serviceMember, metadata.priority);
                chunk.setAffinitizedInstId(metadata.affinitizedInstId);
                chunk.setId(metadata.chunkId);
                chunk.setUniqueId(metadata.chunkUniqueId);
                chunk.addShardInfo(metadata.shardName, metadata.priority);
            }
        }
        catch (SQLException sQLException) {
            ClioSupport.ilogThrowing(null, null, null, null, sQLException);
        }
    }

    private static String getShardNameFromConnection(Connection connection) throws SQLException {
        return ((OracleConnection)connection).getServerSessionInfo().getProperty("AUTH_DBNAME", "");
    }

    protected ServiceMember getConnectionInstance(Connection connection) {
        ServiceMember serviceMember = null;
        try {
            Properties properties = ((OracleConnection)connection).getServerSessionInfo();
            if (this.service() != null) {
                serviceMember = this.service().getMember(properties.getProperty("INSTANCE_NAME"), properties.getProperty("DATABASE_NAME"), properties.getProperty("SERVER_HOST"), properties.getProperty("SERVICE_NAME"));
            }
            if (serviceMember == null) {
                serviceMember = new ServiceMember(properties, this.service());
            }
        }
        catch (SQLException sQLException) {
            ClioSupport.ilogThrowing(null, null, null, null, sQLException);
        }
        return serviceMember;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String fetchDatabaseChunkName(Connection connection) {
        if (connection == null) {
            return null;
        }
        String string = "select sys_context('userenv', 'chunk_id') from dual";
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select sys_context('userenv', 'chunk_id') from dual");){
            if (!resultSet.next()) return null;
            String string2 = resultSet.getString(1);
            String string3 = string2 != null ? string2.toLowerCase() : null;
            return string3;
        }
        catch (SQLException sQLException) {
            ClioSupport.ilogThrowing(null, null, null, null, sQLException);
        }
        return null;
    }

    private String getChunkNameForKey(ConnectionRetrievalInfo connectionRetrievalInfo) {
        List<Chunk> list = this.chunks(connectionRetrievalInfo);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0).absoluteName();
    }

    @Override
    public void onConnectionClosure(Connection connection) {
        String string = this.getConnectionInstance(connection).dbUniqueId();
        this.shardConnectionCounter.get(string).decrement();
    }

    protected void buildTopologyForInstance(Connection connection, String string) {
        try {
            ServiceMember serviceMember = this.getConnectionInstance(connection);
            ClioSupport.ilogFinest(null, null, null, null, "Building topo for Instance " + serviceMember.name());
            List<Chunk.Metadata> list = ShardRoutingCache.fetchInstanceChunksMetadata(connection, string);
            for (Chunk.Metadata metadata : list) {
                String string2 = metadata.chunkName;
                RoutingKey routingKey = this.makeRoutingKey(metadata);
                if (this.update(routingKey, string2) == null) continue;
                Chunk chunk = this.get(routingKey);
                chunk.addInstanceWithPriority(serviceMember, metadata.priority);
                chunk.setAffinitizedInstId(metadata.affinitizedInstId);
                chunk.setId(metadata.chunkId);
                chunk.setUniqueId(metadata.chunkUniqueId);
                if (metadata.shardName == null) continue;
                chunk.addShardInfo(metadata.shardName, metadata.priority);
            }
        }
        catch (SQLException sQLException) {
            ClioSupport.ilogThrowing(null, null, null, null, sQLException);
        }
    }

    protected abstract Service service();

    protected ShardingMetadata shardingMetadata() {
        return this.shardingMetadata.get();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected RoutingKey makeRoutingKey(Chunk.Metadata metadata) throws SQLException {
        void var6_9;
        SuperShardingKeys superShardingKeys;
        ShardingMetadata shardingMetadata = this.shardingMetadata();
        ShardingMetadata.ShardingType shardingType = this.shardingMetadata().getSuperShardingType();
        if (shardingType != ShardingMetadata.ShardingType.NONE) {
            if (shardingType == ShardingMetadata.ShardingType.LIST) {
                superShardingKeys = new ListSuperShardingKeys(OracleShardingKeyImpl.decodeKeys(metadata.superKeyHigh, shardingMetadata, true, true));
            } else {
                if (shardingType != ShardingMetadata.ShardingType.RANGE) throw new IllegalStateException("Super Shard Type in database not recognized");
                superShardingKeys = new RangeSuperShardKeys(OracleShardingKeyImpl.decodeKeys(metadata.superKeyHigh, shardingMetadata, true, true).get(0), OracleShardingKeyImpl.decodeKeys(metadata.superKeyLow, shardingMetadata, true, false).get(0));
            }
        } else {
            superShardingKeys = SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS;
        }
        ShardingMetadata.ShardingType shardingType2 = this.shardingMetadata().getShardingType();
        if (shardingType2 == ShardingMetadata.ShardingType.LIST) {
            ListShardingKeys listShardingKeys = new ListShardingKeys(OracleShardingKeyImpl.decodeKeys(metadata.shardKeyHigh, shardingMetadata, false, true));
            return new RoutingKey((ShardingKeys)var6_9, superShardingKeys);
        } else if (shardingType2 == ShardingMetadata.ShardingType.RANGE) {
            RangeShardingKeys rangeShardingKeys = new RangeShardingKeys(OracleShardingKeyImpl.decodeKeys(metadata.shardKeyHigh, shardingMetadata, false, true).get(0), OracleShardingKeyImpl.decodeKeys(metadata.shardKeyLow, shardingMetadata, false, false).get(0));
            return new RoutingKey((ShardingKeys)var6_9, superShardingKeys);
        } else {
            if (shardingType2 != ShardingMetadata.ShardingType.HASH) throw new IllegalStateException("Shard Type in database not recognized");
            HashRangeShardingKeys hashRangeShardingKeys = new HashRangeShardingKeys(OracleShardingKeyImpl.decodeKeys(metadata.shardKeyHigh, shardingMetadata, false, true).get(0), OracleShardingKeyImpl.decodeKeys(metadata.shardKeyLow, shardingMetadata, false, false).get(0));
        }
        return new RoutingKey((ShardingKeys)var6_9, superShardingKeys);
    }

    @Override
    public void startEventHandler(ONSDriver oNSDriver) throws UniversalConnectionPoolException {
        if (oNSDriver != null) {
            this.chunkEventHandler.start(oNSDriver);
        }
    }

    private Chunk matchingChunk(String string, ServiceMember serviceMember) {
        Optional optional = this.chunks(serviceMember, string).stream().findFirst();
        return optional.isPresent() ? (Chunk)optional.get() : null;
    }

    private boolean hasMatchingChunk(String string, ServiceMember serviceMember) {
        return this.chunks(serviceMember, string).size() > 0;
    }

    private ChunkEventHandler prepareChunkEventHandler() {
        return new ChunkEventHandler(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            protected void onEvent(ChunkEventHandler.Event event) {
                ServiceMember serviceMember;
                if (event.eventType().equalsIgnoreCase("routing")) {
                    ShardRoutingCache.this.clearCache();
                    return;
                }
                if (!event.eventType().equalsIgnoreCase("chunk")) {
                    ClioSupport.ilogFinest(null, null, null, null, "Not chunk event , ignoring it");
                    return;
                }
                if (event.chunkName() == null || event.chunkName().length() <= 0) {
                    ClioSupport.ilogFinest(null, null, null, null, "Not applicable chunk event: Chunk name is empty, ignoring it");
                    return;
                }
                ServiceMember serviceMember2 = ShardRoutingCache.this.service().getMember(event.instanceName(), event.database(), ShardRoutingCache.this.service().name());
                if (serviceMember2 == null) {
                    ClioSupport.ilogFinest(null, null, null, null, "Not applicable chunk event: Instance name not known or null, ignoring it");
                    return;
                }
                ServiceMember serviceMember3 = serviceMember = event.status() == ChunkEventHandler.Event.Status.UP ? null : serviceMember2;
                if (!ShardRoutingCache.this.hasMatchingChunk(event.chunkName(), serviceMember)) {
                    ClioSupport.ilogFinest(null, null, null, null, "Not applicable chunk event:Chunk not known, ignoring it");
                    return;
                }
                Chunk chunk = ShardRoutingCache.this.matchingChunk(event.chunkName(), serviceMember);
                if (chunk == null) {
                    return;
                }
                boolean bl2 = Boolean.valueOf(Util.getReadOnlyInstanceAllowed());
                if ((event.status() == ChunkEventHandler.Event.Status.DOWN || !bl2 && event.status() == ChunkEventHandler.Event.Status.READONLY) && chunk.hasInstance(serviceMember2)) {
                    ClioSupport.ilogFinest(null, null, null, null, "Chunk Event Handler : Removed Instance " + serviceMember2 + " for Chunk :" + chunk.name());
                    chunk.removeInstance(serviceMember2);
                }
                if (event.status() == ChunkEventHandler.Event.Status.UP) {
                    chunk.addInstanceWithPriority(serviceMember2, event.priority());
                }
                if (event.status() == ChunkEventHandler.Event.Status.SPLIT && chunk.hasInstance(serviceMember2)) {
                    ClioSupport.ilogFinest(null, null, null, null, "Chunk Event Handler : Removed Instance " + serviceMember2 + " for Chunk :" + chunk.name());
                    int n2 = chunk.instancePriority(serviceMember2);
                    chunk.removeInstance(serviceMember2);
                    if (ShardRoutingCache.this.shardingMetadata().getShardingType() == ShardingMetadata.ShardingType.HASH) {
                        RoutingKey routingKey;
                        RoutingKey routingKey2 = ShardRoutingCache.this.routingKeysForVersionedChunk(chunk.name());
                        OracleShardingKeyImpl oracleShardingKeyImpl = new OracleShardingKeyBuilderImpl().subkey(event.hashSplitBoundary(), OracleType.NUMBER).build();
                        List<ShardingKeys> list = ((HashRangeShardingKeys)routingKey2.shardingKeys).split(oracleShardingKeyImpl);
                        if (list.size() <= 0 && list.size() != 2) {
                            ClioSupport.ilogWarning(null, null, null, null, "Hash boundary could not be used to split the chunk");
                            ShardRoutingCache.this.cleanup();
                            return;
                        }
                        RoutingKey routingKey3 = new RoutingKey(list.get(0), routingKey2.superShardingKeys);
                        if (ShardRoutingCache.this.update(routingKey3, event.chunkName()) != null) {
                            ShardRoutingCache.this.get(routingKey3).addInstanceWithPriority(serviceMember2, n2);
                            ClioSupport.ilogFinest(null, null, null, null, " Added Routing key: " + routingKey3 + " for Chunk:" + ShardRoutingCache.this.get(routingKey3));
                        }
                        if (ShardRoutingCache.this.update(routingKey = new RoutingKey(list.get(1), routingKey2.superShardingKeys), event.newChunkName()) != null) {
                            ShardRoutingCache.this.get(routingKey).addInstanceWithPriority(serviceMember2, n2);
                            ClioSupport.ilogFinest(null, null, null, null, " Added Routing key: " + routingKey + " for Chunk:" + ShardRoutingCache.this.get(routingKey));
                        }
                    }
                }
                ShardRoutingCache.this.cleanup();
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(ShardRoutingCache.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("onEvent", ChunkEventHandler.Event.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public void onHAEvent(FailoverDriver.Event event) {
        ServiceMember serviceMember = this.service().getMember(event.instance(), event.database(), event.host(), event.serviceName());
        if (serviceMember != null) {
            this.chunks(serviceMember).forEach(chunk -> this.remove((Chunk)chunk));
        }
        this.cleanup();
    }

    @Override
    public boolean selected(CoreConnection coreConnection, Set<ServiceMember> set) {
        if (set == null || set.size() <= 0) {
            return false;
        }
        return set.contains(coreConnection.serviceMember());
    }

    protected List<Chunk> chunks(ConnectionRetrievalInfo connectionRetrievalInfo) {
        if (!(connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo)) {
            return new ArrayList<Chunk>();
        }
        JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
        OracleShardingKey oracleShardingKey = jDBCConnectionRetrievalInfo.getShardingKey();
        OracleShardingKey oracleShardingKey2 = jDBCConnectionRetrievalInfo.getSuperShardingKey();
        if (oracleShardingKey == null) {
            return null;
        }
        if (this.shardingMetadata() == null) {
            return null;
        }
        L2RoutingKey l2RoutingKey = new L2RoutingKey(oracleShardingKey, oracleShardingKey2);
        List<Chunk> list = this.l2RoutingCache.get(l2RoutingKey);
        if (list != null) {
            return list;
        }
        OracleShardingKey oracleShardingKey3 = this.lookupKey(oracleShardingKey);
        List<Chunk> list2 = this.keyToChunkMap().entrySet().stream().filter(entry -> this.entryContainsRoutingKey((Map.Entry<RoutingKey, Chunk>)entry, oracleShardingKey, oracleShardingKey3, oracleShardingKey2)).map(entry -> (Chunk)entry.getValue()).collect(Collectors.toList());
        if (!list2.isEmpty()) {
            this.l2RoutingCache.put(l2RoutingKey, list2);
        }
        return list2;
    }

    protected boolean entryContainsRoutingKey(Map.Entry<RoutingKey, Chunk> entry, OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2, OracleShardingKey oracleShardingKey3) {
        return entry.getKey().containsShardingKey(oracleShardingKey2, oracleShardingKey3);
    }

    private OracleShardingKey lookupKey(OracleShardingKey oracleShardingKey) {
        if (oracleShardingKey == null) {
            return null;
        }
        OracleShardingKey oracleShardingKey2 = oracleShardingKey;
        if (this.shardingMetadata().getShardingType() == ShardingMetadata.ShardingType.HASH) {
            OracleShardingKey oracleShardingKey3 = this.lookupKeyCache.get(oracleShardingKey);
            if (oracleShardingKey3 != null) {
                return oracleShardingKey3;
            }
            long l2 = ((OracleShardingKeyImpl)oracleShardingKey).shardKeyOraHash(this.shardingMetadata());
            oracleShardingKey2 = new OracleShardingKeyBuilderImpl().subkey(l2, OracleType.NUMBER).oraHash(l2).build();
            this.lookupKeyCache.putIfAbsent(oracleShardingKey, oracleShardingKey2);
        }
        return oracleShardingKey2;
    }

    @Override
    public boolean validateCri(ConnectionRetrievalInfo connectionRetrievalInfo) {
        if (!(connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo)) {
            return false;
        }
        JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
        if (jDBCConnectionRetrievalInfo.getShardingKey() == null) {
            return true;
        }
        if (this.shardingMetadata.get() == null) {
            return false;
        }
        OracleShardingKey oracleShardingKey = jDBCConnectionRetrievalInfo.getShardingKey();
        OracleShardingKey oracleShardingKey2 = jDBCConnectionRetrievalInfo.getSuperShardingKey();
        ShardingMetadata shardingMetadata = this.shardingMetadata.get();
        if (!((OracleShardingKeyImpl)oracleShardingKey).isValid(shardingMetadata)) {
            throw new IllegalArgumentException("Sharding Keys provided do not match the sharded database metadata");
        }
        if (oracleShardingKey2 != null && !((OracleShardingKeyImpl)oracleShardingKey2).isValid(shardingMetadata)) {
            throw new IllegalArgumentException("Super Sharding Keys provided do not match the sharded database metadata");
        }
        return this.hasKeyMapped(oracleShardingKey, oracleShardingKey2);
    }

    @Override
    public Set<ServiceMember> instancesToGrow(ConnectionRetrievalInfo connectionRetrievalInfo) {
        Set<ServiceMember> set = this.allPriorityInstances(connectionRetrievalInfo);
        if (set != null && set.size() >= 0) {
            return set.stream().filter(serviceMember -> !this.isMaxPerShardReached((ServiceMember)serviceMember)).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public boolean hasInstanceToGrow(ConnectionRetrievalInfo connectionRetrievalInfo) {
        Set<ServiceMember> set = this.allPriorityInstances(connectionRetrievalInfo);
        if (set != null && set.size() == 0) {
            return true;
        }
        return set.stream().anyMatch(serviceMember -> !this.isMaxPerShardReached((ServiceMember)serviceMember));
    }

    @Override
    public Set<ServiceMember> allPriorityInstances(ConnectionRetrievalInfo connectionRetrievalInfo) {
        List<Chunk> list = this.chunks(connectionRetrievalInfo);
        HashSet<ServiceMember> hashSet = new HashSet<ServiceMember>();
        if (list != null) {
            list.stream().forEach(chunk -> {
                Set<ServiceMember> set2 = chunk.priorityInstances();
                if (set2 != null && set2.size() > 0) {
                    hashSet.addAll(set2);
                }
            });
        }
        return hashSet;
    }

    @Override
    public Set<ServiceMember> allInstances(ConnectionRetrievalInfo connectionRetrievalInfo) {
        List<Chunk> list = this.chunks(connectionRetrievalInfo);
        HashSet<ServiceMember> hashSet = new HashSet<ServiceMember>();
        if (list != null) {
            list.stream().forEach(chunk -> {
                Set<ServiceMember> set2 = chunk.instances();
                if (set2 != null && set2.size() > 0) {
                    hashSet.addAll(set2);
                }
            });
        }
        return hashSet;
    }

    @Override
    @DisableTrace
    public String cacheEntries() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\t\t SHARD ROUTING CACHE \n\n \nSUPER SHARDING KEY\t\t SHARDING KEY\t\t\t\t\t\t\tCHUNK NAME \t\tINSTANCES\n\n" + this.keyToChunkMap().entrySet().stream().map(entry -> String.format("%-70s", entry.getKey()) + "\t\t" + ((Chunk)entry.getValue()).toString()).collect(Collectors.joining("\n")));
        return stringBuffer.toString();
    }

    @Override
    @DisableTrace
    public String metadataInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t\t SHARDING INFO:\n\tSuper Sharding Type :" + this.shardingMetadata().getSuperShardingType().toString());
        stringBuffer.append("\n\tSharding Type :" + this.shardingMetadata().getShardingType().toString());
        return stringBuffer.toString();
    }

    @Override
    public void destroy() {
        this.l2RoutingCache.clear();
        this.clear();
        this.chunkEventHandler.stop();
    }

    @Override
    public void onError(ConnectionRetrievalInfo connectionRetrievalInfo, ServiceMember serviceMember) {
        String string = this.getChunkNameForKey(connectionRetrievalInfo);
        Chunk chunk = this.matchingChunk(string, serviceMember);
        if (chunk != null) {
            chunk.removeInstance(serviceMember);
        }
        JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
        OracleShardingKey oracleShardingKey = jDBCConnectionRetrievalInfo.getShardingKey();
        OracleShardingKey oracleShardingKey2 = jDBCConnectionRetrievalInfo.getSuperShardingKey();
        if (oracleShardingKey != null) {
            this.lookupKeyCache.remove(oracleShardingKey);
        }
        this.l2RoutingCache.remove(new L2RoutingKey(oracleShardingKey, oracleShardingKey2));
        this.cleanup();
    }

    public String shardConnectionStats() {
        return "Shard Connection Stats for Service (<Shards:{connection count}) " + this.service().name() + this.currentActiveShards + ":{" + this.shardConnectionCounter + '}';
    }

    public boolean hasAvailableConnectionForKey(ConnectionRetrievalInfo connectionRetrievalInfo) {
        if (!(connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo)) {
            return false;
        }
        JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
        if (this.hasKeyMapped(jDBCConnectionRetrievalInfo.getShardingKey(), jDBCConnectionRetrievalInfo.getSuperShardingKey())) {
            return this.allInstances(jDBCConnectionRetrievalInfo).stream().anyMatch(serviceMember -> serviceMember.activeCount.get() - serviceMember.borrowedCount.get() > 0);
        }
        return false;
    }

    private static List<Chunk.Metadata> fetchInstanceChunksMetadata(Connection connection, String string) throws SQLException {
        if (connection == null) {
            return null;
        }
        ArrayList<Chunk.Metadata> arrayList = new ArrayList<Chunk.Metadata>();
        short s2 = ((OracleConnection)connection).getVersionNumber();
        String string2 = s2 >= 19000 ? "select CHUNK_NAME, SHARD_KEY_LOW, SHARD_KEY_HIGH, GROUP_KEY_LOW ,  GROUP_KEY_HIGH, PRIORITY,  INST_ID, CHUNK_ID, SHARD_NAME, CHUNK_UNIQUE_ID from LOCAL_CHUNKS WHERE TABFAM_ID=(SELECT TABFAM_ID FROM  LOCAL_TABLE_FAMILY_SERVICES WHERE SERVICE_NAME=?) and SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL and CHUNK_NAME is not NULL" : "select CHUNK_NAME, SHARD_KEY_LOW, SHARD_KEY_HIGH, GROUP_KEY_LOW ,  GROUP_KEY_HIGH, PRIORITY,  INST_ID, CHUNK_ID, SHARD_NAME, CHUNK_UNIQUE_ID from LOCAL_CHUNKS WHERE SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL and CHUNK_NAME is not NULL";
        try (PreparedStatement preparedStatement = connection.prepareStatement(string2);){
            if (s2 >= 19000) {
                preparedStatement.setString(1, string);
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    Chunk.Metadata metadata = new Chunk.Metadata();
                    metadata.chunkName = resultSet.getString("CHUNK_NAME").toLowerCase();
                    Blob blob = resultSet.getBlob("SHARD_KEY_LOW");
                    metadata.shardKeyLow = blob != null ? blob.getBinaryStream() : null;
                    Blob blob2 = resultSet.getBlob("SHARD_KEY_HIGH");
                    metadata.shardKeyHigh = blob2 != null ? blob2.getBinaryStream() : null;
                    Blob blob3 = resultSet.getBlob("GROUP_KEY_LOW");
                    metadata.superKeyLow = blob3 != null ? blob3.getBinaryStream() : null;
                    Blob blob4 = resultSet.getBlob("GROUP_KEY_HIGH");
                    metadata.superKeyHigh = blob4 != null ? blob4.getBinaryStream() : null;
                    metadata.priority = resultSet.getInt("PRIORITY");
                    metadata.affinitizedInstId = resultSet.getInt("INST_ID");
                    metadata.chunkId = resultSet.getInt("CHUNK_ID");
                    metadata.shardName = resultSet.getString("SHARD_NAME");
                    metadata.chunkUniqueId = resultSet.getInt("CHUNK_UNIQUE_ID");
                    arrayList.add(metadata);
                }
            }
        }
        return arrayList;
    }

    private static Chunk.Metadata fetchChunkMetadata(Connection connection, String string, String string2) throws SQLException {
        Chunk.Metadata metadata;
        if (connection == null) {
            return null;
        }
        short s2 = ((OracleConnection)connection).getVersionNumber();
        String string3 = s2 >= 19000 ? "select CHUNK_NAME, SHARD_KEY_LOW, SHARD_KEY_HIGH, GROUP_KEY_LOW ,  GROUP_KEY_HIGH, PRIORITY,  INST_ID, CHUNK_ID, SHARD_NAME, CHUNK_UNIQUE_ID from LOCAL_CHUNKS where lower(CHUNK_NAME) like '" + string.toLowerCase() + "' and SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL and TABFAM_ID=(SELECT TABFAM_ID FROM  LOCAL_TABLE_FAMILY_SERVICES WHERE SERVICE_NAME=?)" : "select CHUNK_NAME, SHARD_KEY_LOW, SHARD_KEY_HIGH, GROUP_KEY_LOW ,  GROUP_KEY_HIGH, PRIORITY,  INST_ID, CHUNK_ID, SHARD_NAME, CHUNK_UNIQUE_ID from LOCAL_CHUNKS where lower(CHUNK_NAME) like '" + string.toLowerCase() + "' and SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL";
        try (PreparedStatement preparedStatement = connection.prepareStatement(string3);){
            if (s2 >= 19000) {
                preparedStatement.setString(1, string2);
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    metadata = new Chunk.Metadata();
                    metadata.chunkName = resultSet.getString("CHUNK_NAME").toLowerCase();
                    metadata.shardKeyLow = resultSet.getBlob("SHARD_KEY_LOW") != null ? resultSet.getBlob(2).getBinaryStream() : null;
                    InputStream inputStream = metadata.shardKeyHigh = resultSet.getBlob("SHARD_KEY_HIGH") != null ? resultSet.getBlob(3).getBinaryStream() : null;
                    if (resultSet.getBlob(4) != null) {
                        metadata.superKeyLow = resultSet.getBlob("GROUP_KEY_LOW").getBinaryStream();
                    }
                    if (resultSet.getBlob(5) != null) {
                        metadata.superKeyHigh = resultSet.getBlob("GROUP_KEY_HIGH").getBinaryStream();
                    }
                    metadata.priority = resultSet.getInt("PRIORITY");
                    metadata.affinitizedInstId = resultSet.getInt("INST_ID");
                    metadata.chunkId = resultSet.getInt("CHUNK_ID");
                    metadata.shardName = resultSet.getString("SHARD_NAME");
                    metadata.chunkUniqueId = resultSet.getInt("CHUNK_UNIQUE_ID");
                } else {
                    metadata = null;
                }
            }
        }
        return metadata;
    }

    protected static ShardingMetadata fetchShardingMetadata(Connection connection, String string) throws SQLException {
        ShardingMetadata shardingMetadata;
        block58: {
            String string2;
            String string3;
            if (connection == null) {
                return null;
            }
            short s2 = ((OracleConnection)connection).getVersionNumber();
            if (s2 >= 19000) {
                string3 = "select GROUP_TYPE, GROUP_COL_NUM, SHARD_TYPE, SHARD_COL_NUM, DEF_VERSION from LOCAL_CHUNK_TYPES  WHERE TABFAM_ID=(SELECT TABFAM_ID FROM  LOCAL_TABLE_FAMILY_SERVICES WHERE SERVICE_NAME=?)";
                string2 = "select SHARD_LEVEL, COL_NAME, COL_IDX_IN_KEY, EFF_TYPE , CHARACTER_SET from LOCAL_CHUNK_COLUMNS  WHERE TABFAM_ID=(SELECT TABFAM_ID FROM  LOCAL_TABLE_FAMILY_SERVICES WHERE SERVICE_NAME=?)";
            } else {
                string3 = "select GROUP_TYPE, GROUP_COL_NUM, SHARD_TYPE, SHARD_COL_NUM, DEF_VERSION from LOCAL_CHUNK_TYPES ";
                string2 = "select SHARD_LEVEL, COL_NAME, COL_IDX_IN_KEY, EFF_TYPE , CHARACTER_SET from LOCAL_CHUNK_COLUMNS ";
            }
            try (PreparedStatement preparedStatement = connection.prepareStatement(string3);){
                if (s2 >= 19000) {
                    preparedStatement.setString(1, string);
                }
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        String string4 = resultSet.getString("GROUP_TYPE");
                        ShardingMetadata.ShardingType shardingType = ShardingMetadata.ShardingType.valueOf(string4);
                        String string5 = resultSet.getString("SHARD_TYPE");
                        ShardingMetadata.ShardingType shardingType2 = ShardingMetadata.ShardingType.valueOf(string5);
                        int n2 = resultSet.getInt("DEF_VERSION");
                        ArrayList<ShardingMetadata.SubKeyMetadata> arrayList = new ArrayList<ShardingMetadata.SubKeyMetadata>();
                        ArrayList<ShardingMetadata.SubKeyMetadata> arrayList2 = new ArrayList<ShardingMetadata.SubKeyMetadata>();
                        try (PreparedStatement preparedStatement2 = connection.prepareStatement(string2);){
                            if (s2 >= 19000) {
                                preparedStatement2.setString(1, string);
                            }
                            try (ResultSet resultSet2 = preparedStatement2.executeQuery();){
                                while (resultSet2.next()) {
                                    int n3 = resultSet2.getInt("SHARD_LEVEL");
                                    ShardingMetadata.SubKeyMetadata subKeyMetadata = new ShardingMetadata.SubKeyMetadata(resultSet2.getInt("COL_IDX_IN_KEY"), SQLUtil.getExternalType(resultSet2.getInt("EFF_TYPE")), resultSet2.getInt("CHARACTER_SET"));
                                    if (n3 == 0) {
                                        arrayList2.add(subKeyMetadata);
                                        continue;
                                    }
                                    if (n3 == 1) {
                                        arrayList.add(subKeyMetadata);
                                        continue;
                                    }
                                    throw new IllegalStateException("Invalid Shard Key Level in database");
                                }
                            }
                        }
                        shardingMetadata = new ShardingMetadata(n2, shardingType2, shardingType, arrayList, arrayList2);
                        break block58;
                    }
                    shardingMetadata = null;
                }
            }
        }
        return shardingMetadata;
    }

    static {
        try {
            $$$methodRef$$$57 = ShardRoutingCache.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$56 = ShardRoutingCache.class.getDeclaredMethod("access$600", ShardRoutingCache.class, RoutingKey.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$55 = ShardRoutingCache.class.getDeclaredMethod("access$300", ShardRoutingCache.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$54 = ShardRoutingCache.class.getDeclaredMethod("access$200", ShardRoutingCache.class, String.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$53 = ShardRoutingCache.class.getDeclaredMethod("access$100", ShardRoutingCache.class, String.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$52 = ShardRoutingCache.class.getDeclaredMethod("lambda$update$0", Chunk.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$51 = ShardRoutingCache.class.getDeclaredMethod("lambda$cleanup$1", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$50 = ShardRoutingCache.class.getDeclaredMethod("lambda$getBestInstanceToGrow$2", ServiceMember.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$49 = ShardRoutingCache.class.getDeclaredMethod("lambda$onHAEvent$3", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$48 = ShardRoutingCache.class.getDeclaredMethod("lambda$chunks$4", OracleShardingKey.class, OracleShardingKey.class, OracleShardingKey.class, Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$47 = ShardRoutingCache.class.getDeclaredMethod("lambda$chunks$5", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$46 = ShardRoutingCache.class.getDeclaredMethod("lambda$instancesToGrow$6", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$45 = ShardRoutingCache.class.getDeclaredMethod("lambda$hasInstanceToGrow$7", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$44 = ShardRoutingCache.class.getDeclaredMethod("lambda$allPriorityInstances$8", Set.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$43 = ShardRoutingCache.class.getDeclaredMethod("lambda$allInstances$9", Set.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$42 = ShardRoutingCache.class.getDeclaredMethod("lambda$cacheEntries$10", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$41 = ShardRoutingCache.class.getDeclaredMethod("lambda$hasAvailableConnectionForKey$11", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$40 = ShardRoutingCache.class.getDeclaredMethod("fetchShardingMetadata", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$39 = ShardRoutingCache.class.getDeclaredMethod("fetchChunkMetadata", Connection.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$38 = ShardRoutingCache.class.getDeclaredMethod("fetchInstanceChunksMetadata", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$37 = ShardRoutingCache.class.getDeclaredMethod("hasAvailableConnectionForKey", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$36 = ShardRoutingCache.class.getDeclaredMethod("shardConnectionStats", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$35 = ShardRoutingCache.class.getDeclaredMethod("onError", ConnectionRetrievalInfo.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$34 = ShardRoutingCache.class.getDeclaredMethod("destroy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$33 = ShardRoutingCache.class.getDeclaredMethod("allInstances", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$32 = ShardRoutingCache.class.getDeclaredMethod("allPriorityInstances", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$31 = ShardRoutingCache.class.getDeclaredMethod("hasInstanceToGrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$30 = ShardRoutingCache.class.getDeclaredMethod("instancesToGrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$29 = ShardRoutingCache.class.getDeclaredMethod("validateCri", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$28 = ShardRoutingCache.class.getDeclaredMethod("lookupKey", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$27 = ShardRoutingCache.class.getDeclaredMethod("entryContainsRoutingKey", Map.Entry.class, OracleShardingKey.class, OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$26 = ShardRoutingCache.class.getDeclaredMethod("chunks", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$25 = ShardRoutingCache.class.getDeclaredMethod("selected", CoreConnection.class, Set.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$24 = ShardRoutingCache.class.getDeclaredMethod("onHAEvent", FailoverDriver.Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$23 = ShardRoutingCache.class.getDeclaredMethod("prepareChunkEventHandler", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$22 = ShardRoutingCache.class.getDeclaredMethod("hasMatchingChunk", String.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$21 = ShardRoutingCache.class.getDeclaredMethod("matchingChunk", String.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$20 = ShardRoutingCache.class.getDeclaredMethod("startEventHandler", ONSDriver.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$19 = ShardRoutingCache.class.getDeclaredMethod("makeRoutingKey", Chunk.Metadata.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$18 = ShardRoutingCache.class.getDeclaredMethod("shardingMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$17 = ShardRoutingCache.class.getDeclaredMethod("buildTopologyForInstance", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$16 = ShardRoutingCache.class.getDeclaredMethod("onConnectionClosure", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$15 = ShardRoutingCache.class.getDeclaredMethod("getChunkNameForKey", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$14 = ShardRoutingCache.class.getDeclaredMethod("fetchDatabaseChunkName", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$13 = ShardRoutingCache.class.getDeclaredMethod("getConnectionInstance", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$12 = ShardRoutingCache.class.getDeclaredMethod("getShardNameFromConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$11 = ShardRoutingCache.class.getDeclaredMethod("onConnectionCreation", Connection.class, ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$10 = ShardRoutingCache.class.getDeclaredMethod("getBestInstanceToGrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$9 = ShardRoutingCache.class.getDeclaredMethod("onConnectionRequestComplete", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$8 = ShardRoutingCache.class.getDeclaredMethod("onConnectionRequest", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$7 = ShardRoutingCache.class.getDeclaredMethod("isMaxPerShardConfigured", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$6 = ShardRoutingCache.class.getDeclaredMethod("isMaxPerShardReached", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$5 = ShardRoutingCache.class.getDeclaredMethod("clearCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$4 = ShardRoutingCache.class.getDeclaredMethod("cleanup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$3 = ShardRoutingCache.class.getDeclaredMethod("onConnectionBorrow", Connection.class, ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$2 = ShardRoutingCache.class.getDeclaredMethod("update", RoutingKey.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$1 = ShardRoutingCache.class.getDeclaredMethod("hasKeyMapped", OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$0 = ShardRoutingCache.class.getDeclaredMethod("routingKeysForVersionedChunk", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
    }

    private static class L2RoutingKey {
        private final OracleShardingKey key;
        private final OracleShardingKey superKey;
        private final int hashCode;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        L2RoutingKey(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2) {
            this.key = oracleShardingKey;
            this.superKey = oracleShardingKey2;
            this.hashCode = (this.key != null ? this.key.hashCode() : 0) + (this.superKey != null ? this.superKey.hashCode() : 0);
        }

        @DisableTrace
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            L2RoutingKey l2RoutingKey = (L2RoutingKey)object;
            if (this.key == null) {
                return false;
            }
            if (this.key.equals(l2RoutingKey.key)) {
                if (this.superKey == null && l2RoutingKey.superKey == null) {
                    return true;
                }
                if (this.superKey != null && this.superKey.equals(l2RoutingKey.superKey)) {
                    return true;
                }
            }
            return false;
        }

        @DisableTrace
        public int hashCode() {
            return this.hashCode;
        }

        static {
            try {
                $$$methodRef$$$0 = L2RoutingKey.class.getDeclaredConstructor(OracleShardingKey.class, OracleShardingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }

    protected static class RoutingKey
    implements Comparable<RoutingKey> {
        private final SuperShardingKeys superShardingKeys;
        private final ShardingKeys shardingKeys;
        private final int hashCode;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;

        RoutingKey(ShardingKeys shardingKeys, SuperShardingKeys superShardingKeys) {
            this.superShardingKeys = superShardingKeys;
            this.shardingKeys = shardingKeys;
            this.hashCode = Objects.hash(superShardingKeys, this.shardingKeys);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof RoutingKey)) {
                return false;
            }
            RoutingKey routingKey = (RoutingKey)object;
            return this.superShardingKeys.equals(routingKey.superShardingKeys) && this.shardingKeys.equals(routingKey.shardingKeys);
        }

        private boolean containsShardingKey(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2) {
            if (oracleShardingKey2 != null && this.superShardingKeys == null) {
                return false;
            }
            if (this.superShardingKeys != null && !this.superShardingKeys.equals(SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS)) {
                if (oracleShardingKey2 == null) {
                    return false;
                }
                if (!this.superShardingKeys.contains(oracleShardingKey2)) {
                    return false;
                }
            }
            if (oracleShardingKey == null) {
                return false;
            }
            return this.shardingKeys.contains(oracleShardingKey);
        }

        @DisableTrace
        public String toString() {
            return (this.superShardingKeys != null ? this.superShardingKeys.toString() : "") + (this.shardingKeys != null ? "\t\t" + this.shardingKeys.toString() : "");
        }

        @Override
        public int compareTo(RoutingKey routingKey) {
            int n2 = this.superShardingKeys.compareTo(routingKey.superShardingKeys);
            if (n2 != 0) {
                return n2;
            }
            int n3 = this.shardingKeys.compareTo(routingKey.shardingKeys);
            return n3;
        }

        static {
            try {
                $$$methodRef$$$8 = RoutingKey.class.getDeclaredConstructor(ShardingKeys.class, SuperShardingKeys.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$7 = RoutingKey.class.getDeclaredMethod("access$500", RoutingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$6 = RoutingKey.class.getDeclaredMethod("access$400", RoutingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = RoutingKey.class.getDeclaredMethod("access$000", RoutingKey.class, OracleShardingKey.class, OracleShardingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = RoutingKey.class.getDeclaredMethod("compareTo", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = RoutingKey.class.getDeclaredMethod("compareTo", RoutingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = RoutingKey.class.getDeclaredMethod("containsShardingKey", OracleShardingKey.class, OracleShardingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = RoutingKey.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = RoutingKey.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

