/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.lang.reflect.Executable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.routing.Chunk;
import oracle.ucp.routing.ShardRoutingCache;
import oracle.ucp.util.Pair;

class ShardRoutingCacheBase {
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock rLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.rwLock.writeLock();
    private final NavigableMap<ShardRoutingCache.RoutingKey, Chunk> keysToChunks = new TreeMap<ShardRoutingCache.RoutingKey, Chunk>();
    private final AtomicReference<NavigableMap<ShardRoutingCache.RoutingKey, Chunk>> keysToChunksSnapshot = new AtomicReference<NavigableMap<ShardRoutingCache.RoutingKey, Chunk>>(Collections.unmodifiableNavigableMap(new TreeMap<ShardRoutingCache.RoutingKey, Chunk>((SortedMap<ShardRoutingCache.RoutingKey, Chunk>)this.keysToChunks)));
    private final Map<String, Set<ShardRoutingCache.RoutingKey>> chunkNamesToKeys = new HashMap<String, Set<ShardRoutingCache.RoutingKey>>();
    private final Map<Chunk, Set<ShardRoutingCache.RoutingKey>> chunksToKeys = new HashMap<Chunk, Set<ShardRoutingCache.RoutingKey>>();
    private final Set<Chunk> noInstsChunks = new HashSet<Chunk>();
    private final AtomicReference<Set<Chunk>> noInstsChunksSnapshot = new AtomicReference<Set<Chunk>>(Collections.unmodifiableSet(new HashSet<Chunk>(this.noInstsChunks)));
    private final Map<ServiceMember, Set<Chunk>> instsToChunks = new HashMap<ServiceMember, Set<Chunk>>();
    private final Map<String, Set<Chunk>> chunkAbsNamesToChunks = new HashMap<String, Set<Chunk>>();
    private final Map<Pair<ServiceMember, String>, Set<Chunk>> instsAndChunkAbsNamesToChunks = new HashMap<Pair<ServiceMember, String>, Set<Chunk>>();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;

    ShardRoutingCacheBase() {
    }

    protected final Set<ShardRoutingCache.RoutingKey> keyForChunk(String string) {
        if (null == string) {
            throw new IllegalArgumentException();
        }
        this.rLock.lock();
        try {
            Set<ShardRoutingCache.RoutingKey> set = this.chunkNamesToKeys.getOrDefault(string, Collections.EMPTY_SET);
            return set;
        }
        finally {
            this.rLock.unlock();
        }
    }

    protected final NavigableSet<ShardRoutingCache.RoutingKey> allKeys() {
        return this.keysToChunksSnapshot.get().navigableKeySet();
    }

    protected final NavigableMap<ShardRoutingCache.RoutingKey, Chunk> keyToChunkMap() {
        return this.keysToChunksSnapshot.get();
    }

    protected final Chunk get(ShardRoutingCache.RoutingKey routingKey) {
        if (null == routingKey) {
            throw new IllegalArgumentException();
        }
        this.rLock.lock();
        try {
            Chunk chunk = (Chunk)this.keysToChunks.get(routingKey);
            return chunk;
        }
        finally {
            this.rLock.unlock();
        }
    }

    protected final Set<Chunk> noInstsChunks() {
        return this.noInstsChunksSnapshot.get();
    }

    protected final Set<Chunk> chunks(ServiceMember serviceMember) {
        if (null == serviceMember) {
            throw new IllegalArgumentException();
        }
        this.rLock.lock();
        try {
            Set<Chunk> set = this.instsToChunks.getOrDefault(serviceMember, Collections.EMPTY_SET);
            return set;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set<Chunk> chunks(ServiceMember serviceMember, String string) {
        if (null == serviceMember || null == string) {
            return new HashSet<Chunk>();
        }
        this.rLock.lock();
        try {
            Set<Chunk> set = this.instsAndChunkAbsNamesToChunks.getOrDefault(new Pair<ServiceMember, String>(serviceMember, string), Collections.EMPTY_SET);
            return set;
        }
        finally {
            this.rLock.unlock();
        }
    }

    protected final Set<Chunk> chunks(String string) {
        if (null == string) {
            throw new IllegalArgumentException();
        }
        this.rLock.lock();
        try {
            Set<Chunk> set = this.chunkAbsNamesToChunks.getOrDefault(string, Collections.EMPTY_SET);
            return set;
        }
        finally {
            this.rLock.unlock();
        }
    }

    protected final int chunksCount() {
        this.rLock.lock();
        try {
            int n2 = this.chunksToKeys.keySet().size();
            return n2;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void remove(Chunk chunk) {
        if (null == chunk) {
            throw new IllegalArgumentException();
        }
        String string = chunk.name();
        String string2 = chunk.absoluteName();
        this.wLock.lock();
        try {
            Set<ShardRoutingCache.RoutingKey> set = this.chunksToKeys.getOrDefault(chunk, Collections.EMPTY_SET);
            set.forEach(routingKey -> {
                if (chunk.equals(this.keysToChunks.get(routingKey))) {
                    this.keysToChunks.remove(routingKey);
                }
            });
            this.keysToChunksSnapshot.set(Collections.unmodifiableNavigableMap(new TreeMap<ShardRoutingCache.RoutingKey, Chunk>((SortedMap<ShardRoutingCache.RoutingKey, Chunk>)this.keysToChunks)));
            this.chunkNamesToKeys.getOrDefault(string, Collections.EMPTY_SET).removeAll(set);
            this.chunksToKeys.getOrDefault(chunk, Collections.EMPTY_SET).removeAll(set);
            this.noInstsChunks.remove(chunk);
            chunk.instances().forEach(serviceMember -> this.instsToChunks.getOrDefault(serviceMember, Collections.EMPTY_SET).remove(chunk));
            this.chunkAbsNamesToChunks.getOrDefault(string2, Collections.EMPTY_SET).remove(chunk);
            chunk.instances().forEach(serviceMember -> this.instsAndChunkAbsNamesToChunks.getOrDefault(new Pair<ServiceMember, String>((ServiceMember)serviceMember, string2), Collections.EMPTY_SET).remove(chunk));
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void replace(ShardRoutingCache.RoutingKey routingKey, Chunk chunk, Chunk chunk2) {
        if (null == routingKey || null == chunk || null == chunk2) {
            throw new IllegalArgumentException();
        }
        this.wLock.lock();
        try {
            this.remove(chunk);
            this.putIfAbsent(routingKey, chunk2);
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Chunk putIfAbsent(ShardRoutingCache.RoutingKey routingKey, Chunk chunk2) {
        Chunk chunk3;
        if (null == routingKey || null == chunk2) {
            throw new IllegalArgumentException();
        }
        String string2 = chunk2.name();
        String string3 = chunk2.absoluteName();
        this.wLock.lock();
        try {
            chunk3 = this.keysToChunks.putIfAbsent(routingKey, chunk2);
            this.keysToChunksSnapshot.set(Collections.unmodifiableNavigableMap(new TreeMap<ShardRoutingCache.RoutingKey, Chunk>((SortedMap<ShardRoutingCache.RoutingKey, Chunk>)this.keysToChunks)));
            this.chunkNamesToKeys.computeIfAbsent(string2, string -> new HashSet()).add(routingKey);
            this.chunksToKeys.computeIfAbsent(chunk2, chunk -> new HashSet()).add(routingKey);
            if (0 == chunk2.instances().size()) {
                this.noInstsChunks.add(chunk2);
            }
            this.noInstsChunksSnapshot.set(Collections.unmodifiableSet(new HashSet<Chunk>(this.noInstsChunks)));
            chunk2.instances().forEach(serviceMember2 -> this.instsToChunks.computeIfAbsent((ServiceMember)serviceMember2, serviceMember -> new HashSet()).add(chunk2));
            this.chunkAbsNamesToChunks.computeIfAbsent(string3, string -> new HashSet()).add(chunk2);
            chunk2.instances().forEach(serviceMember -> this.instsAndChunkAbsNamesToChunks.computeIfAbsent(new Pair<ServiceMember, String>((ServiceMember)serviceMember, string3), pair -> new HashSet()).add(chunk2));
        }
        finally {
            this.wLock.unlock();
        }
        return chunk3;
    }

    protected final void clear() {
        this.wLock.lock();
        try {
            this.keysToChunks.clear();
            this.keysToChunksSnapshot.set(Collections.unmodifiableNavigableMap(new TreeMap<ShardRoutingCache.RoutingKey, Chunk>((SortedMap<ShardRoutingCache.RoutingKey, Chunk>)this.keysToChunks)));
            this.chunkNamesToKeys.clear();
            this.noInstsChunks.clear();
            this.noInstsChunksSnapshot.set(Collections.unmodifiableSet(new HashSet<Chunk>(this.noInstsChunks)));
            this.instsToChunks.clear();
            this.chunkAbsNamesToChunks.clear();
            this.instsAndChunkAbsNamesToChunks.clear();
        }
        finally {
            this.wLock.unlock();
        }
    }

    @DisableTrace
    public String toString() {
        return "" + this.keysToChunksSnapshot;
    }

    static {
        try {
            $$$methodRef$$$23 = ShardRoutingCacheBase.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$22 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$remove$0", Chunk.class, ShardRoutingCache.RoutingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$21 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$remove$1", Chunk.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$remove$2", String.class, Chunk.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$putIfAbsent$3", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$putIfAbsent$4", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$null$5", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$putIfAbsent$6", Chunk.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$putIfAbsent$7", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$null$8", Pair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = ShardRoutingCacheBase.class.getDeclaredMethod("lambda$putIfAbsent$9", String.class, Chunk.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = ShardRoutingCacheBase.class.getDeclaredMethod("clear", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = ShardRoutingCacheBase.class.getDeclaredMethod("putIfAbsent", ShardRoutingCache.RoutingKey.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = ShardRoutingCacheBase.class.getDeclaredMethod("replace", ShardRoutingCache.RoutingKey.class, Chunk.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = ShardRoutingCacheBase.class.getDeclaredMethod("remove", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = ShardRoutingCacheBase.class.getDeclaredMethod("chunksCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = ShardRoutingCacheBase.class.getDeclaredMethod("chunks", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = ShardRoutingCacheBase.class.getDeclaredMethod("chunks", ServiceMember.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = ShardRoutingCacheBase.class.getDeclaredMethod("chunks", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = ShardRoutingCacheBase.class.getDeclaredMethod("noInstsChunks", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = ShardRoutingCacheBase.class.getDeclaredMethod("get", ShardRoutingCache.RoutingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = ShardRoutingCacheBase.class.getDeclaredMethod("keyToChunkMap", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = ShardRoutingCacheBase.class.getDeclaredMethod("allKeys", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = ShardRoutingCacheBase.class.getDeclaredMethod("keyForChunk", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

