/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing.oracle;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleShardingKeyBuilder;
import oracle.jdbc.OracleType;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleShardingKeyBuilderImpl;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.jdbc.pool.ShardingMetadata;
import oracle.ons.ONS;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.routing.Chunk;
import oracle.ucp.routing.ChunkEventHandler;
import oracle.ucp.routing.ChunkInfo;
import oracle.ucp.routing.ShardInfo;
import oracle.ucp.routing.ShardRoutingCache;
import oracle.ucp.routing.oracle.ChunkInfoImpl;
import oracle.ucp.util.UCPErrorHandler;

public class OracleShardRoutingCache
extends ShardRoutingCache {
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String URL = "url";
    public static final String REGION = "region";
    public static final String SERVICE_NAME = "serviceName";
    private Properties dataSourceProperties = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;

    OracleShardRoutingCache(final ONS oNS) throws UniversalConnectionPoolException {
        ONSDriver oNSDriver = new ONSDriver(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            protected ONS getONS() throws UniversalConnectionPoolException {
                return oNS;
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(OracleShardRoutingCache.class, ONS.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("getONS", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
        this.startEventHandler(oNSDriver);
    }

    public OracleShardRoutingCache(Properties properties) throws UniversalConnectionPoolException {
        if (properties == null) {
            throw new IllegalArgumentException("Invalid datasource properties provided");
        }
        String string = properties.getProperty(SERVICE_NAME, null);
        if (string == null) {
            throw new IllegalStateException("Service name must be set on datasource properties.");
        }
        this.dataSourceProperties = properties;
        this.initializeCache();
    }

    public void initializeCache() throws UniversalConnectionPoolException {
        String string = this.dataSourceProperties.getProperty(SERVICE_NAME);
        try (Connection connection = this.getConnectionFromDatasource();){
            String string2;
            if (this.dataSourceProperties.containsKey(REGION) && (string2 = this.getOnsConfig(connection, this.dataSourceProperties.getProperty(REGION))) != null) {
                ONSDriver oNSDriver = ONSDriver.instance();
                oNSDriver.start(string2);
                this.startEventHandler(oNSDriver);
            }
            this.shardingMetadata.compareAndSet(null, OracleShardRoutingCache.fetchShardingMetadata(connection, string));
            this.buildTopologyForInstance(connection, string);
            if (this.keyToChunkMap().size() == 0) {
                UCPErrorHandler.throwUniversalConnectionPoolException(280);
            }
        }
        catch (SQLException sQLException) {
            throw new UniversalConnectionPoolException(sQLException);
        }
    }

    private Connection getConnectionFromDatasource() throws SQLException {
        OracleDataSource oracleDataSource = new OracleDataSource();
        String string = this.dataSourceProperties.getProperty(URL);
        oracleDataSource.setURL(string);
        oracleDataSource.setConnectionProperties(this.dataSourceProperties);
        return oracleDataSource.getConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getOnsConfig(Connection connection, String string) throws UniversalConnectionPoolException {
        String string2 = "select gsmadmin_internal.dbms_gsm_utility.getgdsonsconfig('" + string + "') from dual";
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string2);){
            if (!resultSet.next()) return null;
            String string3 = resultSet.getString(1);
            return string3;
        }
        catch (SQLException sQLException) {
            throw new UniversalConnectionPoolException(sQLException);
        }
    }

    public OracleShardingKeyBuilder getShardingKeyBuilder() throws UniversalConnectionPoolException {
        try {
            return new OracleDataSource().createShardingKeyBuilder();
        }
        catch (SQLException sQLException) {
            throw new UniversalConnectionPoolException(sQLException);
        }
    }

    public void reloadCache(Properties properties) throws UniversalConnectionPoolException {
        this.destroy();
        if (properties == null) {
            throw new IllegalArgumentException("Invalid datasource properties provided");
        }
        String string = properties.getProperty(SERVICE_NAME, null);
        if (string == null) {
            throw new IllegalStateException("Service name must be set on datasource properties.");
        }
        this.dataSourceProperties = properties;
        this.initializeCache();
    }

    Set<ServiceMember> getInstancesForShardKey(JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo) {
        HashSet<ServiceMember> hashSet = new HashSet<ServiceMember>();
        this.chunks(jDBCConnectionRetrievalInfo).stream().forEach(chunk -> hashSet.addAll(chunk.instances()));
        return hashSet;
    }

    public Set<ShardInfo> getShardInfoForKey(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2) {
        HashSet<ShardInfo> hashSet = new HashSet<ShardInfo>();
        JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = JDBCConnectionRetrievalInfo.createBuilder().shardingKey(oracleShardingKey).superShardingKey(oracleShardingKey2).build();
        this.chunks(jDBCConnectionRetrievalInfo).forEach(chunk -> hashSet.addAll(chunk.shardInfo()));
        return hashSet;
    }

    public ChunkInfo getChunkInfoForKey(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2) {
        int n2 = -1;
        HashSet<ShardInfo> hashSet = new HashSet<ShardInfo>();
        JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = JDBCConnectionRetrievalInfo.createBuilder().shardingKey(oracleShardingKey).superShardingKey(oracleShardingKey2).build();
        List<Chunk> list = this.chunks(jDBCConnectionRetrievalInfo);
        if (list != null && list.size() > 0) {
            Chunk chunk = list.get(0);
            n2 = chunk.getUniqueId();
            hashSet.addAll(chunk.shardInfo());
        }
        return new ChunkInfoImpl(n2, hashSet);
    }

    private List<Chunk> chunks(JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo) {
        OracleShardingKey oracleShardingKey = jDBCConnectionRetrievalInfo.getShardingKey();
        OracleShardingKey oracleShardingKey2 = jDBCConnectionRetrievalInfo.getSuperShardingKey();
        if (oracleShardingKey == null) {
            return null;
        }
        if (this.shardingMetadata() == null) {
            return null;
        }
        OracleShardingKey oracleShardingKey3 = this.lookupKey(oracleShardingKey);
        List<Chunk> list = this.keyToChunkMap().entrySet().stream().filter(entry -> this.entryContainsRoutingKey((Map.Entry<ShardRoutingCache.RoutingKey, Chunk>)entry, oracleShardingKey, oracleShardingKey3, oracleShardingKey2)).map(entry -> (Chunk)entry.getValue()).collect(Collectors.toList());
        return list;
    }

    private OracleShardingKey lookupKey(OracleShardingKey oracleShardingKey) {
        if (oracleShardingKey == null) {
            return null;
        }
        OracleShardingKey oracleShardingKey2 = oracleShardingKey;
        if (this.shardingMetadata().getShardingType() == ShardingMetadata.ShardingType.HASH) {
            long l2 = ((OracleShardingKeyImpl)oracleShardingKey).shardKeyOraHash(this.shardingMetadata());
            oracleShardingKey2 = new OracleShardingKeyBuilderImpl().subkey(l2, OracleType.NUMBER).oraHash(l2).build();
        }
        return oracleShardingKey2;
    }

    protected ChunkEventHandler prepareChunkEventHandler() {
        return new ChunkEventHandler(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            protected void onEvent(ChunkEventHandler.Event event) {
                if (OracleShardRoutingCache.this.dataSourceProperties != null) {
                    try {
                        OracleShardRoutingCache.this.clearCache();
                        OracleShardRoutingCache.this.buildTopologyForInstance(OracleShardRoutingCache.this.getConnectionFromDatasource(), OracleShardRoutingCache.this.dataSourceProperties.getProperty(OracleShardRoutingCache.SERVICE_NAME));
                    }
                    catch (SQLException sQLException) {
                        ClioSupport.ilogThrowing(null, null, null, null, sQLException);
                    }
                }
            }

            static {
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredConstructor(OracleShardRoutingCache.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("onEvent", ChunkEventHandler.Event.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    protected boolean isMaxPerShardReached(ServiceMember serviceMember) {
        return false;
    }

    @Override
    protected Service service() {
        return null;
    }

    static {
        try {
            $$$methodRef$$$22 = OracleShardRoutingCache.class.getDeclaredConstructor(Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$21 = OracleShardRoutingCache.class.getDeclaredConstructor(ONS.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = OracleShardRoutingCache.class.getDeclaredMethod("access$300", OracleShardRoutingCache.class, Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = OracleShardRoutingCache.class.getDeclaredMethod("access$200", OracleShardRoutingCache.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = OracleShardRoutingCache.class.getDeclaredMethod("access$100", OracleShardRoutingCache.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = OracleShardRoutingCache.class.getDeclaredMethod("access$000", OracleShardRoutingCache.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = OracleShardRoutingCache.class.getDeclaredMethod("lambda$getInstancesForShardKey$0", Set.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = OracleShardRoutingCache.class.getDeclaredMethod("lambda$getShardInfoForKey$1", Set.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = OracleShardRoutingCache.class.getDeclaredMethod("lambda$chunks$2", OracleShardingKey.class, OracleShardingKey.class, OracleShardingKey.class, Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = OracleShardRoutingCache.class.getDeclaredMethod("lambda$chunks$3", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = OracleShardRoutingCache.class.getDeclaredMethod("service", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = OracleShardRoutingCache.class.getDeclaredMethod("isMaxPerShardReached", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = OracleShardRoutingCache.class.getDeclaredMethod("prepareChunkEventHandler", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = OracleShardRoutingCache.class.getDeclaredMethod("lookupKey", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = OracleShardRoutingCache.class.getDeclaredMethod("chunks", JDBCConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = OracleShardRoutingCache.class.getDeclaredMethod("getChunkInfoForKey", OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = OracleShardRoutingCache.class.getDeclaredMethod("getShardInfoForKey", OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = OracleShardRoutingCache.class.getDeclaredMethod("getInstancesForShardKey", JDBCConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = OracleShardRoutingCache.class.getDeclaredMethod("reloadCache", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = OracleShardRoutingCache.class.getDeclaredMethod("getShardingKeyBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = OracleShardRoutingCache.class.getDeclaredMethod("getOnsConfig", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = OracleShardRoutingCache.class.getDeclaredMethod("getConnectionFromDatasource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = OracleShardRoutingCache.class.getDeclaredMethod("initializeCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

