/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.tuners;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.Clock;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.tuners.Tunable;
import oracle.ucp.tuners.stats.Histogram;
import oracle.ucp.tuners.stats.HistogramRegistry;
import oracle.ucp.util.Pair;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.tuners")
@Supports(value={Feature.ADMIN})
public class PoolSizeTuner {
    public static long TUNEUP_TIMEOUT;
    public static int TURN_RING_TIMEOUT;
    public static long SINGLE_RUN_TIMEOUT;
    private static final AtomicBoolean inProgress;
    private static volatile long giveUpTime;
    private static final AtomicBoolean tunedUp;
    private static List<Tunable> listTunable;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    public static void trigger() {
        if (!Util.isSelfTunerEnabled()) {
            return;
        }
        giveUpTime = Clock.clock() + SINGLE_RUN_TIMEOUT;
        if (inProgress.compareAndSet(false, true)) {
            try {
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(PoolSizeTuner.getTunerTask());
            }
            catch (RuntimeException runtimeException) {
                inProgress.set(false);
            }
        }
    }

    private static UCPTaskBase<Object> getTunerTask() {
        return new UCPTaskBase<Object>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            @DefaultLogger(value="oracle.ucp.tuners")
            @Supports(value={Feature.ADMIN})
            public void run() {
                ClioSupport.ilogFinest(null, null, null, null, "started");
                while (Clock.clock() < giveUpTime) {
                    for (int i2 = 0; i2 < TURN_RING_TIMEOUT; ++i2) {
                        if (!Util.isSelfTunerEnabled()) {
                            return;
                        }
                        try {
                            Thread.sleep(TUNEUP_TIMEOUT);
                        }
                        catch (InterruptedException interruptedException) {
                            ClioSupport.ilogThrowing(null, null, null, null, interruptedException);
                        }
                        PoolSizeTuner.tuneUp();
                    }
                    PoolSizeTuner.turnRing();
                }
                inProgress.set(false);
                ClioSupport.ilogFinest(null, null, null, null, "ended");
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
            }
        };
    }

    private static void turnRing() {
        listTunable.forEach(tunable -> PoolSizeTuner.turnRing(tunable));
        ClioSupport.ilogFinest(null, null, null, null, "ring turned");
    }

    private static void turnRing(Tunable tunable) {
        tunable.getAvailableRegistry().turnRing();
        tunable.getBorrowedRegistry().turnRing();
        tunable.getCreatedRegistry().turnRing();
    }

    private static void tuneUp() {
        listTunable.forEach(tunable -> PoolSizeTuner.tuneUp(tunable));
    }

    private static void tuneUp(Tunable tunable) {
        HistogramRegistry histogramRegistry = tunable.getAvailableRegistry().collect();
        HistogramRegistry histogramRegistry2 = tunable.getBorrowedRegistry().collect();
        HistogramRegistry histogramRegistry3 = tunable.getCreatedRegistry().collect();
        histogramRegistry.forEach((connectionRetrievalInfo, histogram) -> PoolSizeTuner.tuneUp(connectionRetrievalInfo, histogram, histogramRegistry2.getHistogram((ConnectionRetrievalInfo)connectionRetrievalInfo), histogramRegistry3.getHistogram((ConnectionRetrievalInfo)connectionRetrievalInfo), tunable));
    }

    private static void tuneUp(ConnectionRetrievalInfo connectionRetrievalInfo, Histogram histogram, Histogram histogram2, Histogram histogram3, Tunable tunable) {
        Pair<Long, Long> pair = histogram.computeEffectiveRange();
        Pair<Long, Long> pair2 = histogram2.computeEffectiveRange();
        Pair<Long, Long> pair3 = histogram3.computeEffectiveRange();
        boolean bl2 = tunable.availableGrowsInProgress();
        int n2 = tunable.getNeverUsedConnectionsCounter().getCounter(connectionRetrievalInfo).get();
        int n3 = tunable.getTotalConnectionsCount(connectionRetrievalInfo);
        String string = "cri=" + connectionRetrievalInfo + ", availER=" + pair + ", borrowER=" + pair2 + ", createdER=" + pair3 + ", availGrowsInProgress=" + bl2 + ", neverUsedConnCount=" + n2 + ", totalConnsCount=" + n3;
        ClioSupport.ilogFinest(null, null, null, null, string);
        if (pair.get1st() >= pair2.get1st() || pair.get2nd() > pair2.get2nd()) {
            long l2 = pair.get2nd() + pair.get1st() / 2L;
            long l3 = pair2.get2nd() + pair2.get1st() / 2L;
            long l4 = Math.max(1L, (long)n3 * (long)Math.ceil((double)Math.abs(l2 - l3) / 60000.0));
            int n4 = 0;
            while ((long)n4 < l4) {
                tunable.getConnectionReducer().reduce(connectionRetrievalInfo);
                ++n4;
            }
            String string2 = "attempted to reduce " + l4 + " connection(s) for CRI=" + connectionRetrievalInfo;
            ClioSupport.ilogFinest(null, null, null, null, string2);
            tunedUp.set(true);
        } else if (!(bl2 || 0 != n2 || pair3.get1st() <= pair2.get1st() && pair3.get2nd() <= pair2.get2nd())) {
            long l5 = pair3.get2nd() + pair3.get1st() / 2L;
            long l6 = pair2.get2nd() + pair2.get1st() / 2L;
            long l7 = Math.max(1L, (long)n3 * (long)Math.ceil((double)Math.abs(l5 - l6) / 60000.0));
            int n5 = 0;
            while ((long)n5 < l7) {
                tunable.getConnectionGrower().grow(connectionRetrievalInfo);
                ++n5;
            }
            String string3 = "attempted to grow " + l7 + " connection(s) for CRI=" + connectionRetrievalInfo;
            ClioSupport.ilogFinest(null, null, null, null, string3);
            tunedUp.set(true);
        } else {
            tunedUp.set(false);
        }
    }

    private PoolSizeTuner() {
    }

    public static void plug(Tunable tunable) {
        listTunable.add(tunable);
    }

    static {
        try {
            $$$methodRef$$$15 = PoolSizeTuner.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$14 = PoolSizeTuner.class.getDeclaredMethod("access$300", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$13 = PoolSizeTuner.class.getDeclaredMethod("access$200", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$12 = PoolSizeTuner.class.getDeclaredMethod("access$100", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$11 = PoolSizeTuner.class.getDeclaredMethod("access$000", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$10 = PoolSizeTuner.class.getDeclaredMethod("lambda$turnRing$0", Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$9 = PoolSizeTuner.class.getDeclaredMethod("lambda$tuneUp$1", Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$8 = PoolSizeTuner.class.getDeclaredMethod("lambda$tuneUp$2", HistogramRegistry.class, HistogramRegistry.class, Tunable.class, ConnectionRetrievalInfo.class, Histogram.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$7 = PoolSizeTuner.class.getDeclaredMethod("plug", Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$6 = PoolSizeTuner.class.getDeclaredMethod("tuneUp", ConnectionRetrievalInfo.class, Histogram.class, Histogram.class, Histogram.class, Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$5 = PoolSizeTuner.class.getDeclaredMethod("tuneUp", Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$4 = PoolSizeTuner.class.getDeclaredMethod("tuneUp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$3 = PoolSizeTuner.class.getDeclaredMethod("turnRing", Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$2 = PoolSizeTuner.class.getDeclaredMethod("turnRing", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$1 = PoolSizeTuner.class.getDeclaredMethod("getTunerTask", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        try {
            $$$methodRef$$$0 = PoolSizeTuner.class.getDeclaredMethod("trigger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.tuners");
        TUNEUP_TIMEOUT = 5000L;
        TURN_RING_TIMEOUT = 5;
        SINGLE_RUN_TIMEOUT = 600000L;
        inProgress = new AtomicBoolean(false);
        giveUpTime = 0L;
        tunedUp = new AtomicBoolean(false);
        listTunable = new ArrayList<Tunable>();
    }
}

