/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.tuners.stats;

import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.logging.Logger;
import oracle.ucp.tuners.stats.HistogramInsertionException;
import oracle.ucp.util.Pair;

public class Histogram {
    private final long min;
    private final long max;
    private final long step;
    private final long[] hist;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    public Histogram(long l2, long l3, long l4) {
        this.min = l2;
        this.max = l3;
        this.step = l4;
        this.hist = new long[(int)Math.ceil((l3 - l2) / l4)];
        Arrays.fill(this.hist, 0L);
        if (l3 <= l2 || l4 > l3 - l2) {
            throw new IllegalArgumentException();
        }
    }

    public void insert(long l2) throws HistogramInsertionException {
        if (l2 < this.min || l2 > this.max) {
            throw new HistogramInsertionException("data out of range");
        }
        int n2 = (int)((l2 - this.min) / this.step);
        this.hist[n2] = this.hist[n2] + 1L;
    }

    public Histogram add(Histogram histogram) {
        int n2 = this.hist.length;
        if (n2 != histogram.hist.length) {
            throw new IllegalArgumentException("incompatible histograms");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2;
            this.hist[n3] = this.hist[n3] + histogram.hist[i2];
        }
        return this;
    }

    public Pair<Long, Long> computeEffectiveRange() {
        int n2;
        int n3;
        long l2 = 0L;
        int n4 = 0;
        for (n3 = 0; n3 < this.hist.length; ++n3) {
            if (this.hist[n3] <= l2) continue;
            l2 = this.hist[n3] * (((long)n3 + this.min) * this.step);
            n4 = n3;
        }
        n3 = n4;
        for (n2 = n4; n2 >= 0; --n2) {
            if (this.hist[n2] * (((long)n2 + this.min) * this.step) > l2 / 2L) continue;
            n3 = n2;
            break;
        }
        n2 = n4;
        for (int i2 = n4; i2 < this.hist.length; ++i2) {
            if (this.hist[i2] * (((long)i2 + this.min) * this.step) > l2 / 2L) continue;
            n2 = i2;
            break;
        }
        return new Pair<Long, Long>(this.min + (long)n3 * this.step, this.min + (long)n2 * this.step);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (long i2 = this.min; i2 < this.max; i2 += this.step) {
            stringBuilder.append(i2).append(':').append(this.hist[(int)((i2 - this.min) / this.step)]);
            if (i2 >= this.max - this.step) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        try {
            $$$methodRef$$$4 = Histogram.class.getDeclaredConstructor(Long.TYPE, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = Histogram.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = Histogram.class.getDeclaredMethod("computeEffectiveRange", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = Histogram.class.getDeclaredMethod("add", Histogram.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = Histogram.class.getDeclaredMethod("insert", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

