/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class RingBuffer<T> {
    public static final int DEFAULT_CAPACITY = 64;
    private final Object[] ring;
    private int pointer = 0;
    private int nUpdates = 0;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock rLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.rwLock.writeLock();

    public RingBuffer() {
        this(64);
    }

    public RingBuffer(int n2) {
        this.ring = new Object[n2];
    }

    private int next(int n2) {
        return (n2 + 1) % this.getCapacity();
    }

    private int previous(int n2) {
        int n3 = n2 - 1;
        return n3 < 0 ? this.getCapacity() - 1 : n3;
    }

    public final void addItem(T t2) {
        this.wLock.lock();
        try {
            this.pointer = this.next(this.pointer);
            this.ring[this.pointer] = t2;
            if (++this.nUpdates < 0) {
                this.nUpdates = Integer.MAX_VALUE;
            }
        }
        finally {
            this.wLock.unlock();
        }
    }

    public final int getCapacity() {
        return this.ring.length;
    }

    public final int getNumberOfUpdates() {
        this.rLock.lock();
        try {
            int n2 = this.nUpdates;
            return n2;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<T> getAsList() {
        this.rLock.lock();
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n2 = this.pointer;
            for (int i2 = 0; i2 < Math.min(this.getCapacity(), this.getNumberOfUpdates()); ++i2) {
                arrayList.add(this.ring[n2]);
                n2 = this.previous(n2);
            }
            ArrayList<Object> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @DisableTrace
    public String toString() {
        this.rLock.lock();
        try {
            String string = this.toString(Math.min(this.getCapacity(), this.getNumberOfUpdates()));
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DisableTrace
    public String toString(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.rLock.lock();
        try {
            int n3 = this.pointer;
            int n4 = n2;
            if (n4 < 1) {
                String string = "";
                return string;
            }
            do {
                Object object;
                if (null == (object = this.ring[n3])) continue;
                stringBuilder.append(object.toString());
            } while ((n3 = this.previous(n3)) != this.pointer && --n4 > 0);
        }
        finally {
            this.rLock.unlock();
        }
        return stringBuilder.toString();
    }

    public final void clear() {
        this.wLock.lock();
        try {
            this.pointer = 0;
            this.nUpdates = 0;
        }
        finally {
            this.wLock.unlock();
        }
    }
}

