/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.logging.ClioSupport;

@DefaultLogger(value="oracle.ucp.util")
public class UniqueIdentifier {
    private static final AtomicInteger idNum;
    private static final String jvmInstanceId;
    private static final String hostName;
    private final String uniqueID;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    String initHostName() {
        String string = null;
        try {
            string = this.getLocalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            ClioSupport.ilogWarning(null, null, null, null, "failed to get this host's name");
        }
        if ("localhost".equals(string)) {
            ClioSupport.ilogWarning(null, null, null, null, "'localhost' is not a unique hostname");
            string = null;
        }
        return string;
    }

    String initJvmInstanceId() {
        String string = null;
        try {
            String string2 = new UID().toString();
            if (string2 != null && (string = string2.split(":", 2)[0]) != null) {
                string = string.replace('-', 'a');
            }
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
        return string;
    }

    public UniqueIdentifier(String string) {
        this.uniqueID = null != jvmInstanceId && null != hostName ? new StringBuilder(256).append(string).append(jvmInstanceId).append('-').append(idNum.incrementAndGet()).append('-').append(hostName).toString() : UUID.randomUUID().toString();
    }

    public boolean equals(Object object) {
        boolean bl2 = false;
        if (object != null && object instanceof UniqueIdentifier && this == object) {
            bl2 = true;
        }
        return bl2;
    }

    public int hashCode() {
        return this.uniqueID.hashCode();
    }

    @DisableTrace
    public String toString() {
        return this.uniqueID;
    }

    public static UniqueIdentifier generateUniqueID(String string) {
        return new UniqueIdentifier(string);
    }

    protected String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    static {
        try {
            $$$methodRef$$$6 = UniqueIdentifier.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        try {
            $$$methodRef$$$5 = UniqueIdentifier.class.getDeclaredMethod("getLocalHostName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        try {
            $$$methodRef$$$4 = UniqueIdentifier.class.getDeclaredMethod("generateUniqueID", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        try {
            $$$methodRef$$$3 = UniqueIdentifier.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        try {
            $$$methodRef$$$2 = UniqueIdentifier.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        try {
            $$$methodRef$$$1 = UniqueIdentifier.class.getDeclaredMethod("initJvmInstanceId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        try {
            $$$methodRef$$$0 = UniqueIdentifier.class.getDeclaredMethod("initHostName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.util");
        idNum = new AtomicInteger(0);
        jvmInstanceId = new UniqueIdentifier("").initJvmInstanceId();
        hostName = new UniqueIdentifier("").initHostName();
    }
}

