/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class UCPFormatter
extends Formatter {
    @Override
    public String format(LogRecord logRecord) {
        String string = logRecord.getMessage();
        Level level = logRecord.getLevel();
        return new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS a Z").format(new Date(logRecord.getMillis()), new StringBuffer(), new FieldPosition(0)).append(" UCP ").append(level.toString()).append(" seq-").append(logRecord.getSequenceNumber()).append(",thread-").append(logRecord.getThreadID()).append(' ').append(logRecord.getSourceClassName()).append('.').append(logRecord.getSourceMethodName()).append(' ').append(this.fmtMsgParams(logRecord)).append(this.fmtThrown(logRecord)).append('\n').toString();
    }

    private String fmtMsgParams(LogRecord logRecord) {
        String string = logRecord.getMessage();
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split("\\{\\d+\\}");
        Object[] objectArray = logRecord.getParameters();
        int n2 = 0;
        for (String string2 : stringArray) {
            stringBuilder.append((Object)string2);
            if (objectArray == null || objectArray.length <= n2) continue;
            stringBuilder.append(objectArray[n2++]);
        }
        return stringBuilder.toString();
    }

    private String fmtThrown(LogRecord logRecord) {
        Throwable throwable = logRecord.getThrown();
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return "" + '\n' + stringWriter + '\n';
    }
}

