/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.xml;

import java.io.File;
import java.lang.reflect.Executable;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.xml.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLConfigurationParser
implements Parser {
    private Schema schema;
    private static XMLConfigurationParser xmlParserInstance;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    private XMLConfigurationParser() throws Exception {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource streamSource = new StreamSource(XMLConfigurationParser.class.getResourceAsStream("configuration.xsd"));
        this.schema = schemaFactory.newSchema(streamSource);
    }

    public static synchronized XMLConfigurationParser getInstance() throws Exception {
        if (xmlParserInstance == null) {
            xmlParserInstance = new XMLConfigurationParser();
        }
        return xmlParserInstance;
    }

    @Override
    public Map<String, Object> parse(URI uRI) throws Exception {
        boolean bl2 = this.validateURI(uRI);
        if (!bl2) {
            throw new UniversalConnectionPoolException("File path is Invalid", 387);
        }
        boolean bl3 = this.validateAgainstSchema(uRI);
        if (!bl3) {
            throw new UniversalConnectionPoolException("XML configuration is not valid as per schema", 387);
        }
        return this.parseDocumentURI(uRI);
    }

    private Map<String, Object> parseDocumentURI(URI uRI) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new File(uRI));
        return this.parseDocument(document);
    }

    private Map<String, Object> parseDocument(Document document) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("connection-pool");
        if (nodeList.getLength() > 0) {
            hashMap.putAll(this.parseAllConnectionPools(nodeList));
        }
        return hashMap;
    }

    private Map<String, Object> parseAllConnectionPools(NodeList nodeList) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node = nodeList.item(i2);
            HashMap hashMap2 = (HashMap)this.parseOneConnectionPool(node);
            String string = (String)hashMap2.get("connection-pool-name");
            if (hashMap.containsKey(string)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(275);
            }
            for (String string2 : hashMap2.keySet()) {
                if (!string2.startsWith("data-source-") || hashSet.add(string2)) continue;
                UCPErrorHandler.throwUniversalConnectionPoolException(276);
            }
            hashMap.put(string, hashMap2);
        }
        return hashMap;
    }

    Map<String, Object> parseOneConnectionPool(Node node) throws UniversalConnectionPoolException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (node.getNodeType() == 1) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                Node node2 = namedNodeMap.item(i2);
                object8 = node2.getNodeName();
                object7 = node2.getNodeValue();
                hashMap.put((String)object8, object7);
            }
            NodeList nodeList = ((Element)node).getElementsByTagName("data-source");
            if (nodeList.getLength() > 1 && !Boolean.parseBoolean((String)hashMap.get("shared"))) {
                UCPErrorHandler.throwUniversalConnectionPoolException(273);
            }
            if (nodeList.getLength() > 0) {
                for (int i3 = 0; i3 < nodeList.getLength(); ++i3) {
                    object8 = nodeList.item(i3);
                    object7 = object8.getAttributes();
                    if (object7.getLength() <= 0) continue;
                    object6 = new HashMap();
                    for (int i4 = 0; i4 < object7.getLength(); ++i4) {
                        object5 = object7.item(i4);
                        object4 = object5.getNodeName();
                        object3 = object5.getNodeValue();
                        ((HashMap)object6).put(object4, object3);
                    }
                    object2 = ((Element)object8).getElementsByTagName("pdb-role");
                    object5 = new Properties();
                    if (object2.getLength() > 0) {
                        for (int i5 = 0; i5 < object2.getLength(); ++i5) {
                            object3 = object2.item(i5);
                            object = object3.getAttributes();
                            if (object.getLength() <= 0) continue;
                            String string = object.item(0).getNodeValue();
                            String string2 = object.item(1).getNodeValue();
                            ((Properties)object5).put(string, string2);
                        }
                        ((HashMap)object6).put("pdb-role", object5);
                    }
                    object4 = (String)((HashMap)object6).get("data-source-name");
                    object3 = "data-source-" + (String)object4;
                    if (hashMap.containsKey(object3)) {
                        UCPErrorHandler.throwUniversalConnectionPoolException(276);
                    }
                    hashMap.put((String)object3, object6);
                }
            }
            NodeList nodeList2 = ((Element)node).getElementsByTagName("connection-factory-property");
            object8 = new Properties();
            if (nodeList2.getLength() > 0) {
                for (int i6 = 0; i6 < nodeList2.getLength(); ++i6) {
                    object6 = nodeList2.item(i6);
                    object2 = object6.getAttributes();
                    if (object2.getLength() <= 0) continue;
                    object5 = object2.item(0).getNodeValue();
                    object4 = object2.item(1).getNodeValue();
                    ((Properties)object8).put(object5, object4);
                }
                hashMap.put("connection-factory-property", object8);
            }
            NodeList nodeList3 = ((Element)node).getElementsByTagName("connection-property");
            object6 = new Properties();
            if (nodeList3.getLength() > 0) {
                for (int i7 = 0; i7 < nodeList3.getLength(); ++i7) {
                    object5 = nodeList3.item(i7);
                    object4 = object5.getAttributes();
                    if (object4.getLength() <= 0) continue;
                    object3 = object4.item(0).getNodeValue();
                    object = object4.item(1).getNodeValue();
                    ((Properties)object6).put(object3, object);
                }
                hashMap.put("connection-property", object6);
            }
        }
        return hashMap;
    }

    public static Map<String, Object> getPoolConfigForDataSource(String string, Map<String, Object> map) {
        if (map.size() == 0) {
            throw new IllegalStateException("XML file not present or not parsed");
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Map map2 = (Map)entry.getValue();
            if (!map2.containsKey("data-source-" + string)) continue;
            return map2;
        }
        return null;
    }

    public static String getPoolNameForDataSource(String string, Map<String, Object> map) {
        if (map.size() == 0) {
            throw new IllegalStateException("XML file not present or not parsed");
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Map map2 = (Map)entry.getValue();
            if (!map2.containsKey("data-source-" + string)) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean validateAgainstSchema(URI uRI) throws Exception {
        if (null != this.schema) {
            Validator validator = this.schema.newValidator();
            validator.validate(new StreamSource(new File(uRI)));
            return true;
        }
        throw new UniversalConnectionPoolException("XML Schema for validation is not found", 387);
    }

    public boolean validateURI(URI uRI) {
        if (uRI.toString().endsWith(".xml")) {
            File file = new File(uRI);
            return null != file;
        }
        return false;
    }

    static {
        try {
            $$$methodRef$$$10 = XMLConfigurationParser.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = XMLConfigurationParser.class.getDeclaredMethod("validateURI", URI.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = XMLConfigurationParser.class.getDeclaredMethod("validateAgainstSchema", URI.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = XMLConfigurationParser.class.getDeclaredMethod("getPoolNameForDataSource", String.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = XMLConfigurationParser.class.getDeclaredMethod("getPoolConfigForDataSource", String.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = XMLConfigurationParser.class.getDeclaredMethod("parseOneConnectionPool", Node.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = XMLConfigurationParser.class.getDeclaredMethod("parseAllConnectionPools", NodeList.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = XMLConfigurationParser.class.getDeclaredMethod("parseDocument", Document.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = XMLConfigurationParser.class.getDeclaredMethod("parseDocumentURI", URI.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = XMLConfigurationParser.class.getDeclaredMethod("parse", URI.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = XMLConfigurationParser.class.getDeclaredMethod("getInstance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        xmlParserInstance = null;
    }
}

