/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sqlite.SQLiteConnection;
import org.sqlite.core.CoreDatabaseMetaData;
import org.sqlite.core.CoreStatement;
import org.sqlite.util.Logger;
import org.sqlite.util.LoggerFactory;
import org.sqlite.util.QueryUtils;
import org.sqlite.util.StringUtils;

public abstract class JDBC3DatabaseMetaData
extends CoreDatabaseMetaData {
    private static String driverName;
    private static String driverVersion;
    protected static final Pattern TYPE_INTEGER;
    protected static final Pattern TYPE_VARCHAR;
    protected static final Pattern TYPE_FLOAT;
    private static final Map<String, Integer> RULE_MAP;
    protected static final Pattern PK_UNNAMED_PATTERN;
    protected static final Pattern PK_NAMED_PATTERN;

    protected JDBC3DatabaseMetaData(SQLiteConnection sQLiteConnection) {
        super(sQLiteConnection);
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return Integer.parseInt(this.conn.libversion().split("\\.")[0]);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return Integer.parseInt(this.conn.libversion().split("\\.")[1]);
    }

    @Override
    public int getDriverMajorVersion() {
        return Integer.parseInt(driverVersion.split("\\.")[0]);
    }

    @Override
    public int getDriverMinorVersion() {
        return Integer.parseInt(driverVersion.split("\\.")[1]);
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 2;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 8;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 0;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 0;
    }

    @Override
    public int getResultSetHoldability() {
        return 2;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public String getDatabaseProductName() {
        return "SQLite";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.conn.libversion();
    }

    @Override
    public String getDriverName() {
        return driverName;
    }

    @Override
    public String getDriverVersion() {
        return driverVersion;
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public String getCatalogTerm() {
        return "catalog";
    }

    @Override
    public String getSchemaTerm() {
        return "schema";
    }

    @Override
    public String getProcedureTerm() {
        return "not_implemented";
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String getSQLKeywords() {
        return "ABORT,ACTION,AFTER,ANALYZE,ATTACH,AUTOINCREMENT,BEFORE,CASCADE,CONFLICT,DATABASE,DEFERRABLE,DEFERRED,DESC,DETACH,EXCLUSIVE,EXPLAIN,FAIL,GLOB,IGNORE,INDEX,INDEXED,INITIALLY,INSTEAD,ISNULL,KEY,LIMIT,NOTNULL,OFFSET,PLAN,PRAGMA,QUERY,RAISE,REGEXP,REINDEX,RENAME,REPLACE,RESTRICT,TEMP,TEMPORARY,TRANSACTION,VACUUM,VIEW,VIRTUAL";
    }

    @Override
    public String getNumericFunctions() {
        return "";
    }

    @Override
    public String getStringFunctions() {
        return "";
    }

    @Override
    public String getSystemFunctions() {
        return "";
    }

    @Override
    public String getTimeDateFunctions() {
        return "DATE,TIME,DATETIME,JULIANDAY,STRFTIME";
    }

    @Override
    public String getURL() {
        return this.conn.getUrl();
    }

    @Override
    public String getUserName() {
        return null;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int n2) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int n2) {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return !this.nullsAreSortedAtStart();
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return true;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return !this.nullsAreSortedHigh();
    }

    @Override
    public boolean othersDeletesAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int n2, int n3) {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        String[] stringArray = this.conn.libversion().split("\\.");
        return Integer.parseInt(stringArray[0]) >= 3 && Integer.parseInt(stringArray[1]) >= 39;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n2, int n3) {
        return n2 == 1003 && n3 == 1007;
    }

    @Override
    public boolean supportsResultSetHoldability(int n2) {
        return n2 == 2;
    }

    @Override
    public boolean supportsResultSetType(int n2) {
        return n2 == 1003;
    }

    @Override
    public boolean supportsSavepoints() {
        return true;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n2) {
        return n2 == 8;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean updatesAreDetected(int n2) {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean usesLocalFiles() {
        return true;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        if (this.getAttributes == null) {
            this.getAttributes = this.conn.prepareStatement("select null as TYPE_CAT, null as TYPE_SCHEM, null as TYPE_NAME, null as ATTR_NAME, null as DATA_TYPE, null as ATTR_TYPE_NAME, null as ATTR_SIZE, null as DECIMAL_DIGITS, null as NUM_PREC_RADIX, null as NULLABLE, null as REMARKS, null as ATTR_DEF, null as SQL_DATA_TYPE, null as SQL_DATETIME_SUB, null as CHAR_OCTET_LENGTH, null as ORDINAL_POSITION, null as IS_NULLABLE, null as SCOPE_CATALOG, null as SCOPE_SCHEMA, null as SCOPE_TABLE, null as SOURCE_DATA_TYPE limit 0;");
        }
        return this.getAttributes.executeQuery();
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n2, boolean bl2) throws SQLException {
        if (this.getBestRowIdentifier == null) {
            this.getBestRowIdentifier = this.conn.prepareStatement("select null as SCOPE, null as COLUMN_NAME, null as DATA_TYPE, null as TYPE_NAME, null as COLUMN_SIZE, null as BUFFER_LENGTH, null as DECIMAL_DIGITS, null as PSEUDO_COLUMN limit 0;");
        }
        return this.getBestRowIdentifier.executeQuery();
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        if (this.getColumnPrivileges == null) {
            this.getColumnPrivileges = this.conn.prepareStatement("select null as TABLE_CAT, null as TABLE_SCHEM, null as TABLE_NAME, null as COLUMN_NAME, null as GRANTOR, null as GRANTEE, null as PRIVILEGE, null as IS_GRANTABLE limit 0;");
        }
        return this.getColumnPrivileges.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        Object object;
        this.checkOpen();
        StringBuilder stringBuilder = new StringBuilder(700);
        stringBuilder.append("select null as TABLE_CAT, null as TABLE_SCHEM, tblname as TABLE_NAME, ").append("cn as COLUMN_NAME, ct as DATA_TYPE, tn as TYPE_NAME, colSize as COLUMN_SIZE, ").append("2000000000 as BUFFER_LENGTH, colDecimalDigits as DECIMAL_DIGITS, 10   as NUM_PREC_RADIX, ").append("colnullable as NULLABLE, null as REMARKS, colDefault as COLUMN_DEF, ").append("0    as SQL_DATA_TYPE, 0    as SQL_DATETIME_SUB, 2000000000 as CHAR_OCTET_LENGTH, ").append("ordpos as ORDINAL_POSITION, (case colnullable when 0 then 'NO' when 1 then 'YES' else '' end)").append("    as IS_NULLABLE, null as SCOPE_CATALOG, null as SCOPE_SCHEMA, ").append("null as SCOPE_TABLE, null as SOURCE_DATA_TYPE, ").append("(case colautoincrement when 0 then 'NO' when 1 then 'YES' else '' end) as IS_AUTOINCREMENT, ").append("(case colgenerated when 0 then 'NO' when 1 then 'YES' else '' end) as IS_GENERATEDCOLUMN from (");
        boolean bl2 = false;
        ResultSet resultSet = null;
        try {
            resultSet = this.getTables(string, string2, string3, null);
            while (resultSet.next()) {
                boolean bl3;
                object = resultSet.getString(3);
                Statement statement = this.conn.createStatement();
                ResultSet resultSet2 = null;
                try {
                    statement = this.conn.createStatement();
                    resultSet2 = statement.executeQuery("SELECT LIKE('%autoincrement%', LOWER(sql)) FROM sqlite_schema WHERE LOWER(name) = LOWER('" + this.escape((String)object) + "') AND TYPE IN ('table', 'view')");
                    resultSet2.next();
                    bl3 = resultSet2.getInt(1) == 1;
                }
                finally {
                    if (resultSet2 != null) {
                        try {
                            resultSet2.close();
                        }
                        catch (Exception exception) {
                            LogHolder.logger.error("Could not close ResultSet", exception);
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            LogHolder.logger.error("Could not close statement", exception);
                        }
                    }
                }
                String string5 = "PRAGMA table_xinfo('" + this.escape((String)object) + "')";
                Statement statement2 = this.conn.createStatement();
                try {
                    ResultSet resultSet3 = statement2.executeQuery(string5);
                    try {
                        int n2 = 0;
                        while (resultSet3.next()) {
                            int n3;
                            int n4;
                            String string6 = resultSet3.getString(2);
                            String string7 = resultSet3.getString(3);
                            String string8 = resultSet3.getString(4);
                            String string9 = resultSet3.getString(5);
                            boolean bl4 = "1".equals(resultSet3.getString(6));
                            String string10 = resultSet3.getString(7);
                            int n5 = 2;
                            if (string8 != null) {
                                int n6 = n5 = string8.equals("0") ? 1 : 0;
                            }
                            if (bl2) {
                                stringBuilder.append(" union all ");
                            }
                            bl2 = true;
                            int n7 = 2000000000;
                            int n8 = 10;
                            string7 = string7 == null ? "TEXT" : string7.toUpperCase();
                            int n9 = 0;
                            if (bl4 && bl3) {
                                n9 = 1;
                            }
                            if (TYPE_INTEGER.matcher(string7).find()) {
                                n4 = 4;
                                n8 = 0;
                            } else if (TYPE_VARCHAR.matcher(string7).find()) {
                                n4 = 12;
                                n8 = 0;
                            } else {
                                n4 = TYPE_FLOAT.matcher(string7).find() ? 6 : 12;
                            }
                            int n10 = string7.indexOf(40);
                            if (n10 > 0) {
                                n3 = string7.indexOf(41, n10);
                                if (n3 > 0) {
                                    String string11;
                                    String string12;
                                    int n11 = string7.indexOf(44, n10);
                                    if (n11 > 0) {
                                        string12 = string7.substring(n10 + 1, n11);
                                        string11 = string7.substring(n11 + 1, n3);
                                    } else {
                                        string12 = string7.substring(n10 + 1, n3);
                                        string11 = null;
                                    }
                                    try {
                                        int n12 = Integer.parseUnsignedInt(string12);
                                        if (string11 != null) {
                                            n8 = Integer.parseUnsignedInt(string11);
                                            n7 = n12 + n8;
                                        } else {
                                            n8 = 0;
                                            n7 = n12;
                                        }
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                string7 = string7.substring(0, n10).trim();
                            }
                            n3 = 0;
                            if ("2".equals(string10) || "3".equals(string10)) {
                                n3 = 1;
                            }
                            stringBuilder.append("select ").append(n2 + 1).append(" as ordpos, ").append(n5).append(" as colnullable,").append(n4).append(" as ct, ").append(n7).append(" as colSize, ").append(n8).append(" as colDecimalDigits, ").append("'").append((String)object).append("' as tblname, ").append("'").append(this.escape(string6)).append("' as cn, ").append("'").append(this.escape(string7)).append("' as tn, ").append(JDBC3DatabaseMetaData.quote(string9 == null ? null : this.escape(string9))).append(" as colDefault,").append(n9).append(" as colautoincrement,").append(n3).append(" as colgenerated");
                            if (string4 != null) {
                                stringBuilder.append(" where upper(cn) like upper('").append(this.escape(string4)).append("') ESCAPE '").append(this.getSearchStringEscape()).append("'");
                            }
                            ++n2;
                        }
                    }
                    finally {
                        if (resultSet3 == null) continue;
                        resultSet3.close();
                    }
                }
                finally {
                    if (statement2 == null) continue;
                    statement2.close();
                }
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    LogHolder.logger.error("Could not close ResultSet", exception);
                }
            }
        }
        if (bl2) {
            stringBuilder.append(") order by TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION;");
        } else {
            stringBuilder.append("select null as ordpos, null as colnullable, null as ct, null as colsize, null as colDecimalDigits, null as tblname, null as cn, null as tn, null as colDefault, null as colautoincrement, null as colgenerated) limit 0;");
        }
        object = this.conn.createStatement();
        return ((CoreStatement)object).executeQuery(stringBuilder.toString(), true);
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        if (string3 == null) {
            return this.getExportedKeys(string4, string5, string6);
        }
        if (string6 == null) {
            return this.getImportedKeys(string, string2, string3);
        }
        String string7 = "select " + JDBC3DatabaseMetaData.quote(string) + " as PKTABLE_CAT, " + JDBC3DatabaseMetaData.quote(string2) + " as PKTABLE_SCHEM, " + JDBC3DatabaseMetaData.quote(string3) + " as PKTABLE_NAME, '' as PKCOLUMN_NAME, " + JDBC3DatabaseMetaData.quote(string4) + " as FKTABLE_CAT, " + JDBC3DatabaseMetaData.quote(string5) + " as FKTABLE_SCHEM, " + JDBC3DatabaseMetaData.quote(string6) + " as FKTABLE_NAME, '' as FKCOLUMN_NAME, -1 as KEY_SEQ, 3 as UPDATE_RULE, 3 as DELETE_RULE, '' as FK_NAME, '' as PK_NAME, " + 5 + " as DEFERRABILITY limit 0 ";
        return ((CoreStatement)((Object)this.conn.createStatement())).executeQuery(string7, true);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        if (this.getSchemas == null) {
            this.getSchemas = this.conn.prepareStatement("select null as TABLE_SCHEM, null as TABLE_CATALOG limit 0;");
        }
        return this.getSchemas.executeQuery();
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        if (this.getCatalogs == null) {
            this.getCatalogs = this.conn.prepareStatement("select null as TABLE_CAT limit 0;");
        }
        return this.getCatalogs.executeQuery();
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        PrimaryKeyFinder primaryKeyFinder = new PrimaryKeyFinder(string3);
        String[] stringArray = primaryKeyFinder.getColumns();
        Statement statement = this.conn.createStatement();
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append("select null as TABLE_CAT, null as TABLE_SCHEM, '").append(this.escape(string3)).append("' as TABLE_NAME, cn as COLUMN_NAME, ks as KEY_SEQ, pk as PK_NAME from (");
        if (stringArray == null) {
            stringBuilder.append("select null as cn, null as pk, 0 as ks) limit 0;");
            return ((CoreStatement)((Object)statement)).executeQuery(stringBuilder.toString(), true);
        }
        String string4 = primaryKeyFinder.getName();
        if (string4 != null) {
            string4 = "'" + string4 + "'";
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(" union ");
            }
            stringBuilder.append("select ").append(string4).append(" as pk, '").append(this.escape(this.unquoteIdentifier(stringArray[i2]))).append("' as cn, ").append(i2 + 1).append(" as ks");
        }
        return ((CoreStatement)((Object)statement)).executeQuery(stringBuilder.append(") order by cn;").toString(), true);
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        Iterator iterator;
        PrimaryKeyFinder primaryKeyFinder = new PrimaryKeyFinder(string3);
        String[] stringArray = primaryKeyFinder.getColumns();
        Statement statement = this.conn.createStatement();
        string = string != null ? JDBC3DatabaseMetaData.quote(string) : null;
        string2 = string2 != null ? JDBC3DatabaseMetaData.quote(string2) : null;
        StringBuilder stringBuilder = new StringBuilder(512);
        String string4 = null;
        int n2 = 0;
        if (stringArray != null) {
            ArrayList<String> arrayList;
            iterator = statement.executeQuery("select name from sqlite_schema where type = 'table'");
            try {
                arrayList = new ArrayList<String>();
                while (iterator.next()) {
                    String string5 = iterator.getString(1);
                    arrayList.add(string5);
                    if (!string5.equalsIgnoreCase(string3)) continue;
                    string4 = string5;
                }
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
            for (String string5 : arrayList) {
                ImportedKeyFinder importedKeyFinder = new ImportedKeyFinder(string5);
                List<ImportedKeyFinder.ForeignKey> list = importedKeyFinder.getFkList();
                for (ImportedKeyFinder.ForeignKey foreignKey : list) {
                    String string6 = foreignKey.getPkTableName();
                    if (string6 == null || !string6.equalsIgnoreCase(string4)) continue;
                    for (int i2 = 0; i2 < foreignKey.getColumnMappingCount(); ++i2) {
                        int n3 = i2 + 1;
                        String[] stringArray2 = foreignKey.getColumnMapping(i2);
                        String string7 = stringArray2[1];
                        string7 = string7 == null ? "" : string7;
                        String string8 = stringArray2[0];
                        string8 = string8 == null ? "" : string8;
                        boolean bl2 = false;
                        for (String string9 : stringArray) {
                            if (string9 == null || !string9.equalsIgnoreCase(string7)) continue;
                            bl2 = true;
                            break;
                        }
                        String object = bl2 && primaryKeyFinder.getName() != null ? primaryKeyFinder.getName() : "";
                        stringBuilder.append(n2 > 0 ? " union all select " : "select ").append(n3).append(" as ks, '").append(this.escape(string5)).append("' as fkt, '").append(this.escape(string8)).append("' as fcn, '").append(this.escape(string7)).append("' as pcn, '").append(this.escape(object)).append("' as pkn, ").append(RULE_MAP.get(foreignKey.getOnUpdate())).append(" as ur, ").append(RULE_MAP.get(foreignKey.getOnDelete())).append(" as dr, ");
                        String string10 = foreignKey.getFkName();
                        if (string10 != null) {
                            stringBuilder.append("'").append(this.escape(string10)).append("' as fkn");
                        } else {
                            stringBuilder.append("'' as fkn");
                        }
                        ++n2;
                    }
                }
            }
        }
        boolean bl3 = n2 > 0;
        iterator = new StringBuilder(512);
        ((StringBuilder)((Object)iterator)).append("select ").append(string).append(" as PKTABLE_CAT, ").append(string2).append(" as PKTABLE_SCHEM, ").append(JDBC3DatabaseMetaData.quote(string4)).append(" as PKTABLE_NAME, ").append(bl3 ? "pcn" : "''").append(" as PKCOLUMN_NAME, ").append(string).append(" as FKTABLE_CAT, ").append(string2).append(" as FKTABLE_SCHEM, ").append(bl3 ? "fkt" : "''").append(" as FKTABLE_NAME, ").append(bl3 ? "fcn" : "''").append(" as FKCOLUMN_NAME, ").append(bl3 ? "ks" : "-1").append(" as KEY_SEQ, ").append(bl3 ? "ur" : "3").append(" as UPDATE_RULE, ").append(bl3 ? "dr" : "3").append(" as DELETE_RULE, ").append(bl3 ? "fkn" : "''").append(" as FK_NAME, ").append(bl3 ? "pkn" : "''").append(" as PK_NAME, ").append(5).append(" as DEFERRABILITY ");
        if (bl3) {
            ((StringBuilder)((Object)iterator)).append("from (").append((CharSequence)stringBuilder).append(") ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
        } else {
            ((StringBuilder)((Object)iterator)).append("limit 0");
        }
        return ((CoreStatement)((Object)statement)).executeQuery(((StringBuilder)((Object)iterator)).toString(), true);
    }

    private StringBuilder appendDummyForeignKeyList(StringBuilder stringBuilder) {
        stringBuilder.append("select -1 as ks, '' as ptn, '' as fcn, '' as pcn, ").append(3).append(" as ur, ").append(3).append(" as dr, ").append(" '' as fkn, ").append(" '' as pkn ").append(") limit 0;");
        return stringBuilder;
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        ResultSet resultSet;
        Statement statement = this.conn.createStatement();
        StringBuilder stringBuilder = new StringBuilder(700);
        stringBuilder.append("select ").append(JDBC3DatabaseMetaData.quote(string)).append(" as PKTABLE_CAT, ").append(JDBC3DatabaseMetaData.quote(string2)).append(" as PKTABLE_SCHEM, ").append("ptn as PKTABLE_NAME, pcn as PKCOLUMN_NAME, ").append(JDBC3DatabaseMetaData.quote(string)).append(" as FKTABLE_CAT, ").append(JDBC3DatabaseMetaData.quote(string2)).append(" as FKTABLE_SCHEM, ").append(JDBC3DatabaseMetaData.quote(string3)).append(" as FKTABLE_NAME, ").append("fcn as FKCOLUMN_NAME, ks as KEY_SEQ, ur as UPDATE_RULE, dr as DELETE_RULE, fkn as FK_NAME, pkn as PK_NAME, ").append(5).append(" as DEFERRABILITY from (");
        try {
            resultSet = statement.executeQuery("pragma foreign_key_list('" + this.escape(string3) + "');");
        }
        catch (SQLException sQLException) {
            stringBuilder = this.appendDummyForeignKeyList(stringBuilder);
            return ((CoreStatement)((Object)statement)).executeQuery(stringBuilder.toString(), true);
        }
        ImportedKeyFinder importedKeyFinder = new ImportedKeyFinder(string3);
        List<ImportedKeyFinder.ForeignKey> list = importedKeyFinder.getFkList();
        int n2 = 0;
        while (resultSet.next()) {
            Object object;
            int n3 = resultSet.getInt(2) + 1;
            int n4 = resultSet.getInt(1);
            String string4 = resultSet.getString(3);
            String string5 = resultSet.getString(4);
            String string6 = resultSet.getString(5);
            String string7 = null;
            try {
                object = new PrimaryKeyFinder(string4);
                string7 = ((PrimaryKeyFinder)object).getName();
                if (string6 == null) {
                    string6 = ((PrimaryKeyFinder)object).getColumns()[0];
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            object = resultSet.getString(6);
            String string8 = resultSet.getString(7);
            if (n2 > 0) {
                stringBuilder.append(" union all ");
            }
            String string9 = null;
            if (list.size() > n4) {
                string9 = list.get(n4).getFkName();
            }
            stringBuilder.append("select ").append(n3).append(" as ks,").append("'").append(this.escape(string4)).append("' as ptn, '").append(this.escape(string5)).append("' as fcn, '").append(this.escape(string6)).append("' as pcn,").append("case '").append(this.escape((String)object)).append("'").append(" when 'NO ACTION' then ").append(3).append(" when 'CASCADE' then ").append(0).append(" when 'RESTRICT' then ").append(1).append(" when 'SET NULL' then ").append(2).append(" when 'SET DEFAULT' then ").append(4).append(" end as ur, ").append("case '").append(this.escape(string8)).append("'").append(" when 'NO ACTION' then ").append(3).append(" when 'CASCADE' then ").append(0).append(" when 'RESTRICT' then ").append(1).append(" when 'SET NULL' then ").append(2).append(" when 'SET DEFAULT' then ").append(4).append(" end as dr, ").append(string9 == null ? "''" : JDBC3DatabaseMetaData.quote(string9)).append(" as fkn, ").append(string7 == null ? "''" : JDBC3DatabaseMetaData.quote(string7)).append(" as pkn");
            ++n2;
        }
        resultSet.close();
        if (n2 == 0) {
            stringBuilder = this.appendDummyForeignKeyList(stringBuilder);
        } else {
            stringBuilder.append(") ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ;");
        }
        return ((CoreStatement)((Object)statement)).executeQuery(stringBuilder.toString(), true);
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl2, boolean bl3) throws SQLException {
        String string4;
        Statement statement = this.conn.createStatement();
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("select null as TABLE_CAT, null as TABLE_SCHEM, '").append(this.escape(string3)).append("' as TABLE_NAME, un as NON_UNIQUE, null as INDEX_QUALIFIER, n as INDEX_NAME, ").append(Integer.toString(3)).append(" as TYPE, op as ORDINAL_POSITION, ").append("cn as COLUMN_NAME, null as ASC_OR_DESC, 0 as CARDINALITY, 0 as PAGES, null as FILTER_CONDITION from (");
        ResultSet resultSet = statement.executeQuery("pragma index_list('" + this.escape(string3) + "');");
        ArrayList arrayList = new ArrayList();
        while (resultSet.next()) {
            arrayList.add(new ArrayList());
            ((ArrayList)arrayList.get(arrayList.size() - 1)).add(resultSet.getString(2));
            ((ArrayList)arrayList.get(arrayList.size() - 1)).add(resultSet.getInt(3));
        }
        resultSet.close();
        if (arrayList.size() == 0) {
            stringBuilder.append("select null as un, null as n, null as op, null as cn) limit 0;");
            return ((CoreStatement)((Object)statement)).executeQuery(stringBuilder.toString(), true);
        }
        Iterator iterator = arrayList.iterator();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (iterator.hasNext()) {
            ArrayList arrayList3 = (ArrayList)iterator.next();
            string4 = arrayList3.get(0).toString();
            resultSet = statement.executeQuery("pragma index_info('" + this.escape(string4) + "');");
            while (resultSet.next()) {
                StringBuilder stringBuilder2 = new StringBuilder();
                String string5 = resultSet.getString(3);
                stringBuilder2.append("select ").append(1 - (Integer)arrayList3.get(1)).append(" as un,'").append(this.escape(string4)).append("' as n,").append(resultSet.getInt(1) + 1).append(" as op,");
                if (string5 == null) {
                    stringBuilder2.append("null");
                } else {
                    stringBuilder2.append("'").append(this.escape(string5)).append("'");
                }
                stringBuilder2.append(" as cn");
                arrayList2.add(stringBuilder2.toString());
            }
            resultSet.close();
        }
        string4 = StringUtils.join(arrayList2, " union all ");
        return ((CoreStatement)((Object)statement)).executeQuery(stringBuilder.append(string4).append(");").toString(), true);
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (this.getProcedureColumns == null) {
            this.getProcedureColumns = this.conn.prepareStatement("select null as PROCEDURE_CAT, null as PROCEDURE_SCHEM, null as PROCEDURE_NAME, null as COLUMN_NAME, null as COLUMN_TYPE, null as DATA_TYPE, null as TYPE_NAME, null as PRECISION, null as LENGTH, null as SCALE, null as RADIX, null as NULLABLE, null as REMARKS limit 0;");
        }
        return this.getProcedureColumns.executeQuery();
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        if (this.getProcedures == null) {
            this.getProcedures = this.conn.prepareStatement("select null as PROCEDURE_CAT, null as PROCEDURE_SCHEM, null as PROCEDURE_NAME, null as UNDEF1, null as UNDEF2, null as UNDEF3, null as REMARKS, null as PROCEDURE_TYPE limit 0;");
        }
        return this.getProcedures.executeQuery();
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        if (this.getSuperTables == null) {
            this.getSuperTables = this.conn.prepareStatement("select null as TABLE_CAT, null as TABLE_SCHEM, null as TABLE_NAME, null as SUPERTABLE_NAME limit 0;");
        }
        return this.getSuperTables.executeQuery();
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        if (this.getSuperTypes == null) {
            this.getSuperTypes = this.conn.prepareStatement("select null as TYPE_CAT, null as TYPE_SCHEM, null as TYPE_NAME, null as SUPERTYPE_CAT, null as SUPERTYPE_SCHEM, null as SUPERTYPE_NAME limit 0;");
        }
        return this.getSuperTypes.executeQuery();
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        if (this.getTablePrivileges == null) {
            this.getTablePrivileges = this.conn.prepareStatement("select  null as TABLE_CAT, null as TABLE_SCHEM, null as TABLE_NAME, null as GRANTOR, null GRANTEE,  null as PRIVILEGE, null as IS_GRANTABLE limit 0;");
        }
        return this.getTablePrivileges.executeQuery();
    }

    @Override
    public synchronized ResultSet getTables(String string2, String string3, String string4, String[] stringArray) throws SQLException {
        this.checkOpen();
        string4 = string4 == null || "".equals(string4) ? "%" : this.escape(string4);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT").append("\n");
        stringBuilder.append("  NULL AS TABLE_CAT,").append("\n");
        stringBuilder.append("  NULL AS TABLE_SCHEM,").append("\n");
        stringBuilder.append("  NAME AS TABLE_NAME,").append("\n");
        stringBuilder.append("  TYPE AS TABLE_TYPE,").append("\n");
        stringBuilder.append("  NULL AS REMARKS,").append("\n");
        stringBuilder.append("  NULL AS TYPE_CAT,").append("\n");
        stringBuilder.append("  NULL AS TYPE_SCHEM,").append("\n");
        stringBuilder.append("  NULL AS TYPE_NAME,").append("\n");
        stringBuilder.append("  NULL AS SELF_REFERENCING_COL_NAME,").append("\n");
        stringBuilder.append("  NULL AS REF_GENERATION").append("\n");
        stringBuilder.append("FROM").append("\n");
        stringBuilder.append("  (").append("\n");
        stringBuilder.append("    SELECT\n");
        stringBuilder.append("      'sqlite_schema' AS NAME,\n");
        stringBuilder.append("      'SYSTEM TABLE' AS TYPE");
        stringBuilder.append("    UNION ALL").append("\n");
        stringBuilder.append("    SELECT").append("\n");
        stringBuilder.append("      NAME,").append("\n");
        stringBuilder.append("      UPPER(TYPE) AS TYPE").append("\n");
        stringBuilder.append("    FROM").append("\n");
        stringBuilder.append("      sqlite_schema").append("\n");
        stringBuilder.append("    WHERE").append("\n");
        stringBuilder.append("      NAME NOT LIKE 'sqlite\\_%' ESCAPE '\\'").append("\n");
        stringBuilder.append("      AND UPPER(TYPE) IN ('TABLE', 'VIEW')").append("\n");
        stringBuilder.append("    UNION ALL").append("\n");
        stringBuilder.append("    SELECT").append("\n");
        stringBuilder.append("      NAME,").append("\n");
        stringBuilder.append("      'GLOBAL TEMPORARY' AS TYPE").append("\n");
        stringBuilder.append("    FROM").append("\n");
        stringBuilder.append("      sqlite_temp_master").append("\n");
        stringBuilder.append("    UNION ALL").append("\n");
        stringBuilder.append("    SELECT").append("\n");
        stringBuilder.append("      NAME,").append("\n");
        stringBuilder.append("      'SYSTEM TABLE' AS TYPE").append("\n");
        stringBuilder.append("    FROM").append("\n");
        stringBuilder.append("      sqlite_schema").append("\n");
        stringBuilder.append("    WHERE").append("\n");
        stringBuilder.append("      NAME LIKE 'sqlite\\_%' ESCAPE '\\'").append("\n");
        stringBuilder.append("  )").append("\n");
        stringBuilder.append(" WHERE TABLE_NAME LIKE '");
        stringBuilder.append(string4);
        stringBuilder.append("' ESCAPE '");
        stringBuilder.append(this.getSearchStringEscape());
        stringBuilder.append("'");
        if (stringArray != null && stringArray.length != 0) {
            stringBuilder.append(" AND TABLE_TYPE IN (");
            stringBuilder.append(Arrays.stream(stringArray).map(string -> "'" + string.toUpperCase() + "'").collect(Collectors.joining(",")));
            stringBuilder.append(")");
        }
        stringBuilder.append(" ORDER BY TABLE_TYPE, TABLE_NAME;");
        return ((CoreStatement)((Object)this.conn.createStatement())).executeQuery(stringBuilder.toString(), true);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        this.checkOpen();
        String string = "SELECT 'TABLE' AS TABLE_TYPE UNION SELECT 'VIEW' AS TABLE_TYPE UNION SELECT 'SYSTEM TABLE' AS TABLE_TYPE UNION SELECT 'GLOBAL TEMPORARY' AS TABLE_TYPE;";
        if (this.getTableTypes == null) {
            this.getTableTypes = this.conn.prepareStatement(string);
        }
        this.getTableTypes.clearParameters();
        return this.getTableTypes.executeQuery();
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        if (this.getTypeInfo == null) {
            String string = QueryUtils.valuesQuery(Arrays.asList("TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"), Arrays.asList(Arrays.asList("BLOB", 2004, 0, null, null, null, 1, 0, 3, 1, 0, 0, null, 0, 0, 0, 0, 10), Arrays.asList("INTEGER", 4, 0, null, null, null, 1, 0, 3, 0, 0, 1, null, 0, 0, 0, 0, 10), Arrays.asList("NULL", 0, 0, null, null, null, 1, 0, 3, 1, 0, 0, null, 0, 0, 0, 0, 10), Arrays.asList("REAL", 7, 0, null, null, null, 1, 0, 3, 0, 0, 0, null, 0, 0, 0, 0, 10), Arrays.asList("TEXT", 12, 0, null, null, null, 1, 1, 3, 1, 0, 0, null, 0, 0, 0, 0, 10))) + " order by DATA_TYPE";
            this.getTypeInfo = this.conn.prepareStatement(string);
        }
        this.getTypeInfo.clearParameters();
        return this.getTypeInfo.executeQuery();
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        if (this.getUDTs == null) {
            this.getUDTs = this.conn.prepareStatement("select  null as TYPE_CAT, null as TYPE_SCHEM, null as TYPE_NAME,  null as CLASS_NAME,  null as DATA_TYPE, null as REMARKS, null as BASE_TYPE limit 0;");
        }
        this.getUDTs.clearParameters();
        return this.getUDTs.executeQuery();
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        if (this.getVersionColumns == null) {
            this.getVersionColumns = this.conn.prepareStatement("select null as SCOPE, null as COLUMN_NAME, null as DATA_TYPE, null as TYPE_NAME, null as COLUMN_SIZE, null as BUFFER_LENGTH, null as DECIMAL_DIGITS, null as PSEUDO_COLUMN limit 0;");
        }
        return this.getVersionColumns.executeQuery();
    }

    @Override
    @Deprecated
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("not implemented by SQLite JDBC driver");
    }

    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not yet implemented by SQLite JDBC driver");
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not yet implemented by SQLite JDBC driver");
    }

    @Override
    protected void finalize() throws Throwable {
        this.close();
    }

    private String unquoteIdentifier(String string) {
        if (string == null) {
            return string;
        }
        if ((string = string.trim()).length() > 2 && (string.startsWith("`") && string.endsWith("`") || string.startsWith("\"") && string.endsWith("\"") || string.startsWith("[") && string.endsWith("]"))) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    static {
        try (InputStream inputStream = JDBC3DatabaseMetaData.class.getClassLoader().getResourceAsStream("sqlite-jdbc.properties");){
            if (inputStream == null) {
                throw new IOException("Cannot load sqlite-jdbc.properties from jar");
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            driverName = properties.getProperty("name");
            driverVersion = properties.getProperty("version");
        }
        catch (Exception exception) {
            driverName = "SQLite JDBC";
            driverVersion = "3.0.0-UNKNOWN";
        }
        TYPE_INTEGER = Pattern.compile(".*(INT|BOOL).*");
        TYPE_VARCHAR = Pattern.compile(".*(CHAR|CLOB|TEXT|BLOB).*");
        TYPE_FLOAT = Pattern.compile(".*(REAL|FLOA|DOUB|DEC|NUM).*");
        RULE_MAP = new HashMap<String, Integer>();
        RULE_MAP.put("NO ACTION", 3);
        RULE_MAP.put("CASCADE", 0);
        RULE_MAP.put("RESTRICT", 1);
        RULE_MAP.put("SET NULL", 2);
        RULE_MAP.put("SET DEFAULT", 4);
        PK_UNNAMED_PATTERN = Pattern.compile(".*PRIMARY\\s+KEY\\s*\\((.*?)\\).*", 34);
        PK_NAMED_PATTERN = Pattern.compile(".*CONSTRAINT\\s*(.*?)\\s*PRIMARY\\s+KEY\\s*\\((.*?)\\).*", 34);
    }

    private static class LogHolder {
        private static final Logger logger = LoggerFactory.getLogger(JDBC3DatabaseMetaData.class);

        private LogHolder() {
        }
    }

    class ImportedKeyFinder {
        private final Pattern FK_NAMED_PATTERN = Pattern.compile("CONSTRAINT\\s*\"?([A-Za-z_][A-Za-z\\d_]*)?\"?\\s*FOREIGN\\s+KEY\\s*\\((.*?)\\)", 34);
        private final String fkTableName;
        private final List<ForeignKey> fkList = new ArrayList<ForeignKey>();

        public ImportedKeyFinder(String string) throws SQLException {
            if (string == null || string.trim().length() == 0) {
                throw new SQLException("Invalid table name: '" + string + "'");
            }
            this.fkTableName = string;
            List<String> list = this.getForeignKeyNames(this.fkTableName);
            try (Statement statement = JDBC3DatabaseMetaData.this.conn.createStatement();
                 ResultSet resultSet = statement.executeQuery("pragma foreign_key_list('" + JDBC3DatabaseMetaData.this.escape(this.fkTableName.toLowerCase()) + "')");){
                int n2 = -1;
                int n3 = 0;
                ForeignKey foreignKey = null;
                while (resultSet.next()) {
                    int n4 = resultSet.getInt(1);
                    String string2 = resultSet.getString(3);
                    String string3 = resultSet.getString(4);
                    String string4 = resultSet.getString(5);
                    String string5 = resultSet.getString(6);
                    String string6 = resultSet.getString(7);
                    String string7 = resultSet.getString(8);
                    String string8 = null;
                    if (list.size() > n3) {
                        string8 = list.get(n3);
                    }
                    if (n4 != n2) {
                        foreignKey = new ForeignKey(string8, string2, this.fkTableName, string5, string6, string7);
                        this.fkList.add(foreignKey);
                        n2 = n4;
                        ++n3;
                    }
                    if (foreignKey == null) continue;
                    foreignKey.addColumnMapping(string3, string4);
                }
            }
        }

        private List<String> getForeignKeyNames(String string) throws SQLException {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (string == null) {
                return arrayList;
            }
            try (Statement statement = JDBC3DatabaseMetaData.this.conn.createStatement();
                 ResultSet resultSet = statement.executeQuery("select sql from sqlite_schema where lower(name) = lower('" + JDBC3DatabaseMetaData.this.escape(string) + "')");){
                if (resultSet.next()) {
                    Matcher matcher = this.FK_NAMED_PATTERN.matcher(resultSet.getString(1));
                    while (matcher.find()) {
                        arrayList.add(matcher.group(1));
                    }
                }
            }
            Collections.reverse(arrayList);
            return arrayList;
        }

        public String getFkTableName() {
            return this.fkTableName;
        }

        public List<ForeignKey> getFkList() {
            return this.fkList;
        }

        class ForeignKey {
            private final String fkName;
            private final String pkTableName;
            private final String fkTableName;
            private final List<String> fkColNames = new ArrayList<String>();
            private final List<String> pkColNames = new ArrayList<String>();
            private final String onUpdate;
            private final String onDelete;
            private final String match;

            ForeignKey(String string, String string2, String string3, String string4, String string5, String string6) {
                this.fkName = string;
                this.pkTableName = string2;
                this.fkTableName = string3;
                this.onUpdate = string4;
                this.onDelete = string5;
                this.match = string6;
            }

            public String getFkName() {
                return this.fkName;
            }

            void addColumnMapping(String string, String string2) {
                this.fkColNames.add(string);
                this.pkColNames.add(string2);
            }

            public String[] getColumnMapping(int n2) {
                return new String[]{this.fkColNames.get(n2), this.pkColNames.get(n2)};
            }

            public int getColumnMappingCount() {
                return this.fkColNames.size();
            }

            public String getPkTableName() {
                return this.pkTableName;
            }

            public String getFkTableName() {
                return this.fkTableName;
            }

            public String getOnUpdate() {
                return this.onUpdate;
            }

            public String getOnDelete() {
                return this.onDelete;
            }

            public String getMatch() {
                return this.match;
            }

            public String toString() {
                return "ForeignKey [fkName=" + this.fkName + ", pkTableName=" + this.pkTableName + ", fkTableName=" + this.fkTableName + ", pkColNames=" + this.pkColNames + ", fkColNames=" + this.fkColNames + "]";
            }
        }
    }

    class PrimaryKeyFinder {
        String table;
        String pkName = null;
        String[] pkColumns = null;

        public PrimaryKeyFinder(String string) throws SQLException {
            this.table = string;
            if ("sqlite_schema".equals(string) || "sqlite_master".equals(string)) {
                return;
            }
            if (string == null || string.trim().length() == 0) {
                throw new SQLException("Invalid table name: '" + this.table + "'");
            }
            try (Statement statement = JDBC3DatabaseMetaData.this.conn.createStatement();
                 ResultSet resultSet = statement.executeQuery("select sql from sqlite_schema where lower(name) = lower('" + JDBC3DatabaseMetaData.this.escape(string) + "') and type in ('table', 'view')");){
                if (!resultSet.next()) {
                    throw new SQLException("Table not found: '" + string + "'");
                }
                Matcher matcher = PK_NAMED_PATTERN.matcher(resultSet.getString(1));
                if (matcher.find()) {
                    this.pkName = JDBC3DatabaseMetaData.this.unquoteIdentifier(JDBC3DatabaseMetaData.this.escape(matcher.group(1)));
                    this.pkColumns = matcher.group(2).split(",");
                } else {
                    matcher = PK_UNNAMED_PATTERN.matcher(resultSet.getString(1));
                    if (matcher.find()) {
                        this.pkColumns = matcher.group(1).split(",");
                    }
                }
                if (this.pkColumns == null) {
                    try (ResultSet resultSet2 = statement.executeQuery("pragma table_info('" + JDBC3DatabaseMetaData.this.escape(string) + "');");){
                        while (resultSet2.next()) {
                            if (!resultSet2.getBoolean(6)) continue;
                            this.pkColumns = new String[]{resultSet2.getString(2)};
                        }
                    }
                }
                if (this.pkColumns != null) {
                    for (int i2 = 0; i2 < this.pkColumns.length; ++i2) {
                        this.pkColumns[i2] = JDBC3DatabaseMetaData.this.unquoteIdentifier(this.pkColumns[i2]);
                    }
                }
            }
        }

        public String getName() {
            return this.pkName;
        }

        public String[] getColumns() {
            return this.pkColumns;
        }
    }
}

