/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.util;

import java.text.MessageFormat;
import java.util.logging.Level;
import org.sqlite.util.Logger;

public class LoggerFactory {
    static final boolean USE_SLF4J;

    public static Logger getLogger(Class<?> clazz) {
        if (USE_SLF4J) {
            return new SLF4JLogger(clazz);
        }
        return new JDKLogger(clazz);
    }

    static {
        boolean bl2;
        try {
            Class.forName("org.slf4j.Logger");
            bl2 = true;
        }
        catch (Exception exception) {
            bl2 = false;
        }
        USE_SLF4J = bl2;
    }

    private static class SLF4JLogger
    implements Logger {
        final org.slf4j.Logger logger;

        SLF4JLogger(Class<?> clazz) {
            this.logger = org.slf4j.LoggerFactory.getLogger(clazz);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        @Override
        public void trace(String string, Object object, Object object2) {
            this.logger.trace(string, object, object2);
        }

        @Override
        public void info(String string, Object object, Object object2) {
            this.logger.info(string, object, object2);
        }

        @Override
        public void warn(String string) {
            this.logger.warn(string);
        }

        @Override
        public void error(String string, Throwable throwable) {
            this.logger.error(string, throwable);
        }

        @Override
        public void error(String string, Object object, Throwable throwable) {
            this.logger.error(string, object, (Object)throwable);
        }

        @Override
        public void error(String string, Object object, Object object2, Throwable throwable) {
            this.logger.error(string, object, object2, throwable);
        }
    }

    private static class JDKLogger
    implements Logger {
        final java.util.logging.Logger logger;

        public JDKLogger(Class<?> clazz) {
            this.logger = java.util.logging.Logger.getLogger(clazz.getCanonicalName());
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isLoggable(Level.FINEST);
        }

        @Override
        public void trace(String string, Object object, Object object2) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, MessageFormat.format(string, object, object2));
            }
        }

        @Override
        public void info(String string, Object object, Object object2) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, MessageFormat.format(string, object, object2));
            }
        }

        @Override
        public void warn(String string) {
            this.logger.log(Level.WARNING, string);
        }

        @Override
        public void error(String string, Throwable throwable) {
            this.logger.log(Level.SEVERE, string, throwable);
        }

        @Override
        public void error(String string, Object object, Throwable throwable) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.log(Level.SEVERE, MessageFormat.format(string, object), throwable);
            }
        }

        @Override
        public void error(String string, Object object, Object object2, Throwable throwable) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.log(Level.SEVERE, MessageFormat.format(string, object, object2), throwable);
            }
        }
    }
}

