#!/bin/bash

echo ""
echo "  ========================================"
echo "    DBRecover for Oracle"
echo "  ========================================"
echo ""
echo "  [INFO] This is a GUI program. On Linux, X11 Display must be enabled."
echo "  [INFO] 这是一个 GUI 程序，Linux 上需要开启 X11 图形显示。"
echo ""
echo "  [INFO] All logs written to: log_dbrecover.txt"
echo "  [INFO] 日志文件: log_dbrecover.txt"
echo ""

# Get script directory
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
cd "$SCRIPT_DIR"

# Make Java executable
chmod u+x ./jre/linux/bin/java 2>/dev/null

# Run application
./jre/linux/bin/java -Dfile.encoding=UTF-8 -Xms256m -Xmx2g -jar dbrecover-for-oracle.jar 1>>log_dbrecover.txt 2>&1

EXIT_CODE=$?
if [ $EXIT_CODE -ne 0 ]; then
    echo ""
    echo "  [ERROR] Program exited with code: $EXIT_CODE"
    echo "  [ERROR] Please check log_dbrecover.txt for details."
fi
